/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl;

import com.archivas.clienttools.arcutils.api.ArcMoverEngine;
import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.JobNotFoundException;
import com.archivas.clienttools.arcutils.api.JobStatus;
import com.archivas.clienttools.arcutils.api.ManagedJobStats;
import com.archivas.clienttools.arcutils.api.TooManyQueuedJobsException;
import com.archivas.clienttools.arcutils.api.jobs.DeleteCustomMetadataJob;
import com.archivas.clienttools.arcutils.api.jobs.DirectoryListingJob;
import com.archivas.clienttools.arcutils.api.jobs.GetCustomMetadataJob;
import com.archivas.clienttools.arcutils.api.jobs.GetCustomMetadataStreamJob;
import com.archivas.clienttools.arcutils.api.jobs.GetMetadataJob;
import com.archivas.clienttools.arcutils.api.jobs.JobSpec;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJobSummary;
import com.archivas.clienttools.arcutils.api.jobs.MkdirJob;
import com.archivas.clienttools.arcutils.api.jobs.RenameJob;
import com.archivas.clienttools.arcutils.api.jobs.SetCustomMetadataJob;
import com.archivas.clienttools.arcutils.api.jobs.VersionListingJob;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.JobImpl;
import com.archivas.clienttools.arcutils.impl.adapter.ConnectionTestException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterMgr;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobImpl;
import com.archivas.clienttools.arcutils.model.ACLMetadata;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.model.LoadSchedule;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.Hcp3AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobsSchema;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalJvmArcMoverEngine
implements ArcMoverEngine {
    public static final String PACKAGE_NAME = LocalJvmArcMoverEngine.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = LocalJvmArcMoverEngine.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private static ArcMoverEngine instance = null;

    public static synchronized ArcMoverEngine getInstance() {
        if (instance == null) {
            instance = new LocalJvmArcMoverEngine();
        }
        return instance;
    }

    private LocalJvmArcMoverEngine() {
        this.init();
    }

    protected void init() {
        LocalJvmArcMoverEngine.registerHcapProtocolHandlers();
    }

    private void clearIDifPersisted(JobId jobId) {
        try {
            if (jobId.getId() == (long)HCPMoverProperties.LAST_COPY_JOB_RUN.getAsInt()) {
                HCPMoverProperties.LAST_COPY_JOB_RUN.set("");
                HCPMoverProperties.persist();
            }
        }
        catch (NumberFormatException e) {
            LOG.info("NumberFormatException while getting value for LAST_COPY_JOB_RUN: " + e.getMessage());
        }
        try {
            if (jobId.getId() == (long)HCPMoverProperties.LAST_DELETE_JOB_RUN.getAsInt()) {
                HCPMoverProperties.LAST_DELETE_JOB_RUN.set("");
                HCPMoverProperties.persist();
            }
        }
        catch (NumberFormatException e) {
            LOG.info("NumberFormatException while getting value for LAST_DELETE_JOB_RUN: " + e.getMessage());
        }
        try {
            if (jobId.getId() == (long)HCPMoverProperties.LAST_METADATA_JOB_RUN.getAsInt()) {
                HCPMoverProperties.LAST_METADATA_JOB_RUN.set("");
                HCPMoverProperties.persist();
            }
        }
        catch (NumberFormatException e) {
            LOG.info("NumberFormatException while getting value for LAST_METADATA_JOB_RUN: " + e.getMessage());
        }
    }

    private void writeJobIDToPreferences(ManagedJobImpl jobImpl) {
        if (jobImpl != null && jobImpl.getJobId() != null) {
            switch (jobImpl.getJob().getJobType()) {
                case COPY: {
                    HCPMoverProperties.LAST_COPY_JOB_RUN.set(jobImpl.getJobId().toString());
                    break;
                }
                case DELETE: {
                    HCPMoverProperties.LAST_DELETE_JOB_RUN.set(jobImpl.getJobId().toString());
                    break;
                }
                case SET_METADATA: {
                    HCPMoverProperties.LAST_METADATA_JOB_RUN.set(jobImpl.getJobId().toString());
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported job type: " + (Object)((Object)jobImpl.getJob().getJobType()));
                }
            }
            HCPMoverProperties.persist();
        }
    }

    @Override
    public List<ManagedJobSummary> getAllManagedJobs() throws DatabaseException {
        return ManagedJobsSchema.getInstance().getAllJobs();
    }

    @Override
    public ManagedJobImpl createManagedJob(ManagedJob managedJob) throws JobException {
        try {
            managedJob.initFilesForDBCreate();
            managedJob.setInternalJobName(DateFormat.getDateTimeInstance(3, 2).format(new Date()));
            ManagedJobImpl jobImpl = ManagedJobsSchema.getInstance().insertJob(managedJob);
            jobImpl.parseListFile();
            return jobImpl;
        }
        catch (Exception e) {
            throw new JobException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void modifyManagedJob(JobId jobId, ManagedJob modifiedJob) throws JobException {
        try {
            ManagedJobsSchema.getInstance().updateJob(jobId, modifiedJob);
        }
        catch (Exception e) {
            throw new JobException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void modifyManagedJobName(JobId jobId, String name) throws JobException {
        try {
            ManagedJobsSchema.getInstance().updateJobName(jobId, name);
        }
        catch (Exception e) {
            throw new JobException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void modifyManagedJobLoadSchedule(JobId jobId, LoadSchedule loadSchedule) throws JobException {
        try {
            ManagedJobsSchema.getInstance().updateLoadSchedule(jobId, loadSchedule);
        }
        catch (Exception e) {
            throw new JobException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void removeManagedJob(JobId jobId, ManagedJob.Type type) throws JobException {
        this.clearIDifPersisted(jobId);
        try {
            ManagedJobsSchema.getInstance().deleteJob(jobId, type);
        }
        catch (Exception e) {
            throw new JobException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ManagedJobImpl loadManagedJob(JobId jobId, ManagedJob.Type type) throws JobException {
        try {
            return ManagedJobsSchema.getInstance().getManagedJob(jobId, type);
        }
        catch (Exception e) {
            throw new JobException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ManagedJobImpl startManagedJob(ManagedJobImpl jobImpl) throws JobException, TooManyQueuedJobsException {
        this.writeJobIDToPreferences(jobImpl);
        if (jobImpl.validateJob()) {
            this.runJob(jobImpl);
        } else {
            this.cancelManagedJob(jobImpl);
        }
        return jobImpl;
    }

    @Override
    public void stopManagedJob(ManagedJobImpl job) throws JobException {
        job.stop();
    }

    @Override
    public void cancelManagedJob(ManagedJobImpl job) throws JobException {
        job.cancel();
    }

    @Override
    public ManagedJobImpl.JobDetails getManagedJobDetails(ManagedJobImpl job, boolean includeLists) throws JobNotFoundException {
        return job.getDetails(includeLists);
    }

    @Override
    public ManagedJobStats getManagedJobStats(ManagedJobImpl job) throws JobNotFoundException {
        return (ManagedJobStats)job.getStats();
    }

    private void runJob(final ManagedJobImpl job) {
        Runnable jobRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    job.start();
                }
                catch (Throwable e) {
                    LOG.log(Level.WARNING, "Unexpected exception running Job: " + job, e);
                    job.setJobException(e);
                    try {
                        job.setStatus(JobStatus.FAILED);
                    }
                    catch (JobException e1) {
                        LOG.log(Level.WARNING, "Unable to set job status to FAILED for Job: " + job, e);
                    }
                }
            }
        };
        new Thread(jobRunner).start();
    }

    public static void registerHcapProtocolHandlers() {
        String handler = "com.archivas.clienttools.arcutils.impl.adapter";
        String handlers = System.getProperty("java.protocol.handler.pkgs");
        if (handlers == null) {
            System.setProperty("java.protocol.handler.pkgs", handler);
        } else if (!(handlers = handlers.trim()).contains(handler)) {
            if (!handlers.endsWith("|")) {
                handlers = handlers + "|";
            }
            handlers = handlers + handler;
            System.setProperty("java.protocol.handler.pkgs", handlers);
        }
    }

    public Object runJob(JobSpec job) throws JobException {
        JobImpl jobImpl = JobImpl.getInstance(job);
        jobImpl.start();
        Object result = jobImpl.getResult();
        Throwable t = jobImpl.getJobException();
        JobException jobException = null;
        if (t != null) {
            if (t instanceof JobException) {
                jobException = (JobException)t;
                jobException.setJobId(jobImpl.getJobId());
            } else {
                jobException = new JobException(jobImpl.getJobId(), "Unexpected Error running Job", t);
            }
        }
        if (jobException != null) {
            throw jobException;
        }
        return result;
    }

    @Override
    public ArcMoverDirectory getDirectoryListing(StorageAdapter adapter, String path, boolean forceGetOfAllMetadata) throws JobException {
        ArcMoverDirectory dir;
        try {
            DirectoryListingJob job = new DirectoryListingJob(adapter, path, forceGetOfAllMetadata);
            LOG.log(Level.FINE, "Created job: {0}", job);
            Object result = this.runJob(job);
            dir = (ArcMoverDirectory)result;
        }
        catch (JobException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobException(null, "Unexpected Error getting directory listing.", e);
        }
        return dir;
    }

    @Override
    public ArcMoverDirectory getDirectoryListing(AbstractProfileBase profile, String path, boolean forceGetOfAllMetadata) throws JobException {
        StorageAdapter adapter = StorageAdapterMgr.getStorageAdapter(profile);
        return this.getDirectoryListing(adapter, path, forceGetOfAllMetadata);
    }

    @Override
    public ArcMoverDirectory getVersionListing(AbstractProfileBase profile, String path) throws JobException {
        ArcMoverDirectory dir;
        try {
            StorageAdapter adapter = StorageAdapterMgr.getStorageAdapter(profile);
            VersionListingJob job = new VersionListingJob(adapter, path);
            LOG.log(Level.FINE, "Created job: {0}", job);
            Object result = this.runJob(job);
            dir = (ArcMoverDirectory)result;
        }
        catch (JobException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobException(null, "Unexpected Error getting directory listing.", e);
        }
        return dir;
    }

    @Override
    public boolean isVersioningEnabled(AbstractProfileBase profile) throws StorageAdapterException {
        StorageAdapter adapter = StorageAdapterMgr.getStorageAdapter(profile);
        return adapter.isVersioningEnabled();
    }

    public SSLCertChain getSSLCerts(AbstractProfileBase profile, SSLCertificateCallback sslExceptionCallback) throws JobException {
        throw new UnsupportedOperationException("getSSLCerts");
    }

    @Override
    public boolean testConnection(AbstractProfileBase profile) throws ConnectionTestException {
        try {
            StorageAdapter adapter = StorageAdapterMgr.getStorageAdapter(profile);
            return adapter.testConnection();
        }
        catch (ConnectionTestException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unexpected exception during testConnection", e);
            String namespace = null;
            if (profile.getType().isAuthNamespace()) {
                namespace = ((Hcp3AuthNamespaceProfile)profile).getNamespace();
            }
            throw new ConnectionTestException(e, null, namespace, profile.getName());
        }
    }

    @Override
    public FileMetadata getMetadata(AbstractProfileBase profile, String path, FileType fileType) throws JobException {
        FileMetadata metadata;
        try {
            GetMetadataJob job = new GetMetadataJob(profile, path, fileType);
            metadata = (FileMetadata)this.runJob(job);
        }
        catch (JobException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobException(null, "Unexpected Error getting directory listing.", e);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            String msg = "MetaData for {0}:{1}{2}";
            Object[] objs = new Object[]{path, System.getProperty("line.separator"), metadata};
            LOG.log(Level.FINEST, msg, objs);
        }
        return metadata;
    }

    @Override
    public String getCustomMetadata(AbstractProfileBase profile, String path, Long version, FileType fileType) throws JobException {
        String metadata;
        try {
            GetCustomMetadataJob job = new GetCustomMetadataJob(profile, path, version, fileType);
            metadata = (String)this.runJob(job);
        }
        catch (JobException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobException(null, "Unexpected Error getting custom metadata.", e);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            String msg = "MetaData for {0}:{1}{2}";
            Object[] objs = new Object[]{path, System.getProperty("line.separator"), metadata};
            LOG.log(Level.FINEST, msg, objs);
        }
        return metadata;
    }

    @Override
    public InputStream getCustomMetadataStream(AbstractProfileBase profile, String path, Long version, FileType fileType, StorageAdapter adapter) throws JobException {
        return this.getCustomMetadataStream(profile, path, version, fileType, adapter, null);
    }

    @Override
    public InputStream getCustomMetadataStream(AbstractProfileBase profile, String path, Long version, FileType fileType, StorageAdapter adapter, String annotation) throws JobException {
        InputStream metadataStream;
        try {
            GetCustomMetadataStreamJob job = new GetCustomMetadataStreamJob(profile, path, version, fileType, adapter, annotation);
            metadataStream = (InputStream)this.runJob(job);
        }
        catch (JobException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobException(null, "Unexpected Error getting custom metadata stream.", e);
        }
        return metadataStream;
    }

    @Override
    public void deleteCustomMetadata(AbstractProfileBase profile, String path) throws JobException {
        try {
            DeleteCustomMetadataJob job = new DeleteCustomMetadataJob(profile, path);
            this.runJob(job);
        }
        catch (JobException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobException(null, "Unexpected Error deleting custom metadata.", e);
        }
    }

    @Override
    public void setACL(AbstractProfileBase profile, String fileURL, ACLMetadata metadata) throws JobException {
        try {
            StorageAdapter sourceAdapter = StorageAdapterMgr.getStorageAdapter(profile);
            InputStream aclStream = metadata.getStream(profile, sourceAdapter);
            try {
                sourceAdapter.setACLFromStream(fileURL, aclStream);
            }
            catch (StorageAdapterException e) {
                LOG.log(Level.WARNING, "Error setting ACL for: " + fileURL, e);
                throw new JobException(e.getMessage(), (Throwable)e);
            }
            finally {
                sourceAdapter.close();
                try {
                    aclStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (JobException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unexpected error setting ACL for: " + fileURL, e);
            throw new JobException("Unexpected error setting ACL:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void deleteACL(AbstractProfileBase profile, String path) throws JobException {
        try {
            this.setACL(profile, path, ACLMetadata.newEmptyACL());
        }
        catch (JobException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unexpected error deleting ACL for: " + path, e);
            throw new JobException("Unexpected error deleting ACL:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setCustomMetadata(AbstractProfileBase profile, String filePath, String metadata) throws JobException {
        try {
            SetCustomMetadataJob job = new SetCustomMetadataJob(profile, filePath, metadata);
            this.runJob(job);
        }
        catch (JobException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobException(null, "Unexpected Error setting custom metadata.", e);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            String msg = "MetaData for {0}:{1}{2}";
            Object[] objs = new Object[]{filePath, System.getProperty("line.separator"), metadata};
            LOG.log(Level.FINEST, msg, objs);
        }
    }

    @Override
    public boolean mkdir(AbstractProfileBase profile, String targetPath) throws JobException {
        try {
            MkdirJob job = new MkdirJob(profile, targetPath);
            boolean result = (Boolean)this.runJob(job);
            return result;
        }
        catch (JobException e) {
            throw e;
        }
        catch (Exception e) {
            Object[] objs = new Object[]{targetPath};
            String msg = MessageFormat.format("Unexpected Error getting directory listing for url: {0}", objs);
            throw new JobException(null, msg, e);
        }
    }

    @Override
    public boolean renameTo(AbstractProfileBase profile, String basePath, String currentName, String newName) throws JobException {
        try {
            RenameJob job = new RenameJob(profile, basePath, currentName, newName);
            boolean result = (Boolean)this.runJob(job);
            return result;
        }
        catch (JobException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Unexpected Error renaming baseurl={0}, currentName={1}, newName={2}";
            Object[] objs = new Object[]{basePath, currentName, newName};
            throw new JobException(null, MessageFormat.format(msg, objs), e);
        }
    }
}

