/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.adapter;

import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterLiteralException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;

public class ConnectionTestException
extends StorageAdapterLiteralException {
    private boolean stockMessage = true;
    private String namespace = null;
    private String profileName = null;

    public ConnectionTestException() {
        this((Integer)null);
    }

    public ConnectionTestException(Integer statusCode) {
        super("Could not connect", statusCode);
    }

    public ConnectionTestException(String namespace, String profileName) {
        this.namespace = namespace;
        this.profileName = profileName;
    }

    public ConnectionTestException(String message, Integer statusCode) {
        super(message, statusCode);
        this.stockMessage = false;
    }

    public ConnectionTestException(Throwable cause, Integer statusCode, String namespace, String profileName) {
        super(cause, statusCode);
        this.namespace = namespace;
        this.profileName = profileName;
    }

    public ConnectionTestException(Integer statusCode, String namespace, String profileName) {
        this(statusCode);
        this.namespace = namespace;
        this.profileName = profileName;
    }

    @Override
    public String getMessage() {
        String errorMsg;
        Throwable rootCause = this;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        if (rootCause instanceof SSLException) {
            StringBuilder errorMsgBuilder = new StringBuilder("SSL certificate is not trusted");
            if (this.namespace != null) {
                errorMsgBuilder.append(" for namespace ");
                errorMsgBuilder.append(this.namespace);
            }
            if (this.profileName != null) {
                errorMsgBuilder.append(" using profile ");
                errorMsgBuilder.append(this.profileName);
            }
            errorMsgBuilder.append('.');
            errorMsg = errorMsgBuilder.toString();
        } else if (rootCause instanceof ConnectException || rootCause instanceof UnknownHostException) {
            errorMsg = "Could not connect to the server";
            if (this.profileName != null) {
                errorMsg = errorMsg + " using profile " + this.profileName;
            }
        } else if (rootCause instanceof ConnectionTestException) {
            StringBuilder errorMsgBuilder = new StringBuilder();
            if (this.getStatusCode() != null) {
                errorMsgBuilder.append(this.getStatusCode());
                errorMsgBuilder.append(" - ");
            }
            errorMsgBuilder.append(super.getMessage());
            if (this.stockMessage) {
                if (this.namespace != null) {
                    errorMsgBuilder.append(" to namespace ");
                    errorMsgBuilder.append(this.namespace);
                } else {
                    errorMsgBuilder.append(" to the namespace");
                }
                if (this.profileName != null) {
                    errorMsgBuilder.append(" using profile ");
                    errorMsgBuilder.append(this.profileName);
                }
            }
            errorMsgBuilder.append('.');
            errorMsg = errorMsgBuilder.toString();
        } else if (rootCause instanceof StorageAdapterLiteralException) {
            errorMsg = "Could not connect to the server.  ";
            errorMsg = errorMsg + rootCause.getMessage();
        } else {
            StringBuilder errorMsgBuilder = new StringBuilder();
            if (this.getStatusCode() != null) {
                errorMsgBuilder.append(this.getStatusCode());
                errorMsgBuilder.append(" - ");
            }
            errorMsgBuilder.append("Could not connect");
            if (this.namespace != null) {
                errorMsgBuilder.append(" to namespace ");
                errorMsgBuilder.append(this.namespace);
            } else {
                errorMsgBuilder.append(" to the namespace");
            }
            if (this.profileName != null) {
                errorMsgBuilder.append(" using profile ");
                errorMsgBuilder.append(this.profileName);
            }
            errorMsgBuilder.append('.');
            errorMsg = errorMsgBuilder.toString();
        }
        return errorMsg;
    }
}

