/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.adapter;

import com.archivas.clienttools.arcutils.impl.adapter.FileSystemAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.Hcap2Adapter;
import com.archivas.clienttools.arcutils.impl.adapter.Hcp3AuthNamespaceAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.Hcp3DefaultNamespaceAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.Hcp5AuthNamespaceAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.Hcp6AuthNamespaceAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterFactory;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.Hcap2Profile;
import com.archivas.clienttools.arcutils.profile.Hcp3AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.Hcp3DefaultNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.Hcp5AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.Hcp6AuthNamespaceProfile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.impl.client.AbstractHttpClient;

public class DefaultStorageAdapterFactory
implements StorageAdapterFactory {
    private static Logger LOG = Logger.getLogger(DefaultStorageAdapterFactory.class.getName());

    @Override
    public StorageAdapter getStorageAdapterInstance(AbstractProfileBase profile, AbstractHttpClient httpClient) {
        StorageAdapter adapter = null;
        if (profile == null) {
            return null;
        }
        try {
            switch (profile.getType()) {
                case HCAP2: {
                    adapter = new Hcap2Adapter((Hcap2Profile)profile, profile.getSSLExceptionCallback(), httpClient);
                    break;
                }
                case HCP_DEFAULT: {
                    adapter = new Hcp3DefaultNamespaceAdapter((Hcp3DefaultNamespaceProfile)profile, profile.getSSLExceptionCallback(), httpClient);
                    break;
                }
                case HCP: {
                    adapter = new Hcp3AuthNamespaceAdapter((Hcp3AuthNamespaceProfile)profile, profile.getSSLExceptionCallback(), httpClient);
                    break;
                }
                case HCP50: {
                    adapter = new Hcp5AuthNamespaceAdapter((Hcp5AuthNamespaceProfile)profile, profile.getSSLExceptionCallback(), httpClient);
                    break;
                }
                case HCP60: {
                    adapter = new Hcp6AuthNamespaceAdapter((Hcp6AuthNamespaceProfile)profile, profile.getSSLExceptionCallback(), httpClient);
                    break;
                }
                case FILESYSTEM: {
                    adapter = new FileSystemAdapter();
                    break;
                }
                default: {
                    adapter = null;
                    break;
                }
            }
        }
        catch (StorageAdapterException e) {
            LOG.log(Level.WARNING, "StorageAdapterException creating adapter", e);
        }
        if (adapter == null) {
            String msg = "No StorageAdapter is available for profile: " + profile.getName();
            throw new RuntimeException(msg);
        }
        return adapter;
    }
}

