/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.adapter;

import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterLiteralException;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.ArcMoverSymlink;
import com.archivas.clienttools.arcutils.model.CustomMetadataTooLargeException;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.FileSystemProfile;
import com.archivas.clienttools.arcutils.utils.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;

public class FileSystemAdapter
implements StorageAdapter {
    public static Logger LOG = Logger.getLogger(FileSystemAdapter.class.getName());
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private OutputStream writeStream = null;
    private AbstractProfileBase profile = FileSystemProfile.LOCAL_FILESYSTEM_PROFILE;

    @Override
    public String getDebugName() {
        return "FileSystemAdapter";
    }

    @Override
    public AbstractProfileBase getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(AbstractProfileBase profile) {
        this.profile = profile;
    }

    @Override
    public void abortASAP() {
    }

    @Override
    public void mkdir(String path, FileMetadata ignored) throws StorageAdapterLiteralException {
        File dirPath = new File(path);
        if (dirPath.exists()) {
            throw new StorageAdapterLiteralException("Directory already exists");
        }
        if (!FileUtil.mkdirs(this.getProfile().resolvePath(path))) {
            throw new StorageAdapterLiteralException("Error creating a new directory");
        }
    }

    @Override
    public void mkSymlink(String symlinkName, String symlinkTarget) throws StorageAdapterException {
        try {
            File link = new File(symlinkName);
            File target = new File(symlinkTarget);
            this.mkParentDirs(link);
            Files.createSymbolicLink(link.toPath(), target.toPath(), new FileAttribute[0]);
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            if (e instanceof FileAlreadyExistsException) {
                errMsg = "the file already exists";
            }
            errMsg = String.format("Error creating symlink %s to target %s: %s", symlinkName, symlinkTarget, errMsg);
            LOG.log(Level.WARNING, errMsg, e);
            throw new StorageAdapterException(errMsg, e);
        }
    }

    @Override
    public void delete(String path, boolean isDirectory, DeleteJob.Operation operation, String reason) throws StorageAdapterLiteralException {
        File f = new File(path);
        boolean result = f.delete();
        if (!result) {
            throw new StorageAdapterLiteralException("Could not delete file " + f.getName());
        }
    }

    @Override
    public InputStream getInputStream(String path, String unused) throws StorageAdapterException {
        try {
            File f = new File(this.getProfile().resolvePath(path));
            if (!f.isFile() || !f.canRead()) {
                throw new StorageAdapterException(String.format("%s is not readable", path));
            }
            this.inputStream = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new StorageAdapterLiteralException("Error reading file " + path + "  from file system");
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream(String path) throws StorageAdapterException {
        File f = new File(path);
        this.mkParentDirs(f);
        try {
            this.outputStream = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new StorageAdapterLiteralException("Error creating file " + path + " on file system: " + e.getMessage());
        }
        return this.outputStream;
    }

    private void mkParentDirs(File f) throws StorageAdapterLiteralException {
        File dir = f.getParentFile();
        if (dir != null && !dir.exists()) {
            FileUtil.mkdirs(dir.getPath());
            if (!dir.exists()) {
                throw new StorageAdapterLiteralException("Could not create directory: " + dir.getPath());
            }
        }
    }

    public void writeStream(String targetPath, InputStream is) throws StorageAdapterException {
        this.writeObjectFromStream(targetPath, is, null);
    }

    @Override
    public void writeObjectFromStream(String targetPath, InputStream is, FileMetadata ingestionMetadata) throws StorageAdapterException {
        this.writeStream = this.getOutputStream(this.getProfile().resolvePath(targetPath));
        byte[] buffer = new byte[1024];
        try {
            int bytesRead = is.read(buffer);
            while (bytesRead >= 0) {
                this.writeStream.write(buffer, 0, bytesRead);
                bytesRead = is.read(buffer);
            }
        }
        catch (IOException e) {
            throw new StorageAdapterLiteralException("Error writing file " + targetPath + " to file system: " + e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (this.writeStream != null) {
                try {
                    this.writeStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void setMetadata(String path, FileMetadata metadata) throws StorageAdapterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(String parentDirectoryPath, String oldName, String newName) throws StorageAdapterException {
        String newPath;
        File newFile;
        String oldPath = this.getProfile().resolvePath(FileUtil.resolvePath(parentDirectoryPath, oldName, this.getProfile().getPathSeparator()));
        File oldFile = new File(oldPath);
        boolean result = oldFile.renameTo(newFile = new File(newPath = this.getProfile().resolvePath(FileUtil.resolvePath(parentDirectoryPath, newName, this.getProfile().getPathSeparator()))));
        if (!result) {
            String slug = oldFile.isDirectory() ? "directory" : "file";
            throw new StorageAdapterLiteralException(String.format("Could not rename %s %s to %s ", slug, oldFile.getName(), newFile.getName()));
        }
    }

    @Override
    public boolean exists(String path) {
        return new File(this.getProfile().resolvePath(path)).exists();
    }

    @Override
    public ArcMoverDirectory getDirectory(String path, boolean forceGetAllMetadata) throws StorageAdapterException {
        File dir = new File(this.getProfile().resolvePath(path));
        if (!dir.isDirectory()) {
            throw new StorageAdapterLiteralException("Directory could not be found.");
        }
        ArcMoverDirectory arcDir = ArcMoverDirectory.getDirInstance(FileSystemProfile.LOCAL_FILESYSTEM_PROFILE, dir.getPath(), this);
        return arcDir;
    }

    @Override
    public ArcMoverFile createArcMoverFileObject(XMLStreamReader xmlr, ArcMoverDirectory caller) throws StorageAdapterException {
        throw new UnsupportedOperationException("LFS adapter does not support population from XML.");
    }

    private ArcMoverFile createFile(ArcMoverDirectory caller, String path) {
        File file = new File(caller.getPath(), path);
        Path filePath = file.toPath();
        boolean isSymbolicLink = Files.isSymbolicLink(filePath);
        if (file.exists() || isSymbolicLink) {
            ArcMoverFile arcFile;
            FileMetadata metadata = null;
            if (isSymbolicLink) {
                try {
                    Path symlinkTarget = Files.readSymbolicLink(filePath);
                    if (symlinkTarget == null) {
                        throw new NoSuchElementException("No target for symbolic link " + filePath);
                    }
                    metadata = new FileMetadata(FileType.SYMLINK);
                    metadata.setSymlinkTarget(symlinkTarget.toString());
                }
                catch (IOException e) {
                    String errMsg = "Error reading target of symbolic link " + filePath;
                    LOG.log(Level.WARNING, errMsg, e);
                    throw new NoSuchElementException(errMsg);
                }
            } else if (file.isDirectory()) {
                metadata = new FileMetadata(FileType.DIRECTORY);
            } else {
                metadata = new FileMetadata(FileType.FILE);
                metadata.setSize(file.length());
            }
            metadata.setModTime(new Date(file.lastModified()));
            metadata.setHidden(file.isHidden());
            if (isSymbolicLink) {
                arcFile = new ArcMoverSymlink(this.getProfile(), caller, file.getName(), metadata, this);
            } else if (file.isDirectory()) {
                FileSystemAdapter fsAdapter = new FileSystemAdapter();
                try {
                    arcFile = fsAdapter.getDirectory(file.getAbsolutePath(), true);
                    arcFile.setMetadata(metadata);
                }
                catch (StorageAdapterException e) {
                    LOG.log(Level.WARNING, e.getMessage(), e);
                    throw new NoSuchElementException("Exception while getting directory object: " + e.getMessage());
                }
            } else {
                arcFile = ArcMoverFile.getFileInstance(this.getProfile(), caller, file.getName(), metadata);
            }
            return arcFile;
        }
        throw new NoSuchElementException("File does not exist; skipping: " + file.getAbsolutePath());
    }

    @Override
    public Iterator<ArcMoverFile> getFileListIterator(ArcMoverDirectory caller, boolean includeDeleted, boolean supportsVersioning) throws StorageAdapterException {
        return new LocalFileSystemIterator(caller);
    }

    @Override
    public ArcMoverDirectory getVersions(String path) throws StorageAdapterException {
        return null;
    }

    @Override
    public long getFileSize(ArcMoverFile file) throws StorageAdapterException {
        File f = new File(this.getProfile().resolvePath(file.getPath()));
        return f.length();
    }

    @Override
    public FileMetadata getMetadata(String path, String queryString, FileType fileType, boolean isVersion) throws StorageAdapterException {
        File f = new File(this.getProfile().resolvePath(path));
        boolean isDir = f.isDirectory();
        FileMetadata md = new FileMetadata(isDir ? FileType.DIRECTORY : FileType.FILE);
        md.setModTime(new Date(f.lastModified()));
        if (!isDir) {
            md.setSize(f.length());
        }
        md.setHidden(f.isHidden());
        return md;
    }

    @Override
    public String getCustomMetadata(String path, Long version, FileType fileType) throws StorageAdapterException {
        StringBuilder result;
        block9: {
            LOG.log(Level.SEVERE, "FileSystemAdapter.getCustomMetadata() in use", new Exception("For debugging purposes only"));
            long maxCmdLength = HCPMoverProperties.CM_MAX_IN_MEMORY_SIZE.getAsLong();
            result = new StringBuilder();
            try {
                BufferedReader input = null;
                if (fileType != FileType.FILE) break block9;
                try {
                    File cmFile = new File(this.getProfile().resolvePath(path));
                    input = new BufferedReader(new FileReader(cmFile));
                    String line = null;
                    while ((line = input.readLine()) != null) {
                        result.append(line);
                        result.append(System.getProperty("line.separator"));
                        if ((long)result.length() <= maxCmdLength) continue;
                        throw new CustomMetadataTooLargeException();
                    }
                }
                catch (FileNotFoundException e) {
                    throw new StorageAdapterLiteralException("Custom Metadata file not found " + path, e);
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            catch (IOException e) {
                throw new StorageAdapterLiteralException("IO Error reading custom metadata file: " + path, e);
            }
        }
        return result.toString();
    }

    @Override
    public void setCustomMetadata(String file, String metadata) throws StorageAdapterException {
    }

    @Override
    public void deleteCustomMetadata(String path) throws StorageAdapterException {
    }

    @Override
    public InputStream getCustomMetadataStream(String path, Long version, FileType fileType) throws StorageAdapterException {
        return this.getCustomMetadataStream(path, version, fileType, null);
    }

    @Override
    public InputStream getCustomMetadataStream(String path, Long version, FileType fileType, String annotation) throws StorageAdapterException {
        FileInputStream result = null;
        if (fileType == FileType.FILE) {
            try {
                result = new FileInputStream(this.getProfile().resolvePath(path));
            }
            catch (FileNotFoundException e) {
                throw new StorageAdapterException("Custom Metadata file not found " + path, e);
            }
        }
        return result;
    }

    @Override
    public void setCustomMetadataStream(String file, InputStream metadata) throws StorageAdapterException {
        this.setCustomMetadataStream(file, metadata, null);
    }

    @Override
    public void setCustomMetadataStream(String file, InputStream metadata, String annotation) throws StorageAdapterException {
    }

    @Override
    public InputStream getACLStream(String path) throws StorageAdapterException {
        return null;
    }

    @Override
    public void setACLFromStream(String path, InputStream aclStream) throws StorageAdapterException {
    }

    @Override
    public void cancel() {
        this.close();
    }

    @Override
    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.inputStream = null;
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.outputStream = null;
        if (this.writeStream != null) {
            try {
                this.writeStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.writeStream = null;
    }

    @Override
    public int getMaxNumSimultaneousHttpConnections(int maxConnectionsPerRoute) {
        return HCPMoverProperties.MAXTHREADS_FILESYSTEM.getAsInt();
    }

    @Override
    public boolean testConnection() {
        return this.exists("/");
    }

    @Override
    public boolean copyDirMetadataWhenMigrating() {
        return false;
    }

    @Override
    public boolean isVersioningEnabled() throws StorageAdapterException {
        return false;
    }

    private class LocalFileSystemIterator
    implements Iterator<ArcMoverFile> {
        private Iterator<String> iterator;
        private ArcMoverDirectory caller;

        LocalFileSystemIterator(ArcMoverDirectory caller) throws StorageAdapterException {
            this.caller = caller;
            File startDir = new File(caller.getPath());
            if (!startDir.isDirectory()) {
                throw new StorageAdapterException("Not a directory: " + caller.getPath());
            }
            String[] fileArray = startDir.list();
            if (fileArray == null) {
                throw new StorageAdapterException("Cannot access directory: " + caller.getPath());
            }
            this.iterator = Arrays.asList(fileArray).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ArcMoverFile next() {
            return FileSystemAdapter.this.createFile(this.caller, this.iterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

