/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.adapter;

import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.adapter.ConnectionTestException;
import com.archivas.clienttools.arcutils.impl.adapter.HCAPDirectoryList;
import com.archivas.clienttools.arcutils.impl.adapter.Hcap2Adapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterHttpRetryException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterLiteralException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterRetryAndFailJobException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterServerRetryException;
import com.archivas.clienttools.arcutils.model.ArcCapacity;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.CustomMetadataTooLargeException;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.LoadSchedule;
import com.archivas.clienttools.arcutils.profile.HCAPProfile;
import com.archivas.clienttools.arcutils.utils.net.GetCertsX509TrustManager;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.BindException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.xml.stream.XMLStreamException;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public abstract class HCAPAdapter
implements StorageAdapter {
    public static final String DIRECTORY = "directory";
    public static final String FILE = "file";
    public static final String DOT = ".";
    public static final String OBJECT = "object";
    public static final String SYMLINK = "symlink";
    public static Logger LOG = Logger.getLogger(Hcap2Adapter.class.getName());
    public static final int MAX_NUM_CONNECTIONS_PER_NODE = 250;
    private static final int CM_BUFFER_SIZE = 4096;
    protected String debugName;
    protected static int adapterCnt = 0;
    protected final Object savingCookieLock = new Object();
    protected HcapAdapterCookie savedCookie;
    protected AbstractHttpClient httpClient = null;
    protected SSLCertificateCallback sslExceptionCallback;
    private boolean abortASAP = false;
    private static Map<Integer, String> statusMessages = new HashMap<Integer, String>();

    public static String getMessageFromStatusCode(int statusCode) throws StorageAdapterException {
        String m = statusMessages.get(statusCode);
        return m == null ? Integer.toString(statusCode) : m;
    }

    @Override
    public String getDebugName() {
        return this.debugName;
    }

    public abstract SSLCertChain getSSLCerts() throws IOException, StorageAdapterException;

    protected abstract void executeMethod(HcapAdapterCookie var1) throws IOException;

    public abstract void writeObjectFromStream(String var1, String var2, InputStream var3, FileMetadata var4) throws StorageAdapterException;

    public abstract void setMetadata(String var1, String var2, FileMetadata var3) throws StorageAdapterException;

    protected abstract List<NameValuePair> handleDeleteOperation(DeleteJob.Operation var1, String var2) throws StorageAdapterLiteralException;

    protected abstract String getErrorHeader();

    @Override
    public void delete(String path, boolean isDirectory, DeleteJob.Operation operation, String reason) throws StorageAdapterException {
        this.delete(path, isDirectory, operation, reason, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String path, boolean isDirectory, DeleteJob.Operation operation, String reason, boolean isCustomMetadata) throws StorageAdapterException {
        URI uri;
        List<NameValuePair> deleteOperations;
        HttpHost httpHost = new HttpHost(this.getHost(), ((HCAPProfile)this.getProfile()).getPort(), this.getProfile().getProtocol());
        String resolvedPath = path;
        if (!resolvedPath.startsWith("/fcfs_metadata")) {
            resolvedPath = this.getProfile().resolvePath(resolvedPath);
        }
        if (isDirectory) {
            deleteOperations = null;
        } else if (operation == DeleteJob.Operation.PRIVILEGED_DELETE) {
            if (reason == null || reason.equals("")) {
                throw new StorageAdapterLiteralException("When doing a privileged delete a reason is required.");
            }
            deleteOperations = new ArrayList<NameValuePair>();
            deleteOperations.add((NameValuePair)new BasicNameValuePair("privileged", "true"));
            deleteOperations.add((NameValuePair)new BasicNameValuePair("reason", reason));
        } else {
            deleteOperations = this.handleDeleteOperation(operation, reason);
        }
        if (isCustomMetadata) {
            if (deleteOperations == null) {
                deleteOperations = new ArrayList<NameValuePair>();
            }
            deleteOperations.add((NameValuePair)new BasicNameValuePair("type", "custom-metadata"));
        }
        String queryString = null;
        if (deleteOperations != null && deleteOperations.size() > 0) {
            queryString = URLEncodedUtils.format(deleteOperations, (String)"UTF-8");
        }
        try {
            uri = URIUtils.createURI((String)this.getProfile().getProtocol(), (String)this.getHost(), (int)-1, (String)resolvedPath, (String)queryString, null);
        }
        catch (URISyntaxException e) {
            LOG.log(Level.INFO, "Unexpected error generating put URI for : " + resolvedPath);
            throw new StorageAdapterLiteralException("Error during delete", e);
        }
        HttpDelete request = new HttpDelete(uri);
        HcapAdapterCookie cookie = new HcapAdapterCookie((HttpUriRequest)request, httpHost);
        Object object = this.savingCookieLock;
        synchronized (object) {
            if (this.savedCookie != null) {
                throw new RuntimeException("This adapter already has a current connection to host -- cannot create two at once.");
            }
            this.savedCookie = cookie;
        }
        try {
            this.executeMethod(cookie);
            this.handleHttpResponse(cookie.getResponse(), "deleting", path);
        }
        catch (IOException e) {
            this.handleIOExceptionFromRequest(e, "deleting", path);
        }
        finally {
            this.close();
        }
    }

    protected String getHost() throws StorageAdapterException {
        boolean shouldRetry = true;
        String profileString = null;
        try {
            profileString = this.getProfile().getHost();
        }
        catch (UnknownHostException e) {
            shouldRetry = false;
        }
        if (profileString == null) {
            String msg = String.format("host %s in profile %s", ((HCAPProfile)this.getProfile()).getHostname(), this.getProfile().getName());
            if (shouldRetry) {
                throw new StorageAdapterRetryAndFailJobException("DNS Failure for " + msg);
            }
            throw new StorageAdapterLiteralException("Could not reach " + msg);
        }
        return profileString;
    }

    protected void handleIOExceptionFromRequest(IOException e, String cause, String fileName) throws StorageAdapterException {
        Throwable rootCause = e;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        if (rootCause instanceof ConnectTimeoutException || rootCause instanceof NoHttpResponseException || rootCause instanceof UnknownHostException || rootCause instanceof BindException || rootCause instanceof SocketTimeoutException) {
            String msg = "Retryable Http Exception while " + cause + " " + fileName + ": " + rootCause.getMessage();
            LOG.log(Level.WARNING, msg, e);
            throw new StorageAdapterHttpRetryException(msg, e);
        }
        String msg = "IOException while " + cause + " " + fileName + ": " + rootCause.getMessage();
        LOG.log(Level.WARNING, msg, e);
        throw new StorageAdapterLiteralException(msg, e);
    }

    protected void handleHttpResponse(HttpResponse response, String action, String fileName) throws StorageAdapterException {
        if (response == null) {
            LOG.log(Level.WARNING, "Null response executing " + action + " for file: " + fileName);
            throw new StorageAdapterServerRetryException("Http request failed for file: " + fileName);
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200 && statusCode != 201 && statusCode != 204) {
            Header arcErrorHeader = response.getFirstHeader(this.getErrorHeader());
            if (arcErrorHeader != null) {
                LOG.log(Level.WARNING, "Error during HCP " + action + ".  Status = " + statusCode + " Message = " + arcErrorHeader.getValue() + " File = " + fileName);
            }
            if (statusCode == 500 || statusCode == 503) {
                String errorMsg = String.format("%d - Problem with server, please retry", statusCode);
                throw new StorageAdapterServerRetryException(errorMsg);
            }
            String errorMsgFromHCP = arcErrorHeader == null ? HCAPAdapter.getMessageFromStatusCode(statusCode) : arcErrorHeader.getValue();
            String errorMsg = String.format("%d - %s while %s %s", statusCode, errorMsgFromHCP, action, this.getProfile().decode(fileName));
            throw new StorageAdapterLiteralException(errorMsg, (Integer)statusCode);
        }
    }

    @Override
    public InputStream getInputStream(String path, String query) throws StorageAdapterException {
        LOG.log(Level.FINEST, "getHost()=" + this.getHost() + ", profile=" + this.getProfile().toDetailString());
        return this.getInputStream(this.getHost(), path, query, true, null);
    }

    @Override
    public void writeObjectFromStream(String targetPath, InputStream is, FileMetadata ingestionMetadata) throws StorageAdapterException {
        this.writeObjectFromStream(this.getHost(), targetPath, is, ingestionMetadata);
    }

    @Override
    public void setMetadata(String path, FileMetadata metadata) throws StorageAdapterException {
        this.setMetadata(this.getHost(), path, metadata);
    }

    @Override
    public void rename(String parentDirectoryURL, String oldName, String newName) throws StorageAdapterException {
        String msg = this.getClass().getName() + " doesn't support rename() yet.";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean exists(String path) throws StorageAdapterException {
        return this.exists(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String path, String query) throws StorageAdapterException {
        boolean result = false;
        HttpHost httpHost = new HttpHost(this.getHost(), ((HCAPProfile)this.getProfile()).getPort(), this.getProfile().getProtocol());
        String resolvedPath = path;
        if (!path.startsWith("/fcfs_metadata")) {
            resolvedPath = this.getProfile().resolvePath(resolvedPath);
        }
        if (query != null && !query.equals("")) {
            resolvedPath = String.format("%s?%s", resolvedPath, query);
        }
        HttpHead request = new HttpHead(resolvedPath);
        int statusCode = -1;
        try {
            HcapAdapterCookie cookie = new HcapAdapterCookie((HttpUriRequest)request, httpHost);
            Object object = this.savingCookieLock;
            synchronized (object) {
                if (this.savedCookie != null) {
                    throw new RuntimeException("This adapter already has a current connection to host -- cannot create two at once.");
                }
                this.savedCookie = cookie;
            }
            this.executeMethod(cookie);
            if (cookie.getResponse() != null) {
                statusCode = cookie.getResponse().getStatusLine().getStatusCode();
            }
            result = true;
            if (statusCode == 404 || statusCode == 204) {
                result = false;
            } else {
                this.handleHttpResponse(cookie.getResponse(), "checking existence of", path);
            }
        }
        catch (IOException e) {
            this.handleIOExceptionFromRequest(e, "checking existence of", path);
        }
        finally {
            this.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFileSize(ArcMoverFile file) throws StorageAdapterException {
        HttpHead request;
        HttpHost httpHost = new HttpHost(this.getHost(), ((HCAPProfile)this.getProfile()).getPort(), this.getProfile().getProtocol());
        String path = file.getPath();
        if (file.getParent().isVersionList() || file.isVersion()) {
            path = path + file.getVersionString();
        }
        try {
            request = new HttpHead(this.getProfile().resolvePath(path));
        }
        catch (IllegalArgumentException iae) {
            Throwable rootCause = iae;
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            if (rootCause instanceof URISyntaxException) {
                throw new StorageAdapterLiteralException(rootCause);
            }
            throw iae;
        }
        HcapAdapterCookie cookie = new HcapAdapterCookie((HttpUriRequest)request, httpHost);
        Object rootCause = this.savingCookieLock;
        synchronized (rootCause) {
            if (this.savedCookie != null) {
                throw new RuntimeException("This adapter already has a current connection to host -- cannot create two at once.");
            }
            this.savedCookie = cookie;
        }
        try {
            this.executeMethod(cookie);
            this.handleHttpResponse(cookie.getResponse(), "checking file size of", path);
        }
        catch (IOException e) {
            this.handleIOExceptionFromRequest(e, "checking file size of", path);
        }
        finally {
            this.close();
        }
        return Long.parseLong(cookie.getResponse().getFirstHeader("Content-Length").getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArcCapacity getArchiveCapacity(URL url) throws StorageAdapterException {
        ArcCapacity result = null;
        HttpHost httpHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        HttpHead request = new HttpHead();
        try {
            HcapAdapterCookie cookie = new HcapAdapterCookie((HttpUriRequest)request, httpHost);
            Object object = this.savingCookieLock;
            synchronized (object) {
                if (this.savedCookie != null) {
                    throw new RuntimeException("This adapter already has a current connection to host -- cannot create two at once.");
                }
                this.savedCookie = cookie;
            }
            this.executeMethod(cookie);
            this.handleHttpResponse(cookie.getResponse(), "checking capacity of", url.getHost());
            if (cookie.getResponse() != null) {
                result = new ArcCapacity();
                result.setTotal(Long.parseLong(cookie.getResponse().getFirstHeader("X-ArcAvailableCapacity").toString()));
                result.setAvailable(Long.parseLong(cookie.getResponse().getFirstHeader("X-ArcAvailableCapacity").toString()));
            }
        }
        catch (IOException e) {
            this.handleIOExceptionFromRequest(e, "checking capacity of", url.getHost());
        }
        finally {
            this.close();
        }
        return result;
    }

    @Override
    public ArcMoverDirectory getDirectory(String path, boolean forceGetAllMetadata) throws StorageAdapterException {
        try {
            return ArcMoverDirectory.getDirInstance(this.getProfile(), path, this);
        }
        catch (Throwable e) {
            String msg = "Error parsing directory for: " + path;
            LOG.log(Level.INFO, msg, e);
            throw new StorageAdapterLiteralException(msg, e);
        }
    }

    @Override
    public Iterator<ArcMoverFile> getFileListIterator(ArcMoverDirectory caller, boolean includeDeleted, boolean supportsVersioing) throws StorageAdapterException {
        try {
            String query = this.getQueryStringForFileListIterator(caller, includeDeleted, supportsVersioing);
            InputStream dirList = this.getInputStream(caller.getPath(), query);
            return new HCAPDirectoryList(this, caller, dirList);
        }
        catch (XMLStreamException e) {
            String path = caller.getPath();
            LOG.log(Level.INFO, "XMLStreamException in getFileListIterator on " + path, e);
            String msg = "The response from HCP contains invalid XML.";
            if (path.contains("&")) {
                msg = msg + "  One common cause is an ampersand (&) in a directory path.  HCP-DM does not support ampersands (&) in directory paths in HCP releases earlier than 4.0.";
            }
            throw new StorageAdapterException(msg, e);
        }
    }

    protected String getQueryStringForFileListIterator(ArcMoverDirectory caller, boolean includeDeleted, boolean supportsVersioning) throws StorageAdapterException {
        return "";
    }

    @Override
    public ArcMoverDirectory getVersions(String path) throws StorageAdapterException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.savingCookieLock;
        synchronized (object) {
            if (this.savedCookie != null) {
                this.savedCookie.cancel();
                this.savedCookie = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.savingCookieLock;
        synchronized (object) {
            if (this.savedCookie != null) {
                this.savedCookie.close();
                this.savedCookie = null;
            }
        }
    }

    public AbstractHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public InputStream getACLStream(String path) throws StorageAdapterException {
        return null;
    }

    @Override
    public void setACLFromStream(String path, InputStream aclStream) throws StorageAdapterException {
    }

    protected final synchronized void init(SSLCertificateCallback sslExceptionCallback) throws StorageAdapterException {
        if (this.httpClient != null) {
            LOG.log(Level.FINE, "Reinitializing...why?");
            return;
        }
        BasicHttpParams params = new BasicHttpParams();
        int maxConnectionsPerRoute = HCPMoverProperties.MAX_LOAD_MAXTHREADS.getAsInt();
        int maxConnections = HCPMoverProperties.MAX_LOAD_MAXTHREADS_PER_NODE.getAsInt();
        try {
            ConnPerRouteBean connPerRoute = new ConnPerRouteBean(maxConnectionsPerRoute);
            ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)connPerRoute);
        }
        catch (NumberFormatException connPerRoute) {
            // empty catch block
        }
        try {
            ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)maxConnections);
        }
        catch (NumberFormatException connPerRoute) {
            // empty catch block
        }
        int connectionTimeoutMillis = HCPMoverProperties.CONNECTION_TIMEOUT_MILLIS.getAsInt();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connectionTimeoutMillis);
        int socketTimeoutMillis = HCPMoverProperties.SOCKET_TIMEOUT_MILLIS.getAsInt();
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)socketTimeoutMillis);
        HttpConnectionParams.setLinger((HttpParams)params, (int)1);
        params.setBooleanParameter("http.protocol.handle-redirects", false);
        try {
            SchemeRegistry schemeRegistry = this.getHcapProtocolSchemeRegistryForHttpClient(sslExceptionCallback);
            ThreadSafeClientConnManager connMgr = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
            this.httpClient = new DefaultHttpClient((ClientConnectionManager)connMgr, (HttpParams)params);
            LOG.log(Level.FINE, "Created new httpClient for profile: " + this.getProfile());
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Unable to initialize HCAPHttpAdapter!", e);
            throw new StorageAdapterLiteralException("Unable to initialize HCAPHttpAdapter!", e);
        }
    }

    public SchemeRegistry getHcapProtocolSchemeRegistryForHttpClient(SSLCertificateCallback sslExceptionCallback) throws StorageAdapterException {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            GetCertsX509TrustManager X509TrustManager2 = new GetCertsX509TrustManager((HCAPProfile)this.getProfile(), sslExceptionCallback);
            sslcontext.init(null, new TrustManager[]{X509TrustManager2}, null);
            SSLSocketFactory sslSocketFactory = new SSLSocketFactory(sslcontext);
            sslSocketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Scheme https = new Scheme("https", (SocketFactory)sslSocketFactory, 443);
            schemeRegistry.register(https);
            this.getAdditionalHcapProtocolSchemeRegistryForHttpClient(schemeRegistry, sslExceptionCallback);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.log(Level.INFO, "Unable to initialize SSL for https protocol!", e);
            throw new StorageAdapterException("Unable to initialize SSL for https protocol", e);
        }
        catch (NoSuchProviderException e) {
            LOG.log(Level.INFO, "Unable to initialize SSL for https protocol!", e);
            throw new StorageAdapterException("Unable to initialize SSL for https protocol", e);
        }
        catch (KeyStoreException e) {
            LOG.log(Level.INFO, "Unable to initialize SSL for https protocol!", e);
            throw new StorageAdapterException("Unable to initialize SSL for https protocol", e);
        }
        catch (KeyManagementException e) {
            LOG.log(Level.INFO, "Unable to initialize SSL for https protocol!", e);
            throw new StorageAdapterException("Unable to initialize SSL for https protocol", e);
        }
        return schemeRegistry;
    }

    public void getAdditionalHcapProtocolSchemeRegistryForHttpClient(SchemeRegistry schemeRegistry, SSLCertificateCallback sslExceptionCallback) throws StorageAdapterException {
    }

    public void updateHttpClient(LoadSchedule load) {
    }

    @Override
    public void abortASAP() {
        this.abortASAP = true;
    }

    @Override
    public int getMaxNumSimultaneousHttpConnections(int maxConnectionsPerRoute) throws StorageAdapterLiteralException {
        int maxAllowedConnectionsPerNode = Math.min(250, maxConnectionsPerRoute);
        int numNodes = 0;
        try {
            numNodes = ((HCAPProfile)this.getProfile()).getHostAddresses().size();
        }
        catch (UnknownHostException e) {
            LOG.log(Level.INFO, "UnknownHostException in getMaxNumSimultaneousHttpConnections, result will be 0 connections", e);
            throw new StorageAdapterLiteralException("Cannot get to host: " + ((HCAPProfile)this.getProfile()).getHostname());
        }
        int result = maxAllowedConnectionsPerNode * numNodes;
        return result;
    }

    protected void setIntClientParameter(Integer timeout, String parameter) {
        HttpParams params = this.httpClient.getParams();
        if (timeout != null) {
            params.setIntParameter(parameter, timeout.intValue());
        } else {
            params.removeParameter(parameter);
        }
        this.httpClient.setParams(params);
    }

    protected Integer getIntClientParameter(String parameter) {
        HttpParams params = this.httpClient.getParams();
        int value = params.getIntParameter(parameter, Integer.MIN_VALUE);
        if (value != Integer.MIN_VALUE) {
            return value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean testConnection() throws ConnectionTestException {
        Integer oldTimeout = this.getIntClientParameter("http.connection.timeout");
        Integer oldSocketTimeout = this.getIntClientParameter("http.socket.timeout");
        boolean isValid = false;
        try {
            int tempTime = HCPMoverProperties.CONNECTION_TEST_TIMEOUT_OVERRIDE_MS.getAsInt();
            this.setIntClientParameter(tempTime, "http.connection.timeout");
            this.setIntClientParameter(tempTime, "http.socket.timeout");
            isValid = this.doTestConnection();
        }
        finally {
            this.setIntClientParameter(oldTimeout, "http.connection.timeout");
            this.setIntClientParameter(oldSocketTimeout, "http.socket.timeout");
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doTestConnection() throws ConnectionTestException {
        HCAPProfile hcapProfile = (HCAPProfile)this.getProfile();
        HttpHost httpHost = null;
        try {
            httpHost = new HttpHost(this.getHost(), hcapProfile.getPort(), hcapProfile.getProtocol());
        }
        catch (StorageAdapterException e) {
            throw new ConnectionTestException(e, null, null, this.getProfile().getName());
        }
        String root = "/";
        String resolvedPath = hcapProfile.resolvePath(root);
        HttpHead request = new HttpHead(resolvedPath);
        HcapAdapterCookie cookie = new HcapAdapterCookie((HttpUriRequest)request, httpHost);
        Object object = this.savingCookieLock;
        synchronized (object) {
            if (this.savedCookie != null) {
                throw new RuntimeException("This adapter already has a current connection to host -- cannot create two at once.");
            }
            this.savedCookie = cookie;
        }
        IOException cause = null;
        Integer statusCode = null;
        try {
            this.executeMethod(cookie);
        }
        catch (IOException e) {
            LOG.log(Level.INFO, "IOException during testConnection", e);
            cause = e;
        }
        finally {
            this.close();
        }
        if (cookie.getResponse() != null) {
            statusCode = cookie.getResponse().getStatusLine().getStatusCode();
        }
        if (statusCode == null || statusCode != 200) {
            if (cause != null) {
                throw new ConnectionTestException(cause, statusCode, null, this.getProfile().getName());
            }
            throw new ConnectionTestException(statusCode, null, this.getProfile().getName());
        }
        boolean isValid = true;
        return isValid;
    }

    protected static String getCustomMetadata(Reader reader) throws IOException, CustomMetadataTooLargeException {
        int readCnt;
        long maxCmdLength = HCPMoverProperties.CM_MAX_IN_MEMORY_SIZE.getAsLong();
        StringBuilder out = new StringBuilder();
        char[] chars = new char[4096];
        do {
            if ((readCnt = reader.read(chars)) <= 0) continue;
            if ((long)(out.length() + readCnt) > maxCmdLength) {
                throw new CustomMetadataTooLargeException();
            }
            out.append(chars, 0, readCnt);
        } while (readCnt >= 0);
        return out.toString();
    }

    protected InputStream getInputStream(String path, boolean resolvePath) throws StorageAdapterException {
        LOG.log(Level.FINEST, "getHost()=" + this.getHost() + ", profile=" + this.getProfile().toDetailString());
        return this.getInputStream(this.getHost(), path, resolvePath);
    }

    protected InputStream getInputStream(String sourceNode, String path, boolean resolvePath) throws StorageAdapterException {
        return this.getInputStream(sourceNode, path, null, resolvePath, null);
    }

    protected InputStream getInputStream(String path, String query, Header contentTypeHeader) throws StorageAdapterException {
        LOG.log(Level.FINEST, "getHost()=" + this.getHost() + ", profile=" + this.getProfile().toDetailString());
        return this.getInputStream(this.getHost(), path, query, true, contentTypeHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream(String sourceNode, String path, String query, boolean resolvePath, Header contentTypeHeader) throws StorageAdapterException {
        InputStream inputStream = null;
        try {
            HttpHost httpHost = new HttpHost(sourceNode, ((HCAPProfile)this.getProfile()).getPort(), this.getProfile().getProtocol());
            LOG.log(Level.FINE, "sourceNode=" + sourceNode + ", path=" + path + ", httpHost=" + httpHost);
            String resolvedPath = path;
            if (resolvePath) {
                resolvedPath = this.getProfile().resolvePath(resolvedPath);
            }
            if (query != null && !query.equals("")) {
                if (!query.startsWith("?")) {
                    query = "?" + query;
                }
                resolvedPath = resolvedPath + query;
            }
            HttpGet request = new HttpGet(resolvedPath);
            if (contentTypeHeader != null) {
                request.setHeader(contentTypeHeader);
            }
            HcapAdapterCookie cookie = new HcapAdapterCookie((HttpUriRequest)request, httpHost);
            Object object = this.savingCookieLock;
            synchronized (object) {
                if (this.savedCookie != null) {
                    throw new RuntimeException("This adapter already has a current connection to host -- cannot create two at once.");
                }
                this.savedCookie = cookie;
            }
            this.executeMethod(cookie);
            this.handleHttpResponse(cookie.getResponse(), "getting", path);
            if (cookie.getResponse().getEntity() != null) {
                inputStream = cookie.getResponse().getEntity().getContent();
            }
        }
        catch (IOException e) {
            this.handleIOExceptionFromRequest(e, "getting", path);
            this.close();
        }
        return inputStream;
    }

    @Override
    public boolean isVersioningEnabled() throws StorageAdapterException {
        return false;
    }

    @Override
    public void mkSymlink(String symlinkName, String symlinkTarget) throws StorageAdapterException {
        throw new StorageAdapterLiteralException("Creation of symbolic links via HTTP is not supported on HCAP");
    }

    static {
        statusMessages.put(200, "Request was successful");
        statusMessages.put(201, "Object was successfully added");
        statusMessages.put(204, "Could not retrieve custom metadata or version");
        statusMessages.put(206, "Successfully retrieved the requested byte range");
        statusMessages.put(302, "The login credentials you suppplied are invalid");
        statusMessages.put(400, "The request was not valid");
        statusMessages.put(401, "This user does not have permissions to perform this operation");
        statusMessages.put(403, "The requested operation is not allowed");
        statusMessages.put(404, "Object not found");
        statusMessages.put(409, "Conflict");
        statusMessages.put(413, "Not enough space to store object");
        statusMessages.put(414, "URL is longer than 4095 bytes");
        statusMessages.put(416, "Requested range not satisfiable");
        statusMessages.put(500, "Internal server error on HCP");
        statusMessages.put(503, "Service is temporarily unavailable");
    }

    private class TestHttpThreadSafeClientConnManager
    extends ThreadSafeClientConnManager {
        private int count;
        private final int MAX_COUNT = 0;

        public TestHttpThreadSafeClientConnManager(HttpParams params, SchemeRegistry schreg) {
            super(params, schreg);
            this.count = 0;
            this.MAX_COUNT = 0;
        }

        public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
            if (this.count > 0) {
                LOG.log(Level.INFO, "****Getting connection in pool.  Current total max = " + this.getConnectionsInPool() + "   Current for route = " + this.getConnectionsInPool(route) + "  Route = " + route.getTargetHost());
                this.count = 0;
            }
            ++this.count;
            return super.requestConnection(route, state);
        }
    }

    public class HcapAdapterCookie {
        private final HttpUriRequest savedRequest;
        private final HttpHost httpHost;
        private HttpContext savedContext;
        private HttpResponse savedResponse;

        HcapAdapterCookie(HttpUriRequest savedRequest, HttpHost httpHost) {
            this.savedRequest = savedRequest;
            this.httpHost = httpHost;
        }

        public void setResponseAndContext(HttpResponse savedResponse, HttpContext savedContext) {
            this.savedResponse = savedResponse;
            this.savedContext = savedContext;
        }

        public HttpResponse getResponse() {
            return this.savedResponse;
        }

        public HttpHost getHost() {
            return this.httpHost;
        }

        public HttpUriRequest getRequest() {
            return this.savedRequest;
        }

        public void cancel() {
            if (this.savedRequest != null) {
                this.savedRequest.abort();
            }
            this.close();
        }

        public void close() {
            if (this.savedResponse != null && this.savedResponse.getEntity() != null) {
                try {
                    this.savedResponse.getEntity().consumeContent();
                }
                catch (IOException ioe) {
                    LOG.log(Level.FINE, "IOException during get", ioe);
                }
            }
        }
    }
}

