/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.adapter;

import com.archivas.clienttools.arcutils.impl.adapter.BadElementException;
import com.archivas.clienttools.arcutils.impl.adapter.DirectoryListingXmlException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.ctc.wstx.stax.WstxInputFactory;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class HCAPDirectoryList
implements Iterator<ArcMoverFile> {
    private XMLStreamReader xmlr = null;
    public static Logger LOG = Logger.getLogger(HCAPDirectoryList.class.getName());
    private StorageAdapter adapter;
    private ArcMoverDirectory caller;

    HCAPDirectoryList(StorageAdapter adapter, ArcMoverDirectory caller, InputStream dirStream) throws XMLStreamException {
        this.adapter = adapter;
        this.caller = caller;
        WstxInputFactory factory = new WstxInputFactory();
        this.xmlr = factory.createXMLStreamReader(dirStream);
        this.moveToNextEntry();
    }

    @Override
    public boolean hasNext() {
        boolean result = false;
        try {
            if (this.xmlr.hasNext()) {
                result = this.xmlr.isStartElement() && this.xmlr.getName().getLocalPart().equals("entry");
            }
        }
        catch (XMLStreamException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
        finally {
            if (!result) {
                this.adapter.close();
            }
        }
        return result;
    }

    @Override
    public ArcMoverFile next() {
        try {
            if (this.xmlr.isStartElement() && this.xmlr.getName().getLocalPart().equals("entry")) {
                ArcMoverFile file = this.adapter.createArcMoverFileObject(this.xmlr, this.caller);
                this.xmlr.next();
                this.moveToNextEntry();
                if (file == null) {
                    throw new NoSuchElementException();
                }
                return file;
            }
            throw new NoSuchElementException();
        }
        catch (StorageAdapterException e) {
            throw new BadElementException(e.getMessage(), e);
        }
        catch (XMLStreamException e) {
            throw new DirectoryListingXmlException("Error parsing directory listing XML: " + e.getMessage(), e);
        }
    }

    private void moveToNextEntry() throws XMLStreamException {
        while (this.xmlr.hasNext()) {
            switch (this.xmlr.getEventType()) {
                case 1: {
                    if (!this.xmlr.getName().getLocalPart().equals("entry")) break;
                    return;
                }
            }
            this.xmlr.next();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("HCAPDirectoryList does not support remove()");
    }
}

