/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.adapter;

import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.model.LoadSchedule;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import org.apache.http.impl.client.AbstractHttpClient;

public class HCAPNullAdapter
implements StorageAdapter {
    public static Logger LOG = Logger.getLogger(HCAPNullAdapter.class.getName());
    public static long sleepTimeMs = 1L;

    @Override
    public String getDebugName() {
        return "HCAPNullAdapter";
    }

    @Override
    public AbstractProfileBase getProfile() {
        return null;
    }

    @Override
    public void setProfile(AbstractProfileBase profile) {
    }

    @Override
    public void abortASAP() {
    }

    @Override
    public void mkdir(String url, FileMetadata metadata) {
    }

    @Override
    public void mkSymlink(String symlinkName, String symlinkTarget) throws StorageAdapterException {
        throw new UnsupportedOperationException("mksymlink");
    }

    @Override
    public void delete(String path, boolean isDirectory, DeleteJob.Operation operation, String reason) {
    }

    @Override
    public InputStream getInputStream(String url, String unused) throws StorageAdapterException {
        return new ByteArrayInputStream(new byte[0]);
    }

    public void writeStream(String targetPath, InputStream is) throws StorageAdapterException {
        this.writeObjectFromStream(targetPath, is, null);
    }

    @Override
    public void writeObjectFromStream(String targetPath, InputStream is, FileMetadata ingestionMetadata) throws StorageAdapterException {
        try {
            Thread.sleep(sleepTimeMs);
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public void setMetadata(String path, FileMetadata metadata) throws StorageAdapterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(String parentDirectoryURL, String oldName, String newName) throws StorageAdapterException {
    }

    @Override
    public boolean exists(String path) {
        return true;
    }

    @Override
    public ArcMoverDirectory getDirectory(String path, boolean forceGetAllMetadata) throws StorageAdapterException {
        int i;
        String s = path;
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((i = s.lastIndexOf("/")) >= 0) {
            path = s.substring(0, i + 1);
        }
        ArcMoverDirectory dir = ArcMoverDirectory.getDirInstance(this.getProfile(), path, this);
        return dir;
    }

    @Override
    public ArcMoverFile createArcMoverFileObject(XMLStreamReader xmlr, ArcMoverDirectory caller) throws StorageAdapterException {
        return null;
    }

    @Override
    public Iterator<ArcMoverFile> getFileListIterator(ArcMoverDirectory caller, boolean includeDeleted, boolean supportsVersioning) throws StorageAdapterException {
        return null;
    }

    @Override
    public ArcMoverDirectory getVersions(String path) throws StorageAdapterException {
        return null;
    }

    @Override
    public long getFileSize(ArcMoverFile f) throws StorageAdapterException {
        return 0L;
    }

    @Override
    public FileMetadata getMetadata(String path, String queryString, FileType fileType, boolean isVersion) throws StorageAdapterException {
        FileMetadata md = new FileMetadata();
        md.setFileType(FileType.FILE);
        md.setModTime(new Date());
        md.setSize(new Long(0L));
        md.setHidden(false);
        return md;
    }

    @Override
    public String getCustomMetadata(String path, Long version, FileType fileType) throws StorageAdapterException {
        return "";
    }

    @Override
    public void setCustomMetadata(String file, String metadata) throws StorageAdapterException {
    }

    @Override
    public void deleteCustomMetadata(String path) throws StorageAdapterException {
    }

    @Override
    public InputStream getCustomMetadataStream(String path, Long version, FileType fileType) throws StorageAdapterException {
        return this.getCustomMetadataStream(path, version, fileType, null);
    }

    @Override
    public InputStream getCustomMetadataStream(String path, Long version, FileType fileType, String annotation) throws StorageAdapterException {
        return null;
    }

    @Override
    public void setCustomMetadataStream(String file, InputStream metadata) throws StorageAdapterException {
        this.setCustomMetadataStream(file, metadata, null);
    }

    @Override
    public void setCustomMetadataStream(String file, InputStream metadata, String annotation) throws StorageAdapterException {
    }

    @Override
    public InputStream getACLStream(String path) throws StorageAdapterException {
        return null;
    }

    @Override
    public void setACLFromStream(String path, InputStream aclStream) throws StorageAdapterException {
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
    }

    public SSLCertChain getSSLCerts() throws IOException {
        return null;
    }

    public AbstractHttpClient getHttpClient() {
        return null;
    }

    public void updateHttpClient(LoadSchedule load) {
    }

    @Override
    public int getMaxNumSimultaneousHttpConnections(int maxConnectionsPerRoute) {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean testConnection() {
        return true;
    }

    @Override
    public boolean copyDirMetadataWhenMigrating() {
        return false;
    }

    @Override
    public boolean isVersioningEnabled() {
        return false;
    }

    static {
        try {
            sleepTimeMs = Long.parseLong(System.getProperty(HCAPNullAdapter.class.getName() + ".sleepTimeMs"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

