/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.adapter;

import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.adapter.HCAPAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterLiteralException;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.ArcMoverSymlink;
import com.archivas.clienttools.arcutils.model.CustomMetadata;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.model.Retention;
import com.archivas.clienttools.arcutils.model.StructuredMetadata;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.HCAPProfile;
import com.archivas.clienttools.arcutils.profile.Hcap2Profile;
import com.archivas.clienttools.arcutils.utils.RFC2396Encoder;
import com.archivas.clienttools.arcutils.utils.UidGidUtil;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import com.archivas.clienttools.arcutils.utils.net.SSLCertException;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.SSLException;
import javax.xml.stream.XMLStreamReader;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class Hcap2Adapter
extends HCAPAdapter {
    SSLCertChain sslCerts = null;
    Hcap2Profile profile;

    public Hcap2Adapter(Hcap2Profile profile, SSLCertificateCallback sslExceptionCallback, AbstractHttpClient httpClient) throws StorageAdapterException {
        this.profile = profile;
        this.httpClient = httpClient;
        if (httpClient == null) {
            this.init(sslExceptionCallback);
        }
        this.sslExceptionCallback = sslExceptionCallback;
        this.debugName = "hcp2adapter" + ++adapterCnt;
    }

    @Override
    public void setProfile(AbstractProfileBase profile) {
        if (profile instanceof HCAPProfile) {
            this.profile = (Hcap2Profile)profile;
        }
    }

    @Override
    public HCAPProfile getProfile() {
        return this.profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mkdir(String path, FileMetadata metadata) throws StorageAdapterException {
        URI uri;
        HttpHost httpHost = new HttpHost(this.getHost(), this.profile.getPort(), this.profile.getProtocol());
        String queryString = null;
        if (metadata != null) {
            queryString = this.generateQueryParameters(metadata, true);
        }
        String uriPath = path;
        if (!path.startsWith("/fcfs_metadata")) {
            uriPath = this.getProfile().resolvePath(uriPath);
        }
        try {
            String urlPath = uriPath;
            if (queryString != null) {
                urlPath = urlPath + "?" + queryString;
            }
            URL url = new URL(this.profile.getProtocol(), this.getHost(), urlPath);
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            LOG.log(Level.WARNING, "Unexpected error generating put URI for : " + uriPath);
            throw new StorageAdapterLiteralException("Error making a new directory on the server", e);
        }
        catch (MalformedURLException e) {
            LOG.log(Level.WARNING, "Unexpected error generating put URL for : " + uriPath);
            throw new StorageAdapterLiteralException("Error making a new directory on the server", e);
        }
        HttpMkdir request = new HttpMkdir(uri);
        HCAPAdapter.HcapAdapterCookie cookie = new HCAPAdapter.HcapAdapterCookie((HttpUriRequest)request, httpHost);
        Object object = this.savingCookieLock;
        synchronized (object) {
            if (this.savedCookie != null) {
                throw new RuntimeException("This adapter already has a current connection to host -- cannot create two at once.");
            }
            this.savedCookie = cookie;
        }
        try {
            this.executeMethod(cookie);
            this.handleHttpResponse(cookie.getResponse(), "creating directory", path);
        }
        catch (IOException e) {
            this.handleIOExceptionFromRequest(e, "creating directory", path);
        }
        finally {
            this.close();
        }
        if (metadata != null && metadata.hasShred()) {
            this.setShredOnDirectory(path, metadata.isShred());
        }
        if (metadata != null && metadata.hasRetention()) {
            this.setRetentionOnDirectory(path, metadata.getRetention());
        }
        this.setAdditionalMetadataOnDirectories(path, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObjectFromStream(String targetNode, String targetPath, InputStream is, FileMetadata ingestionMetadata) throws StorageAdapterException {
        HttpHost httpHost = new HttpHost(targetNode, this.profile.getPort(), this.profile.getProtocol());
        String filePath = targetPath;
        if (!filePath.startsWith("/fcfs_metadata")) {
            filePath = this.getProfile().resolvePath(filePath);
        }
        String queryString = null;
        if (ingestionMetadata != null) {
            queryString = this.generateQueryParameters(ingestionMetadata, false);
        }
        URI uri = null;
        try {
            uri = URIUtils.createURI((String)this.profile.getProtocol(), (String)targetNode, (int)this.profile.getPort(), (String)filePath, (String)queryString, null);
        }
        catch (URISyntaxException e) {
            LOG.log(Level.WARNING, "Unexpected error generating put URI for : " + targetPath);
            throw new StorageAdapterLiteralException("Error writing object to the server", e);
        }
        HttpPut request = new HttpPut(uri);
        InputStreamEntity isEntity = new InputStreamEntity(is, -1L);
        request.setEntity((HttpEntity)isEntity);
        request.getParams().setParameter("http.protocol.expect-continue", (Object)Boolean.TRUE);
        request.getParams().setParameter("http.protocol.wait-for-continue", (Object)100);
        HCAPAdapter.HcapAdapterCookie cookie = new HCAPAdapter.HcapAdapterCookie((HttpUriRequest)request, httpHost);
        Object object = this.savingCookieLock;
        synchronized (object) {
            if (this.savedCookie != null) {
                throw new RuntimeException("This adapter already has a current connection to host -- cannot create two at once.");
            }
            this.savedCookie = cookie;
        }
        try {
            this.executeMethod(cookie);
            this.handleHttpResponse(cookie.getResponse(), "writing", targetPath);
        }
        catch (IOException e) {
            this.handleIOExceptionFromRequest(e, "writing", targetPath);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void setMetadata(String targetNode, String path, FileMetadata metadata) throws StorageAdapterException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRetentionHoldToTrue(String targetPath, FileType fileType) throws StorageAdapterException {
        String filePath = this.getMetadataPathForObject(targetPath, fileType, true) + "/" + "retention.txt";
        String putHoldToFile = "Hold";
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(putHoldToFile.getBytes());
            this.writeObjectFromStream(this.getHost(), filePath, is, null);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    LOG.log(Level.INFO, "IO Error while setting retention hold", e);
                }
            }
        }
    }

    protected void setAdditionalMetadataOnDirectories(String targetPath, FileMetadata metadata) throws StorageAdapterException {
    }

    private void setShredOnDirectory(String targetPath, boolean value) throws StorageAdapterException {
        String putShredToFile = value ? "1" : "0";
        this.setDirectorySystemMetadata(targetPath, putShredToFile, "shred.txt");
    }

    private void setRetentionOnDirectory(String targetPath, Retention retention) throws StorageAdapterException {
        String putRetentionToFile = retention.getHCAPValue();
        this.setDirectorySystemMetadata(targetPath, putRetentionToFile, "retention.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDirectorySystemMetadata(String targetPath, String value, String fileUsedToSet) throws StorageAdapterException {
        String filePath = this.getMetadataPathForObject(targetPath, FileType.DIRECTORY, true) + "/" + fileUsedToSet;
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(value.getBytes());
            this.writeObjectFromStream(this.getHost(), filePath, is, null);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, "IO Error while setting directory system metadata", e);
                }
            }
        }
    }

    protected int getDirListMetadataThreshold() {
        return HCPMoverProperties.DIR_LIST_METADATA_THRESHOLD_26.getAsInt();
    }

    @Override
    public String getCustomMetadata(String filePath, Long version, FileType fileType) throws StorageAdapterException {
        String metadataPath = this.getMetadataPathForObject(filePath, fileType, false);
        metadataPath = metadataPath + "/custom-metadata.xml";
        String result = this.getCustomMetadata(metadataPath);
        return result;
    }

    private String getCustomMetadata(String filePath) throws StorageAdapterException {
        String metadataPath = filePath;
        InputStream inputStream = null;
        BufferedReader reader = null;
        try {
            inputStream = this.getInputStream(metadataPath, false);
            reader = new BufferedReader(new InputStreamReader(inputStream));
            String string = reader != null ? Hcap2Adapter.getCustomMetadata(reader) : null;
            return string;
        }
        catch (StorageAdapterLiteralException sale) {
            throw sale;
        }
        catch (StorageAdapterException e) {
            LOG.log(Level.FINE, "Unexpected Exception reading CustomMetadata", e);
            throw new StorageAdapterLiteralException("Error reading custom metadata", e);
        }
        catch (IOException e) {
            LOG.log(Level.FINE, "Unexpected Exception reading CustomMetadata", e);
            throw new StorageAdapterException("Error reading custom metadata", e);
        }
        finally {
            RuntimeException e = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException io) {
                LOG.log(Level.INFO, "Unexpected Exception closing streams after reading CustomMetadata", io);
            }
            catch (RuntimeException re) {
                e = re;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException io) {
                LOG.log(Level.INFO, "Unexpected Exception closing streams after reading CustomMetadata", io);
            }
            catch (RuntimeException re) {
                e = re;
            }
            this.close();
            if (e != null) {
                throw e;
            }
        }
    }

    protected String getMetadataPathForObject(String fileURL, FileType fileType, boolean setting) {
        String metadataPath = "/";
        String filePath = (fileURL.startsWith("/") ? "" : "/") + fileURL;
        if (fileType.equals(FileType.DIRECTORY)) {
            filePath = filePath + (filePath.endsWith("/") ? "" : "/");
            metadataPath = setting ? "/fcfs_metadata" + filePath + ".directory-metadata/settings" : "/fcfs_metadata" + filePath + ".directory-metadata/info";
        } else {
            metadataPath = "/fcfs_metadata" + filePath;
        }
        return metadataPath;
    }

    @Override
    public void setCustomMetadata(String fileURL, String metadata) throws StorageAdapterException {
        this.setCustomMetadata(fileURL, metadata, null);
    }

    public void setCustomMetadata(String fileURL, String metadata, String annotation) throws StorageAdapterException {
        ByteArrayInputStream is = null;
        FileMetadata fileInfo = this.getMetadata(fileURL, null, FileType.FILE, false);
        is = new ByteArrayInputStream(metadata.getBytes());
        this.setCustomMetadata(fileURL, is, fileInfo.getFileType());
        if (is != null) {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "IO Error while setting custom metadata", e);
            }
        }
    }

    @Override
    public InputStream getCustomMetadataStream(String filePath, Long version, FileType fileType) throws StorageAdapterException {
        return this.getCustomMetadataStream(filePath, version, fileType, null);
    }

    @Override
    public InputStream getCustomMetadataStream(String filePath, Long version, FileType fileType, String annotation) throws StorageAdapterException {
        String metadataPath = this.getMetadataPathForObject(filePath, fileType, false);
        metadataPath = metadataPath + "/custom-metadata.xml";
        InputStream result = null;
        result = this.getInputStream(metadataPath, false);
        return result;
    }

    @Override
    public void setCustomMetadataStream(String fileURL, InputStream metadata) throws StorageAdapterException {
        this.setCustomMetadataStream(fileURL, metadata, null);
    }

    @Override
    public void setCustomMetadataStream(String fileURL, InputStream metadata, String annotation) throws StorageAdapterException {
        FileMetadata fileInfo = this.getMetadata(fileURL, null, FileType.FILE, false);
        this.setCustomMetadata(fileURL, metadata, fileInfo.getFileType());
    }

    protected void setCustomMetadata(String fileURL, InputStream is, FileType fileType) throws StorageAdapterException {
        String metadataPath = this.getMetadataPathForObject(fileURL, fileType, false) + "/custom-metadata.xml";
        this.writeObjectFromStream(this.getHost(), metadataPath, is, null);
    }

    @Override
    public void deleteCustomMetadata(String path) throws StorageAdapterException {
        String metadataPath = this.getMetadataPathForObject(path, FileType.FILE, false) + "/custom-metadata.xml";
        this.delete(metadataPath, false, DeleteJob.Operation.DELETE, null, false);
    }

    @Override
    public FileMetadata getMetadata(String filePath, String queryString, FileType fileType, boolean isVersion) throws StorageAdapterException {
        FileMetadata metadata = new FileMetadata();
        metadata.setFileType(fileType);
        this.getMetadata(filePath, metadata);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMetadata(String pathOfObjFile, FileMetadata metadata) throws StorageAdapterException {
        String filePath = (pathOfObjFile.startsWith("/") ? "" : "/") + pathOfObjFile;
        if (metadata.getFileType() == FileType.UNKNOWN) {
            FileType fileType = this.getFileType(filePath);
            metadata.setFileType(fileType);
        }
        String metadataPath = this.getMetadataPathForObject(filePath, metadata.getFileType(), false);
        metadataPath = metadataPath + "/core-metadata.xml";
        InputStream xmlInputStream = null;
        try {
            String modeStr;
            SAXBuilder builder = new SAXBuilder(false);
            xmlInputStream = this.getInputStream(metadataPath, false);
            Document fileXML = builder.build(xmlInputStream);
            Element coreMetadata = fileXML.getRootElement();
            Namespace ns = coreMetadata.getNamespace();
            String value = coreMetadata.getChild("creation-time", ns).getValue();
            Date creationTime = new Date(Long.parseLong(value) * 1000L);
            metadata.setCreationTime(creationTime);
            value = coreMetadata.getChild("change-time", ns).getValue();
            Date cTime = new Date(Long.parseLong(value) * 1000L);
            metadata.setCtime(cTime);
            value = coreMetadata.getChild("access-time", ns).getValue();
            Date accessTime = new Date(Long.parseLong(value) * 1000L);
            metadata.setAccessTime(accessTime);
            value = coreMetadata.getChild("update-time", ns).getValue();
            Date modeTime = new Date(Long.parseLong(value) * 1000L);
            metadata.setModTime(modeTime);
            try {
                metadata.setUid(coreMetadata.getChild("uid", ns).getValue());
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception parsing metadata for: " + filePath, e);
            }
            try {
                metadata.setGid(coreMetadata.getChild("gid", ns).getValue());
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception parsing metadata for: " + filePath, e);
            }
            try {
                metadata.setShred(Boolean.valueOf(coreMetadata.getChild("shred", ns).getValue()));
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception parsing metadata for: " + filePath, e);
            }
            if (metadata.getFileType().equals(FileType.DIRECTORY)) {
                try {
                    String retentionStr = coreMetadata.getChild("retention", ns).getValue();
                    if (retentionStr != null && retentionStr.length() > 0) {
                        Retention dirRetention = Retention.fromHcapValue(retentionStr);
                        metadata.setRetention(dirRetention);
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception parsing metadata for: " + filePath, e);
                }
            } else {
                try {
                    Retention fileRetention = Retention.fromRetentionValue(Long.parseLong(coreMetadata.getChild("retention-value", ns).getValue()));
                    metadata.setRetention(fileRetention);
                }
                catch (NumberFormatException e) {
                    LOG.log(Level.WARNING, "Exception parsing metadata for: " + filePath, e);
                }
            }
            if (metadata.getFileType().equals(FileType.FILE)) {
                try {
                    metadata.setSize(Long.parseLong(coreMetadata.getChild("size", ns).getValue()));
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception parsing metadata for: " + filePath, e);
                }
                modeStr = coreMetadata.getChild("mode", ns).getValue();
                int mode = Integer.parseInt(modeStr, 8);
                try {
                    metadata.setFileMode(FileMetadata.covertHCAPToUNIX(mode, metadata.getFileType()));
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception parsing metadata for: " + filePath, e);
                }
                metadata.setHashScheme(coreMetadata.getChild("hash-scheme", ns).getValue());
                metadata.setHashValue(coreMetadata.getChild("hash-value", ns).getValue());
                try {
                    metadata.setDpl(Integer.parseInt(coreMetadata.getChild("dpl", ns).getValue()));
                }
                catch (NumberFormatException e) {
                    LOG.log(Level.WARNING, "Exception parsing metadata for: " + filePath, e);
                }
                try {
                    metadata.setRetentionHold(Boolean.valueOf(coreMetadata.getChild("retention-hold", ns).getValue()));
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception parsing metadata for: " + filePath, e);
                }
            } else if (metadata.getFileType().equals(FileType.DIRECTORY)) {
                modeStr = coreMetadata.getChild("mode", ns).getValue();
                int mode = Integer.parseInt(modeStr, 8);
                try {
                    metadata.setDirMode(FileMetadata.covertHCAPToUNIX(mode, metadata.getFileType()));
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Exception parsing metadata for: " + filePath, e);
                }
            }
            this.getAdditionalMetadata(coreMetadata, metadata);
            Element customMetadataSizeElem = coreMetadata.getChild("custom-metadata-size", ns);
            CustomMetadata customMetadata = null;
            if (customMetadataSizeElem != null) {
                customMetadata = new CustomMetadata(StructuredMetadata.Form.PROFILED, filePath);
            }
            metadata.setCustomMetadata(customMetadata);
        }
        catch (JDOMException e) {
            LOG.log(Level.WARNING, "JDOMException parsing additional metadata for: " + filePath, e);
            throw new StorageAdapterLiteralException("Error parsing metadata for file " + filePath, e);
        }
        catch (IOException e) {
            this.handleIOExceptionFromRequest(e, "getting metadata of", pathOfObjFile);
        }
        finally {
            try {
                if (xmlInputStream != null) {
                    xmlInputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                this.close();
            }
            catch (Exception exception) {}
        }
    }

    public static List<InetAddress> getHostAddresses(URL location) throws UnknownHostException {
        return Hcap2Adapter.getHostAddresses(location.getHost());
    }

    public static List<InetAddress> getHostAddresses(String hostName) throws UnknownHostException {
        return Arrays.asList(InetAddress.getAllByName(hostName));
    }

    public static List<InetAddress> getHostAddresses(HCAPProfile profile) throws UnknownHostException {
        List<InetAddress> addresses = null;
        if (profile.isConnectByDns()) {
            addresses = Hcap2Adapter.getHostAddresses(profile.getHostname());
        } else {
            addresses = new ArrayList<InetAddress>();
            for (String ipString : profile.getIpAddressList()) {
                addresses.addAll(Hcap2Adapter.getHostAddresses(ipString));
            }
        }
        return addresses;
    }

    @Override
    public ArcMoverFile createArcMoverFileObject(XMLStreamReader xmlr, ArcMoverDirectory caller) throws StorageAdapterException {
        ArcMoverFile retVal = null;
        try {
            ArcMoverDirectory rootDir = ArcMoverDirectory.getDirInstance(this.getProfile(), caller.getPath(), this);
            String fileName = xmlr.getAttributeValue(null, "name");
            try {
                fileName = RFC2396Encoder.fixEncoding(fileName);
            }
            catch (UnsupportedEncodingException e) {
                throw new StorageAdapterException(e.getMessage(), e);
            }
            String fileTypeStr = xmlr.getAttributeValue(null, "fileType");
            FileType fileType = FileType.FILE;
            if (fileTypeStr.equals("directory")) {
                fileType = FileType.DIRECTORY;
            } else if (fileTypeStr.equals("symlink")) {
                fileType = FileType.SYMLINK;
            }
            String modifyTimeString = xmlr.getAttributeValue(null, "modTime");
            String accessTimeString = xmlr.getAttributeValue(null, "accessTime");
            Date modifyTime = modifyTimeString == null ? null : new Date(Long.parseLong(modifyTimeString) * 1000L);
            Date accessTime = accessTimeString == null ? null : new Date(Long.parseLong(accessTimeString) * 1000L);
            long size = 0L;
            int mode = 0;
            Long uid = 0L;
            Long gid = 0L;
            try {
                size = Long.parseLong(xmlr.getAttributeValue(null, "size"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                mode = FileMetadata.covertHCAPToUNIX(Integer.parseInt(xmlr.getAttributeValue(null, "mode")), fileType);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                uid = UidGidUtil.validateId(xmlr.getAttributeValue(null, "uid"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                gid = UidGidUtil.validateId(xmlr.getAttributeValue(null, "gid"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            FileMetadata metadata = new FileMetadata(fileType, null, null, modifyTime, accessTime, size, fileName.startsWith("."), null, null, uid, gid, null, null, null, null, null, null, null, null, null, null, null, null);
            if (fileType.equals(FileType.DIRECTORY) && !fileName.equals(".")) {
                metadata.setDirMode(mode);
                retVal = ArcMoverDirectory.getDirInstance(rootDir, fileName, metadata, this);
            } else if (fileType.equals(FileType.FILE)) {
                metadata.setFileMode(mode);
                ArcMoverFile moverFile = ArcMoverFile.getFileInstance(this.getProfile(), rootDir, fileName, metadata);
                retVal = moverFile;
            } else if (FileType.SYMLINK == fileType) {
                retVal = ArcMoverSymlink.getSymlinkInstance(rootDir, fileName, null, this);
            }
        }
        catch (Exception e) {
            String msg = "Error parsing directory for: " + caller.getPath();
            LOG.log(Level.INFO, msg, e);
            IOException e2 = new IOException(msg);
            e2.initCause(e);
            throw new StorageAdapterException(e2.getMessage(), e2);
        }
        return retVal;
    }

    protected FileType getFileType(String path) throws StorageAdapterException {
        FileType result = FileType.FILE;
        try {
            String pathToTest = this.getMetadataPathForObject(path, FileType.DIRECTORY, false);
            if (this.exists(pathToTest)) {
                result = FileType.DIRECTORY;
            }
        }
        catch (StorageAdapterException storageAdapterException) {
            // empty catch block
        }
        return result;
    }

    protected boolean getAdditionalMetadata(Element coreMetadata, FileMetadata metadata) {
        return false;
    }

    protected String generateQueryParameters(FileMetadata md, boolean addJustPOSIX) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (md.hasFileMode()) {
            params.add((NameValuePair)new BasicNameValuePair("file_permissions", "" + md.getFileMode()));
        }
        if (md.hasDirMode()) {
            params.add((NameValuePair)new BasicNameValuePair("directory_permissions", "" + md.getDirMode()));
        }
        if (md.hasUid()) {
            params.add((NameValuePair)new BasicNameValuePair("uid", "" + md.getUid()));
        }
        if (md.hasGid()) {
            params.add((NameValuePair)new BasicNameValuePair("gid", "" + md.getGid()));
        }
        if (!addJustPOSIX) {
            if (md.hasNonDefaultRetention()) {
                params.add((NameValuePair)new BasicNameValuePair("retention", "" + md.getRetention().getHCAPValue()));
            }
            if (md.hasShred()) {
                String shredValue = md.isShred() != false ? "1" : "0";
                params.add((NameValuePair)new BasicNameValuePair("shred", shredValue));
            }
            this.addAdditionalQueryParams(md, params);
        }
        String queryString = null;
        if (params.size() > 0) {
            queryString = URLEncodedUtils.format(params, (String)"UTF-8");
            LOG.log(Level.FINE, "generateQueryParameters=" + queryString);
        }
        return queryString;
    }

    protected boolean addAdditionalQueryParams(FileMetadata md, List<NameValuePair> params) {
        return false;
    }

    @Override
    protected List<NameValuePair> handleDeleteOperation(DeleteJob.Operation operation, String reason) throws StorageAdapterLiteralException {
        return null;
    }

    @Override
    protected String getErrorHeader() {
        return "X-ArcErrorMessage";
    }

    @Override
    protected void executeMethod(HCAPAdapter.HcapAdapterCookie cookie) throws IOException {
        try {
            BasicHttpContext context = new BasicHttpContext();
            HttpResponse response = this.httpClient.execute(cookie.getHost(), (HttpRequest)cookie.getRequest());
            cookie.setResponseAndContext(response, (HttpContext)context);
        }
        catch (ConnectionPoolTimeoutException e) {
            LOG.log(Level.FINE, "Timed out waiting for connection from pool.  This may be caused by a failure to call HttpMethod.release()", e);
            throw e;
        }
        catch (IOException e) {
            LOG.log(Level.FINE, "Unexpected IOException", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLCertChain getSSLCerts() throws IOException, StorageAdapterException {
        HttpHost httpHost = new HttpHost(this.getHost(), this.profile.getPort(), "getcerts");
        HttpHead request = new HttpHead("/");
        HCAPAdapter.HcapAdapterCookie cookie = new HCAPAdapter.HcapAdapterCookie((HttpUriRequest)request, httpHost);
        Object object = this.savingCookieLock;
        synchronized (object) {
            if (this.savedCookie != null) {
                throw new RuntimeException("This adapter already has a current connection to host -- cannot create two at once.");
            }
            this.savedCookie = cookie;
        }
        try {
            this.executeMethod(cookie);
        }
        catch (SSLException e) {
            LOG.log(Level.WARNING, "Exception getting certs.  sslCerts = " + this.sslCerts, e);
            throw new SSLCertException(e, this.sslCerts);
        }
        finally {
            this.close();
        }
        LOG.finer("Returning sslCerts = " + this.sslCerts);
        return this.sslCerts;
    }

    @Override
    public boolean copyDirMetadataWhenMigrating() {
        return true;
    }

    private static class HttpMkdir
    extends HttpRequestBase {
        public static final String METHOD_NAME = "MKDIR";

        private HttpMkdir(URI uri) {
            this.setURI(uri);
        }

        public String getMethod() {
            return METHOD_NAME;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

