/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.adapter;

import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.impl.adapter.ConnectionTestException;
import com.archivas.clienttools.arcutils.impl.adapter.HCAPAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterLiteralException;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.ArcMoverSymlink;
import com.archivas.clienttools.arcutils.model.CustomMetadata;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.model.Retention;
import com.archivas.clienttools.arcutils.model.StructuredMetadata;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.Hcp3AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.utils.Base64Utils;
import com.archivas.clienttools.arcutils.utils.FileUtil;
import com.archivas.clienttools.arcutils.utils.RFC2396Encoder;
import com.archivas.clienttools.arcutils.utils.net.GetCertsX509TrustManager;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.xml.stream.XMLStreamReader;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Hcp3AuthNamespaceAdapter
extends HCAPAdapter {
    public static Logger LOG = Logger.getLogger(Hcp3AuthNamespaceAdapter.class.getName());
    Hcp3AuthNamespaceProfile profile;
    public static final String PROC_PATH = "/proc/";

    public Hcp3AuthNamespaceAdapter(Hcp3AuthNamespaceProfile profile, SSLCertificateCallback sslExceptionCallback, AbstractHttpClient httpClient) throws StorageAdapterException {
        this.profile = profile;
        this.httpClient = httpClient;
        if (httpClient == null) {
            this.init(sslExceptionCallback);
        }
        this.sslExceptionCallback = sslExceptionCallback;
        this.debugName = "hcap3AuthNamespaceAdapter" + ++adapterCnt;
    }

    @Override
    public void setProfile(AbstractProfileBase profile) {
        if (profile instanceof Hcp3AuthNamespaceProfile) {
            this.profile = (Hcp3AuthNamespaceProfile)profile;
        }
    }

    @Override
    public Hcp3AuthNamespaceProfile getProfile() {
        return this.profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mkdir(String path, FileMetadata metadata) throws StorageAdapterException {
        URI uri;
        HttpHost httpHost = new HttpHost(this.getHost(), this.profile.getPort(), this.profile.getProtocol());
        String query = "?type=directory";
        String uriPath = this.getProfile().resolvePath(path);
        try {
            String urlPath = uriPath + query;
            URL url = new URL(this.profile.getProtocol(), this.getHost(), urlPath);
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            LOG.log(Level.WARNING, "Unexpected error generating put URI for : " + uriPath);
            throw new StorageAdapterLiteralException("Error making a new directory on the server", e);
        }
        catch (MalformedURLException e) {
            LOG.log(Level.WARNING, "Unexpected error generating put URL for : " + uriPath);
            throw new StorageAdapterLiteralException("Error making a new directory on the server", e);
        }
        HttpPut request = new HttpPut(uri);
        try {
            HCAPAdapter.HcapAdapterCookie cookie = new HCAPAdapter.HcapAdapterCookie((HttpUriRequest)request, httpHost);
            Object object = this.savingCookieLock;
            synchronized (object) {
                if (this.savedCookie != null) {
                    throw new RuntimeException("This adapter already has a current connection to host -- cannot create two at once.");
                }
                this.savedCookie = cookie;
            }
            this.executeMethod(cookie);
            this.handleHttpResponse(cookie.getResponse(), "creating directory", path);
        }
        catch (IOException e) {
            this.handleIOExceptionFromRequest(e, "creating directory", path);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mkSymlink(String path, String symlinkTargetPath) throws StorageAdapterException {
        URI uri;
        block16: {
            String parentPath;
            if (path.length() > 1 && path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if ((parentPath = FileUtil.getPath(path)) != null && !parentPath.equals(path) && !this.exists(parentPath)) {
                try {
                    this.mkdir(parentPath, null);
                }
                catch (StorageAdapterException e) {
                    Integer statusCode = e.getStatusCode();
                    if (statusCode != null && statusCode == 409) break block16;
                    throw e;
                }
            }
        }
        HttpHost httpHost = new HttpHost(this.getHost(), this.profile.getPort(), this.profile.getProtocol());
        String query = "?type=symlink&symlink-target=";
        String uriPath = this.getProfile().resolvePath(path);
        try {
            String urlPath = uriPath + query + symlinkTargetPath;
            URL url = new URL(this.profile.getProtocol(), this.getHost(), urlPath);
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            LOG.log(Level.WARNING, "Unexpected error generating put URI for : " + uriPath);
            throw new StorageAdapterLiteralException("Error making a new symlink on the server", e);
        }
        catch (MalformedURLException e) {
            LOG.log(Level.WARNING, "Unexpected error generating put URL for : " + uriPath);
            throw new StorageAdapterLiteralException("Error making a new symlink on the server", e);
        }
        HttpPut request = new HttpPut(uri);
        try {
            HCAPAdapter.HcapAdapterCookie cookie = new HCAPAdapter.HcapAdapterCookie((HttpUriRequest)request, httpHost);
            Object object = this.savingCookieLock;
            synchronized (object) {
                if (this.savedCookie != null) {
                    throw new RuntimeException("This adapter already has a current connection to host -- cannot create two at once.");
                }
                this.savedCookie = cookie;
            }
            this.executeMethod(cookie);
            this.handleHttpResponse(cookie.getResponse(), "creating symlink", path);
        }
        catch (IOException e) {
            this.handleIOExceptionFromRequest(e, "creating symlink", path);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void writeObjectFromStream(String targetNode, String targetPath, InputStream is, FileMetadata ingestionMetadata) throws StorageAdapterException {
        this.doWriteStream(targetNode, targetPath, is, ingestionMetadata, false);
    }

    public int doWriteStream(String targetNode, String targetPath, InputStream is, FileMetadata ingestionMetadata, boolean writingCustomMetadata) throws StorageAdapterException {
        return this.doWriteStream(targetNode, targetPath, is, ingestionMetadata, writingCustomMetadata, null);
    }

    public int doWriteStream(String targetNode, String targetPath, InputStream is, FileMetadata ingestionMetadata, boolean writingCustomMetadata, String annotation) throws StorageAdapterException {
        String activity = "writing";
        if (writingCustomMetadata) {
            activity = activity + " custom metadata for";
        }
        String targetFile = targetPath;
        String queryString = null;
        if (ingestionMetadata != null && !writingCustomMetadata) {
            queryString = this.generateQueryParameters(ingestionMetadata, true);
        } else if (writingCustomMetadata) {
            queryString = this.buildCMQueryString(null, annotation);
        }
        return this.reallyDoWriteStream(targetNode, targetFile, queryString, is, activity, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reallyDoWriteStream(String targetNode, String targetFile, String queryString, InputStream is, String activity, Header contentTypeHeader) throws StorageAdapterLiteralException, StorageAdapterException {
        URI uri;
        int statusCode = -1;
        HttpHost httpHost = new HttpHost(targetNode, this.profile.getPort(), this.profile.getProtocol());
        try {
            String resolvedPath = this.getProfile().resolvePath(targetFile);
            uri = URIUtils.createURI((String)this.profile.getProtocol(), (String)targetNode, (int)this.profile.getPort(), (String)resolvedPath, (String)queryString, null);
        }
        catch (URISyntaxException e) {
            LOG.log(Level.WARNING, "Unexpected error generating put URI for : " + targetFile);
            throw new StorageAdapterLiteralException("Error writing object to the server", e);
        }
        HttpPut request = new HttpPut(uri);
        if (contentTypeHeader != null) {
            request.setHeader(contentTypeHeader);
        }
        try {
            InputStreamEntity isEntity = new InputStreamEntity(is, -1L);
            request.setEntity((HttpEntity)isEntity);
            request.getParams().setParameter("http.protocol.expect-continue", (Object)Boolean.TRUE);
            request.getParams().setParameter("http.protocol.wait-for-continue", (Object)100);
            HCAPAdapter.HcapAdapterCookie cookie = new HCAPAdapter.HcapAdapterCookie((HttpUriRequest)request, httpHost);
            Object object = this.savingCookieLock;
            synchronized (object) {
                if (this.savedCookie != null) {
                    throw new RuntimeException("This adapter already has a current connection to host -- cannot create two at once.");
                }
                this.savedCookie = cookie;
            }
            this.executeMethod(cookie);
            this.handleHttpResponse(cookie.getResponse(), activity, targetFile);
        }
        catch (IOException e) {
            this.handleIOExceptionFromRequest(e, activity, targetFile);
        }
        finally {
            this.close();
        }
        return statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMetadata(String targetNode, String path, FileMetadata metadata) throws StorageAdapterException {
        URI uri;
        String queryString = this.generateQueryParameters(metadata, false);
        HttpHost httpHost = new HttpHost(targetNode, this.profile.getPort(), this.profile.getProtocol());
        try {
            String resolvedPath = this.getProfile().resolvePath(path);
            uri = URIUtils.createURI((String)this.profile.getProtocol(), (String)targetNode, (int)this.profile.getPort(), (String)resolvedPath, (String)queryString, null);
        }
        catch (URISyntaxException e) {
            LOG.log(Level.WARNING, "Unexpected error generating post URI for : " + path);
            throw new StorageAdapterLiteralException("Error writing metadata to the server", e);
        }
        String activity = "setting metadata";
        HttpPost request = new HttpPost(uri);
        try {
            HCAPAdapter.HcapAdapterCookie cookie = new HCAPAdapter.HcapAdapterCookie((HttpUriRequest)request, httpHost);
            Object object = this.savingCookieLock;
            synchronized (object) {
                if (this.savedCookie != null) {
                    throw new RuntimeException("This adapter already has a current connection to host -- cannot create two at once.");
                }
                this.savedCookie = cookie;
            }
            this.executeMethod(cookie);
            this.handleHttpResponse(cookie.getResponse(), activity, path);
        }
        catch (IOException e) {
            this.handleIOExceptionFromRequest(e, activity, path);
        }
        finally {
            this.close();
        }
    }

    @Override
    public ArcMoverDirectory getVersions(String path) throws StorageAdapterException {
        return ArcMoverDirectory.getFileVersions(this.getProfile(), path, this);
    }

    @Override
    public void setCustomMetadata(String file, String metadata) throws StorageAdapterException {
        this.setCustomMetadata(file, metadata, null);
    }

    public void setCustomMetadata(String file, String metadata, String annotation) throws StorageAdapterException {
        LOG.info("Attempting to write " + (annotation == null ? "custom metadata" : "annotation " + annotation) + ".");
        this.doWriteStream(this.getHost(), file, new ByteArrayInputStream(metadata.getBytes()), null, true, annotation);
    }

    @Override
    public void deleteCustomMetadata(String path) throws StorageAdapterException {
        LOG.info("Attempting to delete custom metadata");
        this.delete(path, false, DeleteJob.Operation.DELETE, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileMetadata getMetadata(String filePath, String queryString, FileType unused, boolean isVersion) throws StorageAdapterException {
        FileMetadata metadata = null;
        HttpHost httpHost = new HttpHost(this.getHost(), this.profile.getPort(), this.profile.getProtocol());
        String urlPath = filePath;
        if (queryString != null) {
            urlPath = urlPath + queryString;
        }
        HttpHead request = new HttpHead(this.getProfile().resolvePath(urlPath));
        try {
            FileType responseType;
            HCAPAdapter.HcapAdapterCookie cookie = new HCAPAdapter.HcapAdapterCookie((HttpUriRequest)request, httpHost);
            Object object = this.savingCookieLock;
            synchronized (object) {
                if (this.savedCookie != null) {
                    throw new RuntimeException("This adapter already has a current connection to host -- cannot create two at once.");
                }
                this.savedCookie = cookie;
            }
            this.executeMethod(cookie);
            this.handleHttpResponse(cookie.getResponse(), "getting metadata", filePath);
            Header[] headers = cookie.getResponse().getAllHeaders();
            String symlinkTarget = null;
            for (Header h : headers) {
                if (!"X-HCP-SymlinkTarget".equals(h.getName())) continue;
                symlinkTarget = h.getValue();
            }
            String responseTypeStr = cookie.getResponse().getFirstHeader("X-HCP-Type").getValue();
            FileType fileType = responseType = "object".equals(responseTypeStr) ? FileType.FILE : FileType.DIRECTORY;
            if (symlinkTarget != null) {
                fileType = FileType.SYMLINK;
            }
            if (responseType == FileType.DIRECTORY) {
                metadata = new FileMetadata(fileType);
            } else if (responseType == FileType.FILE) {
                int hashIndex;
                long size = Long.parseLong(cookie.getResponse().getFirstHeader("X-HCP-Size").getValue());
                long version = Long.parseLong(cookie.getResponse().getFirstHeader("X-HCP-VersionId").getValue());
                String ingestTimeString = cookie.getResponse().getFirstHeader("X-HCP-IngestTime").getValue();
                Date ingestTime = ingestTimeString == null ? null : new Date(Long.parseLong(ingestTimeString) * 1000L);
                boolean retentionHold = Boolean.parseBoolean(cookie.getResponse().getFirstHeader("X-HCP-RetentionHold").getValue());
                boolean shred = Boolean.parseBoolean(cookie.getResponse().getFirstHeader("X-HCP-Shred").getValue());
                int dpl = Integer.parseInt(cookie.getResponse().getFirstHeader("X-HCP-DPL").getValue());
                boolean searchIndex = Boolean.parseBoolean(cookie.getResponse().getFirstHeader("X-HCP-Index").getValue());
                Boolean replicated = null;
                try {
                    replicated = Boolean.parseBoolean(cookie.getResponse().getFirstHeader("X-HCP-Replicated").getValue());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                boolean hasCustomMetadata = Boolean.parseBoolean(cookie.getResponse().getFirstHeader("X-HCP-Custom-Metadata").getValue());
                CustomMetadata customMetadata = null;
                if (hasCustomMetadata) {
                    customMetadata = new CustomMetadata(StructuredMetadata.Form.PROFILED, filePath, isVersion ? Long.valueOf(version) : null);
                }
                String retentionClass = null;
                Long retentionValue = null;
                String retentionString = null;
                try {
                    retentionClass = cookie.getResponse().getFirstHeader("X-HCP-RetentionClass").getValue();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    retentionValue = Long.parseLong(cookie.getResponse().getFirstHeader("X-HCP-Retention").getValue());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    retentionString = cookie.getResponse().getFirstHeader("X-HCP-RetentionString").getValue();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (retentionString != null && !retentionString.equals("")) {
                    if (retentionString.equals(Retention.DELETION_ALLOWED.getUIValue())) {
                        retentionValue = Long.parseLong(Retention.DELETION_ALLOWED.getHCAPValue());
                    } else if (retentionString.equals(Retention.DELETION_PROHIBITED.getUIValue())) {
                        retentionValue = Long.parseLong(Retention.DELETION_PROHIBITED.getHCAPValue());
                    } else if (retentionString.equals(Retention.INITIAL_UNSPECIFIED.getUIValue())) {
                        retentionValue = Long.parseLong(Retention.INITIAL_UNSPECIFIED.getHCAPValue());
                    }
                }
                Retention retention = Retention.fromRetentionValueAndClass(retentionValue, retentionClass);
                String hash = "";
                String hashScheme = "";
                String hashValue = "";
                Header hashHeader = cookie.getResponse().getFirstHeader("X-HCP-Hash");
                if (hashHeader != null && (hashIndex = (hash = hashHeader.getValue()).indexOf(32)) > 0) {
                    hashScheme = hash.substring(0, hashIndex).trim();
                    hashValue = hash.substring(hashIndex).trim();
                }
                metadata = new FileMetadata(fileType, ingestTime, null, null, null, size, null, null, null, null, null, version, dpl, hashScheme, hashValue, shred, retention, retentionHold, searchIndex, replicated, null, null, customMetadata);
                if (symlinkTarget != null) {
                    metadata.setSymlinkTarget(symlinkTarget);
                }
                this.getAdditionalMetadata(cookie.getResponse(), metadata, filePath);
            }
            if (metadata != null && symlinkTarget != null) {
                metadata.setSymlinkTarget(symlinkTarget);
            }
        }
        catch (IOException e) {
            this.handleIOExceptionFromRequest(e, "getting metadata", filePath);
        }
        finally {
            this.close();
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCustomMetadata(String filePath, Long version, FileType fileType) throws StorageAdapterException {
        BufferedReader reader = null;
        try {
            InputStream inputStream = this.getCustomMetadataStream(filePath, version, fileType);
            if (inputStream != null) {
                reader = new BufferedReader(new InputStreamReader(inputStream));
            }
            String string = reader != null ? Hcp3AuthNamespaceAdapter.getCustomMetadata(reader) : null;
            return string;
        }
        catch (IOException e) {
            String errorMessage = String.format("CustomMetadata does not exist for path '%s'%s.", filePath, version == null ? "" : " at version " + version);
            LOG.log(Level.FINE, errorMessage, e);
            String string = null;
            return string;
        }
        finally {
            RuntimeException e = null;
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException io) {
                LOG.fine("Error closing steam in getCustomMetadata.  Exception=" + io);
            }
            catch (RuntimeException ex) {
                e = ex;
            }
            this.close();
            if (e != null) {
                throw e;
            }
        }
    }

    @Override
    public InputStream getCustomMetadataStream(String filePath, Long version, FileType fileType) throws StorageAdapterException {
        return this.getCustomMetadataStream(filePath, version, fileType, null);
    }

    @Override
    public InputStream getCustomMetadataStream(String filePath, Long version, FileType fileType, String annotation) throws StorageAdapterException {
        InputStream result = null;
        String queryString = this.buildCMQueryString(version, annotation);
        if (this.exists(filePath, queryString)) {
            result = this.getInputStream(filePath, queryString);
        }
        return result;
    }

    protected String buildCMQueryString(Long version, String annotation) {
        StringBuilder sb = new StringBuilder("type=custom-metadata");
        if (version != null) {
            sb.append("&version=" + version);
        }
        return sb.toString();
    }

    @Override
    public void setCustomMetadataStream(String file, InputStream metadata) throws StorageAdapterException {
        this.setCustomMetadataStream(file, metadata, null);
    }

    @Override
    public void setCustomMetadataStream(String file, InputStream metadata, String annotation) throws StorageAdapterException {
        LOG.info("Attempting to write " + (annotation == null ? "custom metadata" : "annotation " + annotation) + ".");
        this.doWriteStream(this.getHost(), file, metadata, null, true, annotation);
    }

    protected boolean getAdditionalMetadata(HttpResponse response, FileMetadata metadata, String filePath) {
        return false;
    }

    protected boolean getAdditionalMetadata(XMLStreamReader xmlr, FileMetadata metadata, String filePath) {
        return false;
    }

    @Override
    protected String getQueryStringForFileListIterator(ArcMoverDirectory caller, boolean includeDeleted, boolean supportsVersioning) throws StorageAdapterException {
        String query = "";
        if (supportsVersioning) {
            query = !includeDeleted ? "?deleted=false" : (caller.isVersionList() ? "?version=list&deleted=true" : "?deleted=true");
        }
        return query;
    }

    @Override
    public ArcMoverFile createArcMoverFileObject(XMLStreamReader xmlr, ArcMoverDirectory caller) throws StorageAdapterException {
        ArcMoverFile retVal;
        block35: {
            retVal = null;
            try {
                String fileName = xmlr.getAttributeValue(null, "urlName");
                if (fileName == null) {
                    fileName = xmlr.getAttributeValue(null, "utf8Name");
                } else {
                    try {
                        fileName = RFC2396Encoder.fixEncoding(fileName);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new StorageAdapterException(e.getMessage(), e);
                    }
                }
                String fileType = xmlr.getAttributeValue(null, "type");
                if (fileType == null) break block35;
                String state = xmlr.getAttributeValue(null, "state");
                if ("directory".equals(fileType)) {
                    retVal = ArcMoverDirectory.getDirInstance(caller, fileName, null, this);
                } else if ("symlink".equals(fileType)) {
                    String symlinkTarget = xmlr.getAttributeValue(null, "symlinkTarget");
                    retVal = ArcMoverSymlink.getSymlinkInstance(caller, fileName, symlinkTarget, this);
                } else if ("object".equals(fileType)) {
                    long size = 0L;
                    long version = 0L;
                    long retentionValue = 0L;
                    int dpl = 0;
                    boolean shred = false;
                    boolean retentionHold = false;
                    boolean searchIndex = false;
                    boolean replicated = false;
                    boolean hasCustomMetadata = false;
                    try {
                        size = Long.parseLong(xmlr.getAttributeValue(null, "size"));
                    }
                    catch (NumberFormatException e) {
                        LOG.log(Level.WARNING, "Exception parsing metadata for: " + fileName, e);
                    }
                    try {
                        version = Long.parseLong(xmlr.getAttributeValue(null, "version"));
                    }
                    catch (NumberFormatException e) {
                        LOG.log(Level.WARNING, "Exception parsing metadata for: " + fileName, e);
                    }
                    String ingestTimeString = xmlr.getAttributeValue(null, "ingestTime");
                    Date ingestTime = ingestTimeString == null ? null : new Date(Long.parseLong(ingestTimeString) * 1000L);
                    try {
                        size = Long.parseLong(xmlr.getAttributeValue(null, "size"));
                    }
                    catch (NumberFormatException e) {
                        LOG.log(Level.WARNING, "Exception parsing metadata for: " + fileName, e);
                    }
                    try {
                        version = Long.parseLong(xmlr.getAttributeValue(null, "version"));
                    }
                    catch (NumberFormatException e) {
                        LOG.log(Level.WARNING, "Exception parsing metadata for: " + fileName, e);
                    }
                    try {
                        retentionValue = Long.parseLong(xmlr.getAttributeValue(null, "retention"));
                    }
                    catch (NumberFormatException e) {
                        LOG.log(Level.WARNING, "Exception parsing metadata for: " + fileName, e);
                    }
                    try {
                        dpl = Integer.parseInt(xmlr.getAttributeValue(null, "dpl"));
                    }
                    catch (NumberFormatException e) {
                        LOG.log(Level.WARNING, "Exception parsing metadata for: " + fileName, e);
                    }
                    try {
                        shred = Boolean.parseBoolean(xmlr.getAttributeValue(null, "shred"));
                    }
                    catch (NullPointerException e) {
                        LOG.log(Level.WARNING, "Exception parsing metadata for: " + fileName, e);
                    }
                    try {
                        retentionHold = Boolean.parseBoolean(xmlr.getAttributeValue(null, "hold"));
                    }
                    catch (NullPointerException e) {
                        LOG.log(Level.WARNING, "Exception parsing metadata for: " + fileName, e);
                    }
                    try {
                        searchIndex = Boolean.parseBoolean(xmlr.getAttributeValue(null, "index"));
                    }
                    catch (NullPointerException e) {
                        LOG.log(Level.WARNING, "Exception parsing metadata for: " + fileName, e);
                    }
                    try {
                        replicated = Boolean.parseBoolean(xmlr.getAttributeValue(null, "replicated"));
                    }
                    catch (NullPointerException e) {
                        LOG.log(Level.WARNING, "Exception parsing metadata for: " + fileName, e);
                    }
                    String retentionClass = xmlr.getAttributeValue(null, "retentionClass");
                    String hashScheme = xmlr.getAttributeValue(null, "hashScheme");
                    String hashValue = xmlr.getAttributeValue(null, "hash");
                    Retention retention = null;
                    retention = retentionClass != null && !retentionClass.equals("") ? Retention.fromRetentionClass(retentionClass, retentionValue) : Retention.fromRetentionValue(retentionValue);
                    FileMetadata metadata = new FileMetadata(FileType.FILE, ingestTime, null, null, null, size, null, null, null, null, null, version, dpl, hashScheme, hashValue, shred, retention, retentionHold, searchIndex, replicated, null, null, null);
                    metadata.setIsVersion(caller.isVersionList());
                    retVal = ArcMoverFile.getFileInstance(this.getProfile(), caller, fileName, metadata);
                    this.getAdditionalMetadata(xmlr, retVal.getMetadata(), retVal.getPath());
                    try {
                        hasCustomMetadata = Boolean.parseBoolean(xmlr.getAttributeValue(null, "customMetadata"));
                    }
                    catch (NullPointerException e) {
                        LOG.log(Level.WARNING, "Exception parsing metadata for: " + fileName, e);
                    }
                    CustomMetadata customMetadata = null;
                    if (hasCustomMetadata) {
                        customMetadata = new CustomMetadata(StructuredMetadata.Form.PROFILED, retVal.getPath());
                    }
                    retVal.setCustomMetadata(customMetadata);
                }
                if (retVal != null) {
                    retVal.getMetadata().setRestState(state);
                }
            }
            catch (Throwable e) {
                String msg = "Error parsing directory for: " + caller.getPath();
                IOException e2 = new IOException(msg);
                e2.initCause(e);
                throw new StorageAdapterException(e2.getMessage(), e2);
            }
        }
        return retVal;
    }

    private boolean doesNamespaceHavePermissions() throws StorageAdapterException {
        block17: {
            InputStream iStream = null;
            try {
                SAXBuilder builder = new SAXBuilder(false);
                iStream = this.getInputStream(PROC_PATH, false);
                Document procXML = builder.build(iStream);
                LOG.log(Level.FINEST, "procXML=" + procXML);
                this.close();
                Element procElement = procXML.getRootElement();
                boolean bl = this.doesNamespaceHavePermissions(procElement, this.getProfile().getNamespace());
                return bl;
            }
            catch (IOException e) {
                this.handleIOExceptionFromRequest(e, "accessing namespace info for", this.getHost());
            }
            catch (JDOMException e) {
                String errMsg = "Exception parsing proc data for archive with profile: " + this.getProfile();
                LOG.log(Level.WARNING, errMsg, e);
                throw new StorageAdapterLiteralException(errMsg, e);
            }
            finally {
                RuntimeException e = null;
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (IOException io) {
                    LOG.log(Level.FINE, "IOException closing during getProc", io);
                }
                catch (RuntimeException ex) {
                    e = ex;
                }
                this.close();
                if (e == null) break block17;
                throw e;
            }
        }
        throw new RuntimeException("Error determining if the profile has permissions to the requested namespace");
    }

    @Override
    public boolean isVersioningEnabled() throws StorageAdapterException {
        return this.isVersioningEnabled(PROC_PATH);
    }

    private boolean doesNamespaceHavePermissions(Element procElement, String namespace) {
        if (namespace == null || namespace.length() == 0) {
            return false;
        }
        List nspaces = procElement.getChildren("namespace");
        for (Element nsElem : nspaces) {
            if (!namespace.equalsIgnoreCase(nsElem.getAttributeValue("name"))) continue;
            return true;
        }
        return false;
    }

    protected boolean isVersioningEnabled(String procPath) throws StorageAdapterException {
        block17: {
            InputStream iStream = null;
            try {
                SAXBuilder builder = new SAXBuilder(false);
                iStream = this.getInputStream(procPath, false);
                Document procXML = builder.build(iStream);
                LOG.log(Level.FINEST, "procXML=" + procXML);
                this.close();
                Element procElement = procXML.getRootElement();
                boolean bl = this.isVersioningEnabled(procElement, this.getProfile().getNamespace());
                return bl;
            }
            catch (IOException e) {
                this.handleIOExceptionFromRequest(e, "accessing namespace info for", this.getHost());
            }
            catch (JDOMException e) {
                String errMsg = "Exception parsing proc data for archive with profile: " + this.getProfile();
                LOG.log(Level.WARNING, errMsg, e);
                throw new StorageAdapterLiteralException(errMsg, e);
            }
            finally {
                RuntimeException e = null;
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (IOException io) {
                    LOG.log(Level.FINE, "IOException closing during getProc", io);
                }
                catch (RuntimeException ex) {
                    e = ex;
                }
                this.close();
                if (e == null) break block17;
                throw e;
            }
        }
        throw new RuntimeException("Error determining if versioning is enabled");
    }

    private boolean isVersioningEnabled(Element procElement, String namespace) {
        if (namespace == null || namespace.length() == 0) {
            return false;
        }
        List nspaces = procElement.getChildren("namespace");
        for (Element nsElem : nspaces) {
            if (!namespace.equalsIgnoreCase(nsElem.getAttributeValue("name"))) continue;
            return Boolean.valueOf(nsElem.getAttributeValue("versioningEnabled"));
        }
        return false;
    }

    protected String setAuthHeader(HCAPAdapter.HcapAdapterCookie cookie) {
        String authString = "";
        if (!this.profile.isAnonymousAccess()) {
            String uname64 = Base64Utils.encode(this.profile.getUsername().getBytes());
            authString = "hcp-ns-auth=" + uname64 + ":" + this.profile.getPassword();
            cookie.getRequest().setHeader("Cookie", authString);
        }
        return authString;
    }

    @Override
    protected void executeMethod(HCAPAdapter.HcapAdapterCookie cookie) throws IOException {
        String authString = this.setAuthHeader(cookie);
        HttpHost vHost = new HttpHost(this.profile.getHostHeader(), cookie.getHost().getPort(), cookie.getHost().getSchemeName());
        cookie.getRequest().getParams().setParameter("http.virtual-host", (Object)vHost);
        LOG.fine("Namespace Host: " + this.profile.getHostHeader());
        if (!this.profile.isAnonymousAccess() && !this.profile.supportsAuthorizationHeader()) {
            this.testHeaders(cookie, authString, false);
        }
        try {
            BasicHttpContext context = new BasicHttpContext();
            HttpResponse response = this.httpClient.execute(cookie.getHost(), (HttpRequest)cookie.getRequest());
            cookie.setResponseAndContext(response, (HttpContext)context);
            if (!this.profile.isAnonymousAccess() && !this.profile.supportsAuthorizationHeader()) {
                this.testHeaders(cookie, authString, false);
            }
        }
        catch (ConnectionPoolTimeoutException e) {
            LOG.log(Level.WARNING, "Timed out waiting for connection from pool.  This may be caused by a failure to call HttpMethod.release()", e);
            throw e;
        }
        catch (IOException e) {
            LOG.log(Level.INFO, "Unexpected IOException in executeMethod", e);
            throw e;
        }
        catch (NullPointerException npe) {
            if (!this.profile.isAnonymousAccess() && !this.profile.supportsAuthorizationHeader()) {
                this.testHeaders(cookie, authString, true);
            }
            String uri = "null";
            if (cookie.getRequest() != null && cookie.getRequest().getURI() != null) {
                uri = cookie.getRequest().getURI().getPath();
            }
            LOG.log(Level.WARNING, "NullPointerException in executeMethod.  Executing request on file: " + uri, npe);
            throw new NoHttpResponseException("Error executing http request,  NullPointerException thrown ");
        }
    }

    private void testHeaders(HCAPAdapter.HcapAdapterCookie cookie, String savedAuthString, boolean printSuccess) {
        Header[] headers = cookie.getRequest().getHeaders("Cookie");
        if (headers.length == 1) {
            String authStringAfter = headers[0].getValue();
            if (!savedAuthString.equals(authStringAfter)) {
                LOG.severe("Cookie Changed from: " + savedAuthString + " to " + authStringAfter);
            } else if (printSuccess) {
                LOG.severe("Cookie header is valid.");
            }
        } else {
            LOG.severe("The cookie header array had an unexpected length of: " + headers.length);
        }
    }

    protected String generateQueryParameters(FileMetadata md, boolean isCreate) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (md.hasNonDefaultRetention()) {
            params.add((NameValuePair)new BasicNameValuePair("retention", "" + md.getRetention().getHCAPValue()));
        }
        if (md.hasShred()) {
            params.add((NameValuePair)new BasicNameValuePair("shred", "" + md.isShred()));
        }
        if (md.hasSearchIndex()) {
            params.add((NameValuePair)new BasicNameValuePair("index", "" + md.isSearchIndex()));
        }
        if (md.hasRetentionHold() && md.isRetentionHold().booleanValue()) {
            params.add((NameValuePair)new BasicNameValuePair("hold", "" + md.isRetentionHold()));
        }
        this.addAdditionalQueryParams(md, params, isCreate);
        String queryString = null;
        if (params.size() > 0) {
            queryString = URLEncodedUtils.format(params, (String)"UTF-8");
            LOG.log(Level.FINE, "generateQueryParameters=" + queryString);
        }
        return queryString;
    }

    protected boolean addAdditionalQueryParams(FileMetadata md, List<NameValuePair> params, boolean isCreate) {
        return false;
    }

    @Override
    protected List<NameValuePair> handleDeleteOperation(DeleteJob.Operation operation, String reason) throws StorageAdapterLiteralException {
        ArrayList<NameValuePair> deleteOperations = new ArrayList<NameValuePair>();
        if (operation == DeleteJob.Operation.PRIVILEGED_PURGE) {
            if (reason == null || reason == "") {
                throw new StorageAdapterLiteralException("When doing a priviledged delete a reason is required.");
            }
            deleteOperations.add((NameValuePair)new BasicNameValuePair("privileged", "true"));
            deleteOperations.add((NameValuePair)new BasicNameValuePair("purge", "true"));
            deleteOperations.add((NameValuePair)new BasicNameValuePair("reason", reason));
        } else if (operation == DeleteJob.Operation.PURGE) {
            deleteOperations.add((NameValuePair)new BasicNameValuePair("purge", "true"));
        }
        return deleteOperations;
    }

    @Override
    protected String getErrorHeader() {
        return "X-HCP-ErrorMessage";
    }

    @Override
    public SSLCertChain getSSLCerts() throws IOException {
        return null;
    }

    @Override
    public void getAdditionalHcapProtocolSchemeRegistryForHttpClient(SchemeRegistry schemeRegistry, SSLCertificateCallback sslExceptionCallback) throws StorageAdapterException {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            GetCertsX509TrustManager tm = new GetCertsX509TrustManager(this.getProfile(), sslExceptionCallback);
            sslcontext.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory getCertsFactory = new SSLSocketFactory(sslcontext);
            getCertsFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            getCertsFactory = new SSLSocketFactory(sslcontext);
            Scheme getCerts = new Scheme("getcerts", (SocketFactory)getCertsFactory, 443);
            schemeRegistry.register(getCerts);
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Unable to initialize SSL for hcaphttps protocol!", e);
            throw new StorageAdapterException("Unable to initialize SSL for https protocol", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doTestConnection() throws ConnectionTestException {
        HttpHost httpHost;
        boolean isValid = false;
        HttpHead request = null;
        try {
            httpHost = new HttpHost(this.getHost(), this.getProfile().getPort(), this.getProfile().getProtocol());
        }
        catch (StorageAdapterException e) {
            throw new ConnectionTestException(e, null, this.getProfile().getNamespace(), this.getProfile().getName());
        }
        String root = this.getProfile().resolvePath("/");
        request = new HttpHead(root);
        HCAPAdapter.HcapAdapterCookie cookie = new HCAPAdapter.HcapAdapterCookie((HttpUriRequest)request, httpHost);
        Object object = this.savingCookieLock;
        synchronized (object) {
            if (this.savedCookie != null) {
                throw new RuntimeException("This adapter already has a current connection to host -- cannot create two at once.");
            }
            this.savedCookie = cookie;
        }
        IOException cause = null;
        Integer statusCode = null;
        try {
            this.executeMethod(cookie);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "IOException during testConnection", e);
            cause = e;
            isValid = false;
        }
        finally {
            this.close();
        }
        if (cookie.getResponse() != null) {
            statusCode = cookie.getResponse().getStatusLine().getStatusCode();
        }
        if (statusCode == null || statusCode != 200) {
            if (statusCode != null && statusCode == 302) {
                throw new ConnectionTestException("Invalid namespace access configuration for namespace " + this.getProfile().getNamespace() + " using profile " + this.getProfile().getName(), statusCode);
            }
            if (cause != null) {
                throw new ConnectionTestException(cause, statusCode, this.getProfile().getNamespace(), this.getProfile().getName());
            }
            throw new ConnectionTestException(statusCode, this.getProfile().getNamespace(), this.getProfile().getName());
        }
        isValid = true;
        try {
            if (!this.doesNamespaceHavePermissions()) {
                throw new ConnectionTestException("The profile user has no explicit permissions to namespace " + this.getProfile().getNamespace(), (Integer)null);
            }
        }
        catch (ConnectionTestException e) {
            throw e;
        }
        catch (StorageAdapterException e) {
            throw new ConnectionTestException(e, null, null, null);
        }
        catch (Exception e) {
            throw new ConnectionTestException(e, null, null, null);
        }
        return isValid;
    }

    @Override
    public boolean copyDirMetadataWhenMigrating() {
        return false;
    }
}

