/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.adapter;

import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.adapter.Hcap2Adapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterLiteralException;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.model.Retention;
import com.archivas.clienttools.arcutils.profile.Hcp3DefaultNamespaceProfile;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.jdom.Element;
import org.jdom.Namespace;

public class Hcp3DefaultNamespaceAdapter
extends Hcap2Adapter {
    public Hcp3DefaultNamespaceAdapter(Hcp3DefaultNamespaceProfile profile, SSLCertificateCallback sslExceptionCallback, AbstractHttpClient httpClient) throws StorageAdapterException {
        super(profile, sslExceptionCallback, httpClient);
        this.debugName = "hcp3defadapter" + ++adapterCnt;
    }

    @Override
    protected int getDirListMetadataThreshold() {
        return HCPMoverProperties.DIR_LIST_METADATA_THRESHOLD_30_DEFAULTNS.getAsInt();
    }

    @Override
    protected boolean getAdditionalMetadata(Element coreMetadata, FileMetadata metadata) {
        boolean result = false;
        Namespace ns = coreMetadata.getNamespace();
        try {
            metadata.setSearchIndex(Boolean.parseBoolean(coreMetadata.getChild("index", ns).getValue()));
            result = true;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (metadata.getFileType().equals(FileType.DIRECTORY)) {
            String retentionValue = null;
            try {
                retentionValue = coreMetadata.getChild("retention", ns).getValue();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            String retentionClass = null;
            try {
                retentionClass = coreMetadata.getChild("retention-class", ns).getValue();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            Retention retention = Retention.fromHcapValues(retentionClass, retentionValue);
            if (retention != null) {
                result = true;
            }
            metadata.setRetention(retention);
        } else {
            Long retentionValue = null;
            try {
                retentionValue = Long.parseLong(coreMetadata.getChild("retention-value", ns).getValue());
            }
            catch (NullPointerException retentionClass) {
                // empty catch block
            }
            String retentionClass = null;
            try {
                retentionClass = coreMetadata.getChild("retention-class", ns).getValue();
            }
            catch (NullPointerException retention) {
                // empty catch block
            }
            Retention retention = null;
            if (retentionClass != null) {
                retention = Retention.fromRetentionClass(retentionClass, retentionValue);
                result = true;
            } else if (retentionValue != null) {
                retention = Retention.fromRetentionValue(retentionValue);
                result = true;
            }
            metadata.setRetention(retention);
        }
        try {
            metadata.setReplicated(Boolean.parseBoolean(coreMetadata.getChild("replicated", ns).getValue()));
            result = true;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected boolean addAdditionalQueryParams(FileMetadata md, List<NameValuePair> params) {
        boolean result = false;
        if (md.hasSearchIndex()) {
            String sindexValue = md.isSearchIndex() != false ? "1" : "0";
            params.add((NameValuePair)new BasicNameValuePair("index", sindexValue));
            result = true;
        }
        return result;
    }

    @Override
    protected void setAdditionalMetadataOnDirectories(String path, FileMetadata metadata) throws StorageAdapterException {
        if (metadata != null && metadata.hasSearchIndex()) {
            this.setIndexOnDirectory(path, metadata.isSearchIndex());
        }
    }

    private void setIndexOnDirectory(String targetPath, boolean value) throws StorageAdapterException {
        String putIndexToFile = value ? "1" : "0";
        this.setDirectorySystemMetadata(targetPath, putIndexToFile, "index.txt");
    }

    @Override
    public void mkSymlink(String symlinkName, String symlinkTarget) throws StorageAdapterException {
        throw new StorageAdapterLiteralException("Creation of symbolic links via HTTP is not supported on the default namespace");
    }
}

