/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.adapter;

import com.archivas.clienttools.arcutils.impl.adapter.HCAPAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.Hcp3AuthNamespaceAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.model.ACLMetadata;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.Owner;
import com.archivas.clienttools.arcutils.model.StructuredMetadata;
import com.archivas.clienttools.arcutils.profile.Hcp5AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.utils.Base64Utils;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class Hcp5AuthNamespaceAdapter
extends Hcp3AuthNamespaceAdapter {
    public static Logger LOG = Logger.getLogger(Hcp5AuthNamespaceAdapter.class.getName());
    private final String ACL_TYPE_STR = "type=acl";

    public Hcp5AuthNamespaceAdapter(Hcp5AuthNamespaceProfile profile, SSLCertificateCallback sslExceptionCallback, AbstractHttpClient httpClient) throws StorageAdapterException {
        super(profile, sslExceptionCallback, httpClient);
    }

    @Override
    protected boolean addAdditionalQueryParams(FileMetadata md, List<NameValuePair> params, boolean isCreate) {
        boolean addedParam = false;
        if (md.hasOwner()) {
            if (!isCreate && !md.getOwner().getOwnerType().equals((Object)Owner.OwnerType.EXTERNAL)) {
                params.add((NameValuePair)new BasicNameValuePair("domain", ""));
                addedParam = true;
            }
            if (md.getOwner().getOwnerType().equals((Object)Owner.OwnerType.LOCAL)) {
                params.add((NameValuePair)new BasicNameValuePair("owner", md.getOwner().getOwnerName()));
                addedParam = true;
            } else if (md.getOwner().getOwnerType().equals((Object)Owner.OwnerType.PUBLIC)) {
                params.add((NameValuePair)new BasicNameValuePair("owner", ""));
                addedParam = true;
            } else if (md.getOwner().getOwnerType().equals((Object)Owner.OwnerType.EXTERNAL)) {
                params.add((NameValuePair)new BasicNameValuePair("owner", "" + md.getOwner().getOwnerName()));
                params.add((NameValuePair)new BasicNameValuePair("domain", "" + md.getOwner().getDomain()));
                addedParam = true;
            } else if (md.getOwner().getOwnerType().equals((Object)Owner.OwnerType.PROFILE) && !isCreate) {
                params.add((NameValuePair)new BasicNameValuePair("owner", this.getProfile().getUsername()));
                addedParam = true;
            }
        } else if (md.hasUid() && md.hasGid()) {
            params.add((NameValuePair)new BasicNameValuePair("owner", ""));
            params.add((NameValuePair)new BasicNameValuePair("uid", "" + md.getUid()));
            params.add((NameValuePair)new BasicNameValuePair("gid", "" + md.getGid()));
        } else if (md.hasUid() || md.hasGid()) {
            LOG.log(Level.SEVERE, "Object from HCP has either a UID or a GID but not both -- this will not migrate this metadata correctly");
        }
        return addedParam;
    }

    @Override
    protected boolean getAdditionalMetadata(XMLStreamReader xmlr, FileMetadata metadata, String filePath) {
        boolean hasACL = false;
        try {
            hasACL = Boolean.parseBoolean(xmlr.getAttributeValue(null, "hasAcl"));
        }
        catch (NullPointerException e) {
            LOG.log(Level.WARNING, "Exception parsing metadata for: " + filePath, e);
        }
        String owner = xmlr.getAttributeValue(null, "owner");
        String domain = xmlr.getAttributeValue(null, "domain");
        return this.handleAdditionalMetadata(metadata, hasACL, owner, domain, null, null, filePath);
    }

    @Override
    protected boolean getAdditionalMetadata(HttpResponse response, FileMetadata metadata, String filePath) {
        boolean hasACL = false;
        try {
            hasACL = Boolean.parseBoolean(response.getFirstHeader("X-HCP-ACL").getValue());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String owner = null;
        String domain = null;
        String uid = null;
        String gid = null;
        try {
            owner = response.getFirstHeader("X-HCP-Owner").getValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            domain = response.getFirstHeader("X-HCP-Domain").getValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            uid = response.getFirstHeader("X-HCP-UID").getValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            gid = response.getFirstHeader("X-HCP-GID").getValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this.handleAdditionalMetadata(metadata, hasACL, owner, domain, uid, gid, filePath);
    }

    private boolean handleAdditionalMetadata(FileMetadata metadata, boolean hasACL, String owner, String domain, String uid, String gid, String filePath) {
        Owner ownerObj;
        if (hasACL) {
            ACLMetadata acl = new ACLMetadata(StructuredMetadata.Form.PROFILED, filePath);
            metadata.setACL(acl);
        }
        if (domain != null && domain.length() > 0) {
            if (owner == null) {
                throw new IllegalArgumentException("handleAddtionalMetadata: Excepted owner value to be supplied with domain");
            }
            ownerObj = new Owner(owner, domain);
        } else if (owner != null && owner.length() > 0) {
            ownerObj = new Owner(owner);
        } else if (uid != null && uid.length() > 0 && gid != null && gid.length() > 0) {
            ownerObj = null;
            metadata.setUid(uid);
            metadata.setGid(gid);
        } else {
            ownerObj = new Owner(Owner.OwnerType.PUBLIC);
        }
        metadata.setOwner(ownerObj);
        return true;
    }

    @Override
    public InputStream getACLStream(String path) throws StorageAdapterException {
        BasicHeader contentTypeHeader = new BasicHeader("Content-Type", "application/xml");
        return this.getInputStream(path, "type=acl&prettyprint=true", (Header)contentTypeHeader);
    }

    @Override
    public void setACLFromStream(String path, InputStream aclStream) throws StorageAdapterException {
        LOG.info("Attempting to write acl.");
        String queryString = "type=acl";
        BasicHeader contentTypeHeader = new BasicHeader("Accept", "application/xml");
        this.reallyDoWriteStream(this.getHost(), path, queryString, aclStream, "writing acl", (Header)contentTypeHeader);
    }

    @Override
    public boolean isVersioningEnabled() throws StorageAdapterException {
        try {
            ArcMoverDirectory dir = this.getVersions("/HCP_dummy_filename_used_by_Data_Migrator_may_or_may_not_exist");
            dir.getFileListIterator(true, true);
            return true;
        }
        catch (StorageAdapterException e) {
            Integer statusCode = e.getStatusCode();
            if (statusCode != null && statusCode == 400) {
                return false;
            }
            if (statusCode != null && statusCode == 404) {
                return true;
            }
            throw e;
        }
    }

    @Override
    protected String setAuthHeader(HCAPAdapter.HcapAdapterCookie cookie) {
        String username = "all_users";
        String password = "";
        if (!this.profile.isAnonymousAccess()) {
            username = this.profile.getUsername();
            password = this.profile.getPassword();
        }
        String authString = "hcp-ns-auth= " + Base64Utils.encode(username.getBytes()) + ":" + password;
        cookie.getRequest().setHeader("Cookie", authString);
        return authString;
    }
}

