/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.adapter;

import com.archivas.clienttools.arcutils.impl.adapter.HCAPAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.Hcp5AuthNamespaceAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.model.CustomMetadata;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.StructuredMetadata;
import com.archivas.clienttools.arcutils.profile.Hcp6AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.utils.Base64Utils;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import org.apache.http.HttpResponse;
import org.apache.http.impl.client.AbstractHttpClient;

public class Hcp6AuthNamespaceAdapter
extends Hcp5AuthNamespaceAdapter {
    public static final Logger LOG = Logger.getLogger(Hcp6AuthNamespaceAdapter.class.getName());

    public Hcp6AuthNamespaceAdapter(Hcp6AuthNamespaceProfile profile, SSLCertificateCallback sslExceptionCallback, AbstractHttpClient httpClient) throws StorageAdapterException {
        super(profile, sslExceptionCallback, httpClient);
    }

    @Override
    public boolean isVersioningEnabled() throws StorageAdapterException {
        return this.isVersioningEnabled("/proc/?single=true");
    }

    @Override
    protected boolean getAdditionalMetadata(XMLStreamReader xmlr, FileMetadata metadata, String filePath) {
        String annotations = "";
        try {
            annotations = xmlr.getAttributeValue(null, "customMetadataAnnotations");
        }
        catch (NullPointerException e) {
            LOG.log(Level.WARNING, "Exception parsing metadata for: " + filePath, e);
        }
        return this.handleAdditionalMetadata(metadata, annotations, filePath) && super.getAdditionalMetadata(xmlr, metadata, filePath);
    }

    @Override
    protected boolean getAdditionalMetadata(HttpResponse response, FileMetadata metadata, String filePath) {
        String annotations = "";
        try {
            annotations = response.getFirstHeader("X-HCP-CustomMetadataAnnotations").getValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this.handleAdditionalMetadata(metadata, annotations, filePath) && super.getAdditionalMetadata(response, metadata, filePath);
    }

    private boolean handleAdditionalMetadata(FileMetadata metadata, String annotations, String filePath) {
        if (!annotations.isEmpty()) {
            Hashtable<String, CustomMetadata> aList = new Hashtable<String, CustomMetadata>();
            for (String a : annotations.split(", ")) {
                String[] tmp = a.split(";");
                aList.put(tmp[0], new CustomMetadata(StructuredMetadata.Form.PROFILED, filePath, null, tmp[0]));
            }
            metadata.setAnnotationList(aList);
        }
        return true;
    }

    @Override
    protected String buildCMQueryString(Long version, String annotation) {
        StringBuilder sb = new StringBuilder(super.buildCMQueryString(version, annotation));
        if (annotation != null) {
            sb.append("&annotation=" + annotation);
        }
        return sb.toString();
    }

    @Override
    protected String setAuthHeader(HCAPAdapter.HcapAdapterCookie cookie) {
        String username = "all_users";
        String password = "";
        if (!this.profile.isAnonymousAccess()) {
            username = Base64Utils.encode(this.profile.getUsername().getBytes());
            password = this.profile.getPassword();
        }
        String authString = "HCP " + username + ":" + password;
        cookie.getRequest().setHeader("Authorization", authString);
        return authString;
    }
}

