/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.adapter;

import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.impl.adapter.HCAPAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterLiteralException;
import com.archivas.clienttools.arcutils.impl.adapter.TestAdapterCallback;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.apache.http.NameValuePair;

public class TestHcapStorageAdapter
extends HCAPAdapter {
    private HCAPAdapter adapter;
    private TestAdapterCallback callback;

    public TestHcapStorageAdapter(HCAPAdapter adapter, TestAdapterCallback callback) {
        this.adapter = adapter;
        this.callback = callback;
    }

    @Override
    public SSLCertChain getSSLCerts() throws IOException, StorageAdapterException {
        return this.adapter.getSSLCerts();
    }

    @Override
    public void writeObjectFromStream(String targetNode, String targetPath, InputStream is, FileMetadata ingestionMetadata) throws StorageAdapterException {
        this.callback.writeStreamCalled(targetNode, targetPath, is, ingestionMetadata);
        this.adapter.writeObjectFromStream(targetNode, targetPath, is, ingestionMetadata);
    }

    @Override
    public void setMetadata(String host, String path, FileMetadata metadata) throws StorageAdapterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(String path, boolean isDirectory, DeleteJob.Operation operation, String reason) throws StorageAdapterException {
        this.callback.deleteCalled(path, isDirectory, operation, reason);
        this.adapter.delete(path, isDirectory, operation, reason, false);
    }

    @Override
    protected List<NameValuePair> handleDeleteOperation(DeleteJob.Operation operation, String reason) throws StorageAdapterLiteralException {
        return this.adapter.handleDeleteOperation(operation, reason);
    }

    @Override
    protected String getErrorHeader() {
        return this.adapter.getErrorHeader();
    }

    @Override
    public void close() {
        this.callback.closeCalled();
        this.adapter.close();
    }

    @Override
    public void cancel() {
        this.callback.cancelCalled();
        this.adapter.cancel();
    }

    @Override
    public InputStream getInputStream(String sourcePath, String query) throws StorageAdapterException {
        this.callback.getInputStreamCalled(sourcePath, query);
        return this.adapter.getInputStream(sourcePath, query);
    }

    @Override
    public FileMetadata getMetadata(String path, String queryString, FileType fileType, boolean isVersion) throws StorageAdapterException {
        this.callback.getMetadataCalled(path, queryString, fileType);
        return this.adapter.getMetadata(path, queryString, fileType, isVersion);
    }

    @Override
    public long getFileSize(ArcMoverFile file) throws StorageAdapterException {
        this.callback.getFileSizeCalled(file);
        return this.adapter.getFileSize(file);
    }

    @Override
    public InputStream getCustomMetadataStream(String path, Long version, FileType fileType) throws StorageAdapterException {
        return this.getCustomMetadataStream(path, version, fileType, null);
    }

    @Override
    public InputStream getCustomMetadataStream(String path, Long version, FileType fileType, String annotation) throws StorageAdapterException {
        this.callback.getCustomMetadataStreamCalled(path, fileType);
        return this.adapter.getCustomMetadataStream(path, version, fileType, annotation);
    }

    @Override
    public void setCustomMetadataStream(String file, InputStream metadata) throws StorageAdapterException {
        this.setCustomMetadataStream(file, metadata, null);
    }

    @Override
    public void setCustomMetadataStream(String file, InputStream metadata, String annotation) throws StorageAdapterException {
        this.callback.setCustomMetadataStreamCalled(file, metadata);
        this.adapter.setCustomMetadataStream(file, metadata, annotation);
    }

    @Override
    public void mkdir(String targetPath, FileMetadata metadata) throws StorageAdapterException {
        this.callback.mkdirCalled(targetPath, metadata);
        this.adapter.mkdir(targetPath, metadata);
    }

    @Override
    public void mkSymlink(String linkName, String targetName) throws StorageAdapterException {
        this.callback.mkSymlinkCalled(linkName, targetName);
        this.adapter.mkSymlink(linkName, targetName);
    }

    @Override
    public boolean exists(String path) throws StorageAdapterException {
        return this.adapter.exists(path);
    }

    @Override
    public void deleteCustomMetadata(String path) throws StorageAdapterException {
        this.adapter.deleteCustomMetadata(path);
    }

    @Override
    public ArcMoverFile createArcMoverFileObject(XMLStreamReader xmlr, ArcMoverDirectory caller) throws StorageAdapterException {
        return this.adapter.createArcMoverFileObject(xmlr, caller);
    }

    @Override
    public String getCustomMetadata(String path, Long version, FileType fileType) throws StorageAdapterException {
        return this.adapter.getCustomMetadata(path, version, fileType);
    }

    @Override
    public void setCustomMetadata(String file, String metadata) throws StorageAdapterException {
        this.adapter.setCustomMetadata(file, metadata);
    }

    @Override
    public AbstractProfileBase getProfile() {
        return this.adapter.getProfile();
    }

    @Override
    public void setProfile(AbstractProfileBase profile) {
        this.adapter.setProfile(profile);
    }

    @Override
    public void abortASAP() {
        this.adapter.abortASAP();
    }

    @Override
    protected void executeMethod(HCAPAdapter.HcapAdapterCookie cookie) throws IOException {
    }

    @Override
    public boolean copyDirMetadataWhenMigrating() {
        return this.adapter.copyDirMetadataWhenMigrating();
    }
}

