/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.jobs.CopyJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.jobs.CopySingleFileAction;
import com.archivas.clienttools.arcutils.impl.jobs.FileStats;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobFileAction;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobImpl;
import com.archivas.clienttools.arcutils.model.ACLMetadata;
import com.archivas.clienttools.arcutils.model.ArcCopyFile;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.model.CustomMetadata;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.ProfileType;
import com.archivas.clienttools.arcutils.utils.FileListParser;
import com.archivas.clienttools.arcutils.utils.FileUtil;
import com.archivas.clienttools.arcutils.utils.XMLValidator;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobSchema;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class CopyJobImpl
extends ManagedJobImpl {
    public CopyJobImpl(JobId jobId, CopyJob copyJob, ManagedJobSchema jobSchema) throws JobException {
        super(jobId, copyJob, jobSchema);
    }

    public CopyJob getCopyJob() {
        return (CopyJob)this.getJobSpec();
    }

    @Override
    protected ManagedJobFileAction getManagedJobFileAction(ManagedJob managedJob, StorageAdapter sourceAdapter, StorageAdapter targetAdapter) {
        return new CopySingleFileAction(this, (CopyJob)managedJob, sourceAdapter, targetAdapter);
    }

    @Override
    protected ManagedJobFileAction getPostProcessFileAction(ManagedJob managedJob, StorageAdapter sourceAdapter, StorageAdapter targetAdapter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void parseListFile() throws DatabaseException, IOException {
        File importFile = this.getJob().getListFile();
        if (importFile != null) {
            FileListParser.parseFile(importFile, this.getCopyJob(), this.db);
        }
    }

    @Override
    protected boolean includeInStats(FileStats fileStats) {
        return !fileStats.getArcProcssFile().getSourceArcMoverFile().isDirectory();
    }

    @Override
    protected boolean requiresFindFileSize() {
        return true;
    }

    @Override
    protected boolean requiresProcessingOfEmptyDirectories() {
        return true;
    }

    @Override
    protected boolean requiresPostProcessingOfDirectories() {
        return false;
    }

    @Override
    protected void doPostProcessing() throws JobException {
        throw new RuntimeException("Unsupported Operation");
    }

    @Override
    protected ArcProcessFile createArcProcessFileForDirectory(ArcProcessFile parent, ArcMoverFile moverFile) {
        ArcCopyFile parentCopyFile = (ArcCopyFile)parent;
        AbstractProfileBase sourceProfile = parentCopyFile.getSourceProfile();
        AbstractProfileBase targetProfile = parentCopyFile.getTargetProfile();
        String targetFilename = moverFile.getRelativePath(this.getJob().getSourcePath());
        if (sourceProfile.usesEncodedPaths() && !targetProfile.usesEncodedPaths()) {
            targetFilename = sourceProfile.decode(targetFilename);
        } else if (!sourceProfile.usesEncodedPaths() && targetProfile.usesEncodedPaths()) {
            targetFilename = targetProfile.encode(targetFilename);
        }
        String targetPath = FileUtil.resolvePath(this.getJob().getTargetPath(), targetFilename, targetProfile.getPathSeparator());
        ArcCopyFile ret = new ArcCopyFile(moverFile, targetProfile, targetPath, moverFile.getMetadata());
        ret.setParentDatabaseRecordId(parent.getDatabaseRecordId());
        return ret;
    }

    @Override
    protected ArcProcessFile createArcProcessFileForFile(ArcProcessFile processFile, ArcMoverFile moverFile, ManagedJob job) {
        ArcCopyFile copyFile = (ArcCopyFile)processFile;
        CopyJob copyJob = (CopyJob)job;
        return new ArcCopyFile(moverFile, copyJob.getTargetProfile(), copyFile.getTargetPath(), copyFile.getIngestionMetadata());
    }

    @Override
    public boolean validateJob() throws JobException {
        CopyJob copyJob = this.getCopyJob();
        CustomMetadata customMetadata = copyJob.getCustomMetadata();
        boolean valid = false;
        if (customMetadata == null || customMetadata.isEmptyStringForm() || !copyJob.getTargetProfile().isValidateCustomMetadata()) {
            valid = true;
        } else if (customMetadata.getValue() != null) {
            InputStream stream = customMetadata.getStream(copyJob.getSourceProfile(), null);
            if (stream == null) {
                throw new JobException("Could not read custom metadata.");
            }
            valid = XMLValidator.isValid(stream);
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!valid) {
            throw new JobException("Could not set Custom Metadata: Invalid XML.");
        }
        ACLMetadata aclMetadata = copyJob.getACL();
        valid = false;
        if (aclMetadata == null || aclMetadata.isEmptyStringForm()) {
            valid = true;
        } else if (aclMetadata.getValue() != null) {
            InputStream stream = aclMetadata.getStream(copyJob.getSourceProfile(), null);
            if (stream == null) {
                throw new JobException("Could not read ACL.");
            }
            valid = XMLValidator.isValid(stream);
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!valid) {
            throw new JobException("Could not set ACL: Invalid XML.");
        }
        if (copyJob.getSourceProfile().getType() == ProfileType.FILESYSTEM && copyJob.getTargetProfile().getType() == ProfileType.FILESYSTEM) {
            try {
                File sourceCanonicalFile = new File(copyJob.getSourcePath()).getCanonicalFile();
                File targetCanonicalFile = new File(copyJob.getTargetPath()).getCanonicalFile();
                if (sourceCanonicalFile.equals(targetCanonicalFile)) {
                    throw new JobException("For a copy within the local file system, the source and destination paths cannot identify the same directory.");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return valid;
    }

    @Override
    protected boolean treatAsSuccess(Integer statusCode) {
        return statusCode != null && statusCode == 409 && this.getCopyJob().ignoreConflicts();
    }

    @Override
    public boolean supportsConflictReports() {
        return true;
    }
}

