/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.jobs.CopyJob;
import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.config.ConfigurationHelper;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.adapter.FileSystemAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.Hcap2Adapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterLiteralException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterMgr;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterRetryException;
import com.archivas.clienttools.arcutils.impl.jobs.CopyJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.FileStats;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobFileAction;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobImpl;
import com.archivas.clienttools.arcutils.model.ACLMetadata;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.utils.FileUtil;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CopySingleFileAction
extends ManagedJobFileAction {
    public static Logger LOG = Logger.getLogger(CopySingleFileAction.class.getName());
    private CopyJobImpl jobImpl;
    final CopyJob mySpec;
    private StorageAdapter sourceAdapter = null;
    private StorageAdapter targetAdapter = null;
    protected static final Map<String, CreateDirWithCorrectPermsAction> createDirActionMap = new HashMap<String, CreateDirWithCorrectPermsAction>();

    public CopySingleFileAction(CopyJobImpl jobImpl, CopyJob mySpec, StorageAdapter sourceAdapter, StorageAdapter targetAdapter) {
        this.jobImpl = jobImpl;
        this.mySpec = mySpec;
        this.sourceAdapter = sourceAdapter;
        this.targetAdapter = targetAdapter;
    }

    public CopySingleFileAction(CopyJob mySpec) {
        this.mySpec = mySpec;
        this.sourceAdapter = StorageAdapterMgr.getStorageAdapter(mySpec.getSourceProfile());
        this.targetAdapter = StorageAdapterMgr.getStorageAdapter(mySpec.getTargetProfile());
    }

    @Override
    public void processFile(FileStats objToCopy) throws JobException {
        String sourcePath;
        objToCopy.setRetries(objToCopy.getRetries() + 1);
        LOG.log(Level.FINE, "About to copy: {0}", objToCopy.toDetailString());
        String sourceQueryString = null;
        boolean isVersion = false;
        ArcMoverFile origFile = objToCopy.getArcProcssFile().getSourceFile();
        if (origFile.isVersion() || origFile.getParent().isVersionList()) {
            sourcePath = origFile.getPath();
            sourceQueryString = origFile.getVersionString();
            isVersion = true;
        } else {
            sourcePath = objToCopy.getSourcePath();
        }
        boolean targetCopyDirMetadataWhenMigrating = this.targetAdapter.copyDirMetadataWhenMigrating();
        boolean sourceCopyDirMetadataWhenMigrating = this.sourceAdapter.copyDirMetadataWhenMigrating();
        String targetPath = objToCopy.getTargetPath();
        if (this.sourceAdapter instanceof FileSystemAdapter && this.targetAdapter instanceof FileSystemAdapter) {
            try {
                File sourceCanonicalFile = new File(sourcePath).getCanonicalFile();
                File targetCanonicalFile = new File(targetPath).getCanonicalFile();
                if (sourceCanonicalFile.equals(targetCanonicalFile)) {
                    throw new JobException("For a copy within the local file system, the source and destination paths cannot identify the same file.");
                }
            }
            catch (IOException sourceCanonicalFile) {
                // empty catch block
            }
        }
        int maxRetries = ConfigurationHelper.getIntegerProperty("managedJob.maxRetries", 3);
        InputStream sourceStream = null;
        FileMetadata resolvedMetadata = null;
        try {
            boolean done = false;
            int retries = 0;
            while (retries < maxRetries && !done) {
                ++retries;
                try {
                    FileMetadata sourceMD = origFile.getMetadata();
                    if (!origFile.isSymlink()) {
                        sourceMD = this.sourceAdapter.getMetadata(sourcePath, sourceQueryString, origFile.getFileType(), isVersion);
                    } else if (!this.sourceAdapter.getProfile().supportSymlinkRead()) {
                        throw new StorageAdapterLiteralException("Migration of symbolic links is not supported on the source");
                    }
                    resolvedMetadata = this.resolveMetadata(objToCopy.getTargetMetadata(), this.mySpec.getIngestionMetadata(), sourceMD);
                    boolean transferDirMetadata = HCPMoverProperties.TRANSFER_DIR_METADATA.getAsBoolean();
                    if (sourceCopyDirMetadataWhenMigrating && targetCopyDirMetadataWhenMigrating && transferDirMetadata) {
                        this.handleHCPDefaultDirPerms(sourcePath, targetPath, this.sourceAdapter, this.targetAdapter, resolvedMetadata);
                    }
                    if (origFile.isDirectory()) {
                        this.createEmptyDir(targetPath, this.targetAdapter, resolvedMetadata);
                        LOG.log(Level.FINE, "CopySingleFileAction done processing directory: " + targetPath);
                        break;
                    }
                    if (origFile.isSymlink()) {
                        this.targetAdapter.mkSymlink(targetPath, resolvedMetadata.getSymlinkTarget());
                        break;
                    }
                    sourceStream = this.sourceAdapter.getInputStream(sourcePath, sourceQueryString);
                    if (sourceStream == null) {
                        LOG.warning("Input stream returned for: " + sourcePath + " is null");
                        throw new StorageAdapterLiteralException("Input stream returned for: " + this.sourceAdapter.getProfile().decode(sourcePath) + " is null");
                    }
                    sourceStream = new ProgressInputStream(sourceStream, this.jobImpl);
                    this.targetAdapter.writeObjectFromStream(targetPath, sourceStream, resolvedMetadata);
                    try {
                        sourceStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    sourceStream = null;
                    this.sourceAdapter.close();
                    try {
                        if (resolvedMetadata != null && resolvedMetadata.hasCustomMetadata()) {
                            if (!this.targetAdapter.getProfile().supportsAnnotations() && (!resolvedMetadata.hasAnnotations() && !resolvedMetadata.getCustomMetadata().isEmptyStringForm() || resolvedMetadata.hasAnnotations() && resolvedMetadata.getAnnotationList().containsKey("default"))) {
                                CopySingleFileAction.handleCustomMetadata(resolvedMetadata, targetPath, this.sourceAdapter, this.targetAdapter, this.jobImpl);
                            } else if (this.targetAdapter.getProfile().supportsAnnotations()) {
                                if (resolvedMetadata.hasAnnotations()) {
                                    for (String annotation : resolvedMetadata.getAnnotationList().keySet()) {
                                        CopySingleFileAction.handleCustomMetadata(resolvedMetadata, targetPath, this.sourceAdapter, this.targetAdapter, this.jobImpl, annotation);
                                    }
                                } else {
                                    CopySingleFileAction.handleCustomMetadata(resolvedMetadata, targetPath, this.sourceAdapter, this.targetAdapter, this.jobImpl);
                                }
                            }
                        }
                        if (this.targetAdapter.getProfile().supportsACLs() && resolvedMetadata != null && resolvedMetadata.hasACL().booleanValue() && !resolvedMetadata.getACL().isEmptyStringForm()) {
                            CopySingleFileAction.handleACL(resolvedMetadata.getACL(), targetPath, this.sourceAdapter, this.targetAdapter, this.jobImpl);
                        }
                        if (targetCopyDirMetadataWhenMigrating && resolvedMetadata != null && resolvedMetadata.hasRetentionHold() && resolvedMetadata.isRetentionHold().booleanValue()) {
                            ((Hcap2Adapter)this.targetAdapter).setRetentionHoldToTrue(targetPath, resolvedMetadata.getFileType());
                        }
                    }
                    catch (StorageAdapterException e) {
                        LOG.log(Level.INFO, "Unexpected error writing custom metadata or setting retention hold", e);
                        try {
                            boolean isDirectory = objToCopy.getArcProcssFile().isDirectory();
                            StorageAdapter tempAdapter = StorageAdapterMgr.getStorageAdapter(this.mySpec.getTargetProfile());
                            tempAdapter.delete(targetPath, isDirectory, DeleteJob.Operation.DELETE, null);
                        }
                        catch (StorageAdapterRetryException e2) {
                            LOG.log(Level.INFO, "Failed to delete already copied object when preparing for retry.", e2);
                            throw new StorageAdapterLiteralException("Object failed adding custom metadata or setting retention hold.  Deleting the object while preparing for retry failed due to: " + e2.getMessage() + ".  Failing object because subsequent writes will fail.");
                        }
                        catch (StorageAdapterException e2) {
                            LOG.log(Level.INFO, "Failed to delete already copied object", e2);
                        }
                        throw e;
                    }
                    done = true;
                }
                catch (StorageAdapterRetryException e) {
                    if (retries >= maxRetries) {
                        throw new JobException(null, "Failed to read object after " + maxRetries + " retries.  Last retry failed due to: " + e.getMessage(), e);
                    }
                    LOG.log(Level.INFO, String.format("Error processing file %s, sleeping before retrying.  Msg: %s", sourcePath, e.getMessage()), e);
                    this.sourceAdapter.close();
                    this.targetAdapter.close();
                    this.waitForRetry(e.getRetryTime());
                }
                LOG.log(Level.FINE, "finished copying: {0}", objToCopy);
            }
        }
        catch (StorageAdapterException e) {
            JobException jobException = new JobException(null, e.getMessage(), e, e.getStatusCode());
            throw jobException;
        }
        finally {
            this.sourceAdapter.close();
            if (sourceStream != null) {
                try {
                    sourceStream.close();
                }
                catch (IOException iOException) {}
            }
            this.targetAdapter.close();
        }
    }

    protected static void handleCustomMetadata(FileMetadata resolvedMetadata, String targetPath, StorageAdapter sourceAdapter, StorageAdapter targetAdapter, ManagedJobImpl jobImpl) throws StorageAdapterException, JobException {
        CopySingleFileAction.handleCustomMetadata(resolvedMetadata, targetPath, sourceAdapter, targetAdapter, jobImpl, null);
    }

    protected static void handleCustomMetadata(FileMetadata resolvedMetadata, String targetPath, StorageAdapter sourceAdapter, StorageAdapter targetAdapter, ManagedJobImpl jobImpl, String annotation) throws StorageAdapterException, JobException {
        InputStream sourceStream = null;
        try {
            sourceStream = resolvedMetadata.getCustomMetadata(annotation).getStream(sourceAdapter == null ? null : sourceAdapter.getProfile(), sourceAdapter);
        }
        catch (JobException e) {
            Throwable rootCause = e.getCause();
            if (rootCause instanceof StorageAdapterException) {
                throw (StorageAdapterException)rootCause;
            }
            throw e;
        }
        if (sourceStream == null) {
            throw new StorageAdapterLiteralException("Could not get custom metadata from source");
        }
        sourceStream = new ProgressInputStream(sourceStream, jobImpl);
        targetAdapter.setCustomMetadataStream(targetPath, sourceStream, annotation);
        try {
            sourceStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sourceStream = null;
        if (sourceAdapter != null) {
            sourceAdapter.close();
        }
    }

    protected static void handleACL(ACLMetadata acl, String targetPath, StorageAdapter sourceAdapter, StorageAdapter targetAdapter, ManagedJobImpl jobImpl) throws StorageAdapterException, JobException {
        InputStream sourceStream = null;
        try {
            sourceStream = acl.getStream(sourceAdapter == null ? null : sourceAdapter.getProfile(), sourceAdapter);
        }
        catch (JobException e) {
            Throwable rootCause = e.getCause();
            if (rootCause instanceof StorageAdapterException) {
                throw (StorageAdapterException)rootCause;
            }
            throw e;
        }
        if (sourceStream == null) {
            throw new StorageAdapterLiteralException("Could not get aclA. from source");
        }
        sourceStream = new ProgressInputStream(sourceStream, jobImpl);
        targetAdapter.setACLFromStream(targetPath, sourceStream);
        try {
            sourceStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sourceStream = null;
        if (sourceAdapter != null) {
            sourceAdapter.close();
        }
    }

    private FileMetadata resolveMetadata(FileMetadata targetMD, FileMetadata jobMD, FileMetadata sourceMD) {
        if (targetMD == null) {
            targetMD = new FileMetadata();
            LOG.finest("No destination metadata.");
        }
        if (jobMD == null) {
            jobMD = new FileMetadata();
            LOG.finest("No job metadata.");
        }
        if (sourceMD == null) {
            sourceMD = new FileMetadata();
            LOG.finest("No source metadata.");
        }
        FileMetadata resolvedMD = new FileMetadata(sourceMD.getFileType());
        if (jobMD.hasFileMode()) {
            resolvedMD.setFileMode(jobMD.getFileMode());
        } else if (sourceMD.hasFileMode()) {
            resolvedMD.setFileMode(sourceMD.getFileMode());
        }
        if (jobMD.hasDirMode()) {
            resolvedMD.setDirMode(jobMD.getDirMode());
        } else if (sourceMD.hasDirMode()) {
            resolvedMD.setDirMode(sourceMD.getDirMode());
        }
        if (jobMD.hasUid()) {
            resolvedMD.setUid(jobMD.getUid());
        } else if (sourceMD.hasUid()) {
            resolvedMD.setUid(sourceMD.getUid());
        }
        if (jobMD.hasGid()) {
            resolvedMD.setGid(jobMD.getGid());
        } else if (sourceMD.hasGid()) {
            resolvedMD.setGid(sourceMD.getGid());
        }
        if (jobMD.hasNonDefaultRetention()) {
            resolvedMD.setRetention(jobMD.getRetention());
        } else if (sourceMD.hasNonDefaultRetention()) {
            resolvedMD.setRetention(sourceMD.getRetention());
        }
        if (jobMD.hasShred()) {
            resolvedMD.setShred(jobMD.isShred());
        } else if (sourceMD.hasShred()) {
            resolvedMD.setShred(sourceMD.isShred());
        }
        if (jobMD.hasSearchIndex()) {
            resolvedMD.setSearchIndex(jobMD.isSearchIndex());
        } else if (sourceMD.hasSearchIndex()) {
            resolvedMD.setSearchIndex(sourceMD.isSearchIndex());
        }
        if (jobMD.hasRetentionHold()) {
            resolvedMD.setRetentionHold(jobMD.isRetentionHold());
        } else if (sourceMD.hasRetentionHold()) {
            resolvedMD.setRetentionHold(sourceMD.isRetentionHold());
        }
        if (jobMD.hasCustomMetadata()) {
            resolvedMD.setCustomMetadata(jobMD.getCustomMetadata());
        } else if (sourceMD.hasCustomMetadata()) {
            resolvedMD.setCustomMetadata(sourceMD.getCustomMetadata());
        }
        if (jobMD.hasAnnotations()) {
            resolvedMD.setAnnotationList(jobMD.getAnnotationList());
        } else if (sourceMD.hasAnnotations()) {
            resolvedMD.setAnnotationList(sourceMD.getAnnotationList());
        }
        if (jobMD.hasOwner()) {
            resolvedMD.setOwner(jobMD.getOwner());
        } else if (sourceMD.hasOwner()) {
            resolvedMD.setOwner(sourceMD.getOwner());
        }
        if (jobMD.hasACL().booleanValue()) {
            resolvedMD.setACL(jobMD.getACL());
        } else if (sourceMD.hasACL().booleanValue()) {
            resolvedMD.setACL(sourceMD.getACL());
        }
        resolvedMD.setSymlinkTarget(sourceMD.getSymlinkTarget());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Destination Metadata          =" + targetMD);
            LOG.log(Level.FINEST, "Job Metadata          =" + jobMD);
            LOG.log(Level.FINEST, "Source File Metadata  =" + sourceMD);
            LOG.log(Level.FINEST, "Resolved File Metadata=" + resolvedMD);
        }
        return resolvedMD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHCPDefaultDirPerms(String sourcePath, String targetPath, StorageAdapter sourceAdapter, StorageAdapter targetAdapter, FileMetadata metadata) throws StorageAdapterException {
        if (sourceAdapter == null || targetAdapter == null) {
            return;
        }
        if (!sourceAdapter.copyDirMetadataWhenMigrating() || !targetAdapter.copyDirMetadataWhenMigrating()) {
            throw new RuntimeException("Call to CopySingleFileAction handleHCPDefaultDirPerms is not support adapter type: " + sourceAdapter.getClass());
        }
        if (!targetAdapter.copyDirMetadataWhenMigrating()) {
            throw new RuntimeException("Call to CopySingleFileAction handleHCPDefaultDirPerms is not support adapter type: " + targetAdapter.getClass());
        }
        String rootTargetDir = this.mySpec.getTargetPath();
        if (rootTargetDir == null || rootTargetDir.equals("")) {
            throw new RuntimeException("Call to CopySingleFileAction handleHCPDefaultDirPerms is expecting a target directory to be set in the CopyJobSpec");
        }
        if (!metadata.hasDirMode()) {
            Map<String, CreateDirWithCorrectPermsAction> map;
            if (!"/".equals(rootTargetDir)) {
                rootTargetDir = FileUtil.trimTrailingSlash(rootTargetDir);
            }
            int lastTargetIndex = targetPath.lastIndexOf("/");
            int lastSourceIndex = sourcePath.lastIndexOf("/");
            String currentTargetDirPath = targetPath.substring(0, lastTargetIndex);
            String currentSourceDirPath = sourcePath.substring(0, lastSourceIndex);
            boolean done = false;
            ArrayList<CreateDirWithCorrectPermsAction> actions = new ArrayList<CreateDirWithCorrectPermsAction>();
            while (!done && !currentTargetDirPath.equals(rootTargetDir)) {
                CreateDirWithCorrectPermsAction action = null;
                map = createDirActionMap;
                synchronized (map) {
                    action = createDirActionMap.get(currentTargetDirPath);
                }
                if (action == null && !targetAdapter.exists(currentTargetDirPath)) {
                    map = createDirActionMap;
                    synchronized (map) {
                        action = createDirActionMap.get(currentTargetDirPath);
                        if (action == null && !targetAdapter.exists(currentTargetDirPath)) {
                            action = new CreateDirWithCorrectPermsAction(currentTargetDirPath, currentSourceDirPath);
                            createDirActionMap.put(currentTargetDirPath, action);
                        }
                    }
                }
                if (action == null) {
                    done = true;
                    continue;
                }
                actions.add(action);
                lastTargetIndex = currentTargetDirPath.lastIndexOf("/");
                lastSourceIndex = currentSourceDirPath.lastIndexOf("/");
                if (lastTargetIndex == 0) {
                    done = true;
                    if (!rootTargetDir.equals("/")) {
                        throw new RuntimeException("Root target dir not /, unexpected case.");
                    }
                }
                if (lastTargetIndex > 0) {
                    currentTargetDirPath = currentTargetDirPath.substring(0, lastTargetIndex);
                }
                if (lastSourceIndex <= 0) continue;
                currentSourceDirPath = currentSourceDirPath.substring(0, lastSourceIndex);
            }
            for (int i = actions.size() - 1; i >= 0; --i) {
                ((CreateDirWithCorrectPermsAction)actions.get(i)).performAction(targetAdapter, sourceAdapter);
                map = createDirActionMap;
                synchronized (map) {
                    createDirActionMap.remove(((CreateDirWithCorrectPermsAction)actions.get(i)).getDestPath());
                    continue;
                }
            }
        }
    }

    private void createEmptyDir(String targetPath, StorageAdapter targetAdapter, FileMetadata metadata) throws StorageAdapterException {
        if (targetAdapter == null) {
            return;
        }
        LOG.log(Level.FINE, "CopySingleFileAction processing empty dir: " + targetPath);
        if (!targetAdapter.exists(targetPath)) {
            metadata.setFileMode(null);
            targetAdapter.mkdir(targetPath, metadata);
        }
    }

    protected class CreateDirWithCorrectPermsAction {
        private String destPath;
        private String sourcePath;
        private boolean performed = false;

        public CreateDirWithCorrectPermsAction(String destPath, String sourcePath) {
            this.destPath = destPath;
            this.sourcePath = sourcePath;
        }

        public synchronized void performAction(StorageAdapter targetAdapter, StorageAdapter sourceAdapter) throws StorageAdapterException {
            if (!this.performed) {
                FileMetadata sourceMetadata = sourceAdapter.getMetadata(this.sourcePath, null, FileType.DIRECTORY, false);
                targetAdapter.mkdir(this.destPath, sourceMetadata);
                this.performed = true;
            }
        }

        public String getDestPath() {
            return this.destPath;
        }
    }

    static class ProgressInputStream
    extends FilterInputStream {
        private ManagedJobImpl managedJobImpl;

        public ProgressInputStream(InputStream in, ManagedJobImpl managedJobImpl) {
            super(in);
            this.managedJobImpl = managedJobImpl;
        }

        @Override
        public int read() throws IOException {
            int ret = super.read();
            if (ret >= 0) {
                this.incrementByteCnt(1);
            }
            return ret;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.incrementByteCnt(super.read(b, off, len));
        }

        private int incrementByteCnt(int cnt) {
            if (cnt >= 0 && this.managedJobImpl != null) {
                this.managedJobImpl.incrementBytesTransferred(cnt);
            }
            return cnt;
        }
    }
}

