/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.JobStatus;
import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterMgr;
import com.archivas.clienttools.arcutils.impl.jobs.DeleteSingleFileAction;
import com.archivas.clienttools.arcutils.impl.jobs.FileStats;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobFileAction;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobImpl;
import com.archivas.clienttools.arcutils.model.ArcDeleteFile;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.utils.FileListParser;
import com.archivas.clienttools.arcutils.utils.database.CachedTableIterator;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobSchema;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeleteJobImpl
extends ManagedJobImpl {
    public static final String PACKAGE_NAME = DeleteJobImpl.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = DeleteJobImpl.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);

    public DeleteJobImpl(JobId jobId, DeleteJob deleteJob, ManagedJobSchema jobSchema) throws JobException {
        super(jobId, deleteJob, jobSchema);
    }

    public DeleteJob getDeleteJob() {
        return (DeleteJob)this.getJob();
    }

    @Override
    protected ManagedJobFileAction getManagedJobFileAction(ManagedJob managedJob, StorageAdapter sourceAdapter, StorageAdapter unused) {
        return new DeleteSingleFileAction((DeleteJob)managedJob, sourceAdapter);
    }

    @Override
    protected ManagedJobFileAction getPostProcessFileAction(ManagedJob managedJob, StorageAdapter sourceAdapter, StorageAdapter targetAdapter) {
        return new DeleteSingleFileAction((DeleteJob)managedJob, sourceAdapter);
    }

    @Override
    protected boolean requiresFindFileSize() {
        return false;
    }

    @Override
    protected boolean requiresProcessingOfEmptyDirectories() {
        return false;
    }

    @Override
    protected boolean requiresPostProcessingOfDirectories() {
        return true;
    }

    @Override
    protected void doPostProcessing() throws JobException {
        try {
            int maxPathDepth = this.db.getMaxPathDepth();
            if (maxPathDepth <= 0) {
                this.doSingleThreadedPostProcessing();
            } else {
                this.doMultiThreadedPostProcessing(maxPathDepth);
            }
        }
        catch (DatabaseException e) {
            throw new JobException(this.getJobId(), e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new JobException(this.getJobId(), e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMultiThreadedPostProcessing(int maxPathDepth) throws DatabaseException, SQLException, JobException {
        for (int pathDepth = maxPathDepth; pathDepth > 0; --pathDepth) {
            this.processFilesIterator = this.db.getPostProcessPathDepthFileIterator(pathDepth);
            this.refreshThreadLoad(true);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ManagedJobImpl.ProcessFileThread processFileThread = null;
            List list = this.fileProcessorWorkers;
            synchronized (list) {
                if (!this.fileProcessorWorkers.isEmpty()) {
                    processFileThread = (ManagedJobImpl.ProcessFileThread)this.fileProcessorWorkers.get(0);
                }
            }
            while (processFileThread != null) {
                this.joinThread(processFileThread);
                list = this.fileProcessorWorkers;
                synchronized (list) {
                    this.fileProcessorWorkers.remove(processFileThread);
                    processFileThread = null;
                    if (!this.fileProcessorWorkers.isEmpty()) {
                        processFileThread = (ManagedJobImpl.ProcessFileThread)this.fileProcessorWorkers.get(0);
                    }
                }
            }
            this.flushInMemoryCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSingleThreadedPostProcessing() throws JobException {
        ManagedJobFileAction fileAction;
        StorageAdapter sourceAdapter = StorageAdapterMgr.getStorageAdapter(this.getJob().getSourceProfile(), this.sourceHttpClient);
        StorageAdapter targetAdapter = null;
        if (this.getJob().getTargetProfile() != null) {
            targetAdapter = StorageAdapterMgr.getStorageAdapter(this.getJob().getTargetProfile(), this.targetHttpClient);
        }
        this.currentPostProcessAction = fileAction = this.getPostProcessFileAction(this.getJob(), sourceAdapter, targetAdapter);
        try {
            THREADLOG.log(Level.INFO, "Started post processing: {0}", this);
            CachedTableIterator<FileStats> itr = this.db.getPostProcessReverseOrderFileIterator();
            FileStats stats = itr.next();
            while (stats != null) {
                stats.markStartTime();
                Exception exception = null;
                try {
                    if (this.includeInStats(stats)) {
                        Object object = this.statsLock;
                        synchronized (object) {
                            this.objectsProcessing.add(stats);
                        }
                    }
                    if (!this.killJob) {
                        fileAction.processFile(stats);
                    }
                }
                catch (Exception e) {
                    exception = e;
                }
                finally {
                    if (this.includeInStats(stats)) {
                        Object e = this.statsLock;
                        synchronized (e) {
                            this.objectsProcessing.remove(stats);
                        }
                    }
                }
                if (exception == null) {
                    this.completeObject(stats, null);
                } else {
                    this.failObject(stats, exception, null, false, true);
                }
                if (this.killJob) {
                    THREADLOG.log(Level.WARNING, "PostProcessing asked to stop. It has finished its current work so we are letting it exit.");
                    break;
                }
                stats = itr.next();
            }
            THREADLOG.log(Level.INFO, "PostProcessing exiting");
        }
        catch (Throwable t) {
            String msg = "Unexpected exception received. Msg: " + t.getMessage();
            THREADLOG.log(Level.SEVERE, msg, t);
            try {
                this.stopJob(JobStatus.FAILED, true, false);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to stop job", e);
            }
            this.setJobException(t);
        }
        finally {
            this.currentPostProcessAction = null;
        }
    }

    @Override
    protected ArcProcessFile createArcProcessFileForDirectory(ArcProcessFile parentDir, ArcMoverFile moverFile) {
        ArcDeleteFile ret = new ArcDeleteFile(moverFile);
        ret.setParentDatabaseRecordId(parentDir.getDatabaseRecordId());
        return ret;
    }

    @Override
    protected ArcProcessFile createArcProcessFileForFile(ArcProcessFile processFile, ArcMoverFile moverFile, ManagedJob job) {
        return new ArcDeleteFile(moverFile);
    }

    @Override
    public void parseListFile() throws DatabaseException, IOException {
        File importFile = this.getJob().getListFile();
        if (importFile != null) {
            FileListParser.parseFile(importFile, this.getDeleteJob(), this.db);
        }
    }

    @Override
    protected boolean includeInStats(FileStats fileStats) {
        return true;
    }

    @Override
    protected boolean treatAsSuccess(Integer statusCode) {
        return false;
    }

    @Override
    public boolean supportsConflictReports() {
        return false;
    }
}

