/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.config.ConfigurationHelper;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterMgr;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterRetryException;
import com.archivas.clienttools.arcutils.impl.jobs.FileStats;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobFileAction;
import java.util.logging.Logger;
import org.apache.http.impl.client.AbstractHttpClient;

public class DeleteSingleFileAction
extends ManagedJobFileAction {
    public static Logger LOG = Logger.getLogger(DeleteSingleFileAction.class.getName());
    private StorageAdapter sourceAdapter;
    private DeleteJob deleteJob;

    public DeleteSingleFileAction(DeleteJob deleteJob, StorageAdapter sourceAdapter) {
        this.deleteJob = deleteJob;
        this.sourceAdapter = sourceAdapter;
    }

    public DeleteSingleFileAction(DeleteJob deleteJob, AbstractHttpClient httpClient) {
        this.deleteJob = deleteJob;
        this.sourceAdapter = StorageAdapterMgr.getStorageAdapter(deleteJob.getSourceProfile(), httpClient);
    }

    @Override
    public void processFile(FileStats objToDelete) throws JobException {
        this.deleteFile(objToDelete);
    }

    private void deleteFile(FileStats fileToDelete) throws JobException {
        int maxRetries = ConfigurationHelper.getIntegerProperty("managedJob.maxRetries", 3);
        String sourcePath = fileToDelete.getSourcePath();
        int retries = 0;
        boolean done = false;
        while (retries < maxRetries && !done) {
            ++retries;
            try {
                boolean isDirectory = fileToDelete.getArcProcssFile().isDirectory();
                this.sourceAdapter.delete(sourcePath, isDirectory, this.deleteJob.getOperation(), this.deleteJob.getReason());
                done = true;
            }
            catch (StorageAdapterRetryException e) {
                if (retries >= maxRetries) {
                    throw new JobException(null, "Failed to delete object after " + maxRetries, e);
                }
                this.waitForRetry(e.getRetryTime());
            }
            catch (StorageAdapterException e) {
                JobException jobException = new JobException(null, e.getMessage(), e);
                throw jobException;
            }
            finally {
                this.sourceAdapter.close();
            }
        }
    }
}

