/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.jobs.DirectoryListingJob;
import com.archivas.clienttools.arcutils.api.jobs.JobSpec;
import com.archivas.clienttools.arcutils.impl.JobImpl;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectoryListingJobImpl
extends JobImpl {
    public static final String PACKAGE_NAME = DirectoryListingJobImpl.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = DirectoryListingJobImpl.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    ArcMoverDirectory dir = null;

    public DirectoryListingJobImpl(JobId jobId, JobSpec jobSpec) {
        super(jobId, jobSpec);
    }

    protected DirectoryListingJob getJob() {
        return (DirectoryListingJob)this.getJobSpec();
    }

    protected String addTrailingSlash(String path) {
        if (path != null && path.indexOf(63) == -1 && !path.trim().endsWith("/")) {
            path = path.trim() + "/";
        }
        return path;
    }

    @Override
    protected void runJob() throws JobException {
        DirectoryListingJob mySpec = this.getJob();
        this.setStartTime(new Date());
        String path = null;
        StorageAdapter adapter = mySpec.getAdapter();
        boolean forceCollectionOfMetadata = true;
        try {
            path = mySpec.getPath();
            forceCollectionOfMetadata = mySpec.forceCollectionOfMetadata();
            if (path == null) {
                throw new IllegalArgumentException("Can not get directory listing for a null url");
            }
            this.dir = adapter.getDirectory(path, forceCollectionOfMetadata);
            if (this.dir != null && LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, this.dir.toDetailString());
            }
        }
        catch (StorageAdapterException e) {
            JobException jobException = new JobException(this.getJobId(), e.getMessage(), e);
            this.setJobException(jobException);
            throw jobException;
        }
        catch (Exception e) {
            JobException jobException = new JobException(this.getJobId(), (Throwable)e);
            this.setJobException(jobException);
            throw jobException;
        }
    }

    @Override
    public Object getResult() {
        return this.dir;
    }
}

