/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.jobs.ProgressLogger;

public class FailureProgressLogger
extends ProgressLogger {
    private static FailureProgressLogger instance = null;

    private FailureProgressLogger() {
        super("_failure%g.log");
        switch (HCPMoverProperties.LOGGING_FAILURE_MODE.getAsTriState()) {
            case YES: {
                this.setLogAll(true);
                break;
            }
            case NO: {
                this.disableLogging();
                break;
            }
            default: {
                this.setLogIntervalSeconds(HCPMoverProperties.LOGGING_FAILURE_PERIOD.getAsInt());
            }
        }
    }

    public static synchronized FailureProgressLogger getInstance() {
        if (instance == null) {
            instance = new FailureProgressLogger();
        }
        return instance;
    }

    @Override
    public void log(String path, String failureMsg, long count, ManagedJob.Type jobType) {
        super.log(path, failureMsg, count, jobType);
    }

    @Override
    protected String getCountMsgPrefix(ManagedJob.Type jobType) {
        String msgPrefix;
        switch (jobType) {
            case COPY: {
                msgPrefix = "Failed to copy ";
                break;
            }
            case DELETE: {
                msgPrefix = "Failed to delete ";
                break;
            }
            case SET_METADATA: {
                msgPrefix = "Failed to set metadata ";
                break;
            }
            default: {
                throw new RuntimeException("Unsupported job type: " + (Object)((Object)jobType));
            }
        }
        return msgPrefix;
    }
}

