/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.impl.jobs.FileStatus;
import com.archivas.clienttools.arcutils.model.ArcCopyFile;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import java.util.Date;

public class FileStats
implements Comparable<FileStats> {
    private ArcProcessFile file;
    private FileStatus status = FileStatus.NONE;
    private Integer statusCode;
    private int retries = -1;
    private Throwable exception = null;
    private Date startTime;
    private Date endTime;
    private long runTimeMs;
    private boolean failedDuringFind;
    private boolean includeInCounts = true;

    public FileStats(ArcProcessFile file) {
        this.file = file;
    }

    public ArcProcessFile getArcProcssFile() {
        return this.file;
    }

    public AbstractProfileBase getSourceProfile() {
        return this.file.getSourceProfile();
    }

    public FileStatus getStatus() {
        return this.status;
    }

    public void setStatus(FileStatus status) {
        this.status = status;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public boolean failedDuringFind() {
        return this.failedDuringFind;
    }

    public void setFailedDuringFind(boolean val) {
        this.failedDuringFind = val;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void markStartTime() {
        this.setStartTime(new Date());
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
        Date startTime = this.getStartTime();
        if (startTime != null && endTime != null) {
            this.setRunTimeMs(endTime.getTime() - startTime.getTime());
        }
    }

    public void markEndTime() {
        this.setEndTime(new Date());
    }

    public long getRunTimeMs() {
        return this.runTimeMs;
    }

    public void setRunTimeMs(long runTimeMs) {
        this.runTimeMs = runTimeMs;
    }

    public String getSourcePath() {
        return this.file.getSourcePath();
    }

    public String getSymlinkTarget() {
        return this.file.getSymlinkTarget();
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public long getSize() {
        return this.file.getSize();
    }

    public boolean includeInStats() {
        return this.includeInCounts;
    }

    public void setIncludeInStats(boolean val) {
        this.includeInCounts = val;
    }

    public long getDatabaseRecordId() {
        return this.file.getDatabaseRecordId();
    }

    public long getThroughput() {
        long time = this.getRunTimeMs();
        long size = this.file.getSourceFile().getSize();
        if (time < 1L || size < 1L) {
            return 0L;
        }
        time = Math.max(time / 1000L, 1L);
        return (size /= 1024L) / time;
    }

    public String getTargetPath() {
        String ret = null;
        if (this.file instanceof ArcCopyFile) {
            ret = ((ArcCopyFile)this.file).getTargetPath();
        }
        return ret;
    }

    public FileMetadata getTargetMetadata() {
        FileMetadata ret = null;
        if (this.file instanceof ArcCopyFile) {
            ret = ((ArcCopyFile)this.file).getIngestionMetadata();
        }
        return ret;
    }

    public String getDisplayUriRelativeToBasePath() {
        String ret = this.file instanceof ArcCopyFile ? ((ArcCopyFile)this.file).getDisplayTargetPath() : this.file.getDisplaySourcePath();
        return ret;
    }

    @Override
    public int compareTo(FileStats that) {
        return this.file.compareTo(that.file);
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && other instanceof FileStats) {
            FileStats that = (FileStats)other;
            if (this.file == null) {
                return that.file == null;
            }
            return this.file.equals(that.file);
        }
        return result;
    }

    public int hashCode() {
        return this.file != null ? this.file.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FileStats");
        sb.append("{status=").append((Object)this.status);
        if (this.retries > 0) {
            sb.append(", retries=").append(this.retries);
        }
        sb.append(", startTime=").append(this.startTime);
        sb.append(", throughput=").append(this.getThroughput());
        if (this.exception != null) {
            sb.append(", exception=").append(this.exception);
        }
        sb.append('}');
        return sb.toString();
    }

    public String toDetailString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FileStats");
        sb.append("{file=").append(this.file == null ? "null" : this.file.getSourcePath());
        sb.append(", status=").append((Object)this.status);
        sb.append(", retries=").append(this.retries);
        sb.append(", exception=").append(this.exception);
        sb.append(", startTime=").append(this.startTime);
        sb.append(", endTime=").append(this.endTime);
        sb.append(", runTimeMs=").append(this.runTimeMs);
        sb.append(", throughput=").append(this.getThroughput());
        sb.append('}');
        return sb.toString();
    }
}

