/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.jobs.GetCustomMetadataJob;
import com.archivas.clienttools.arcutils.api.jobs.JobSpec;
import com.archivas.clienttools.arcutils.impl.JobImpl;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterMgr;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetCustomMetadataJobImpl
extends JobImpl {
    public static final String PACKAGE_NAME = GetCustomMetadataJobImpl.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = GetCustomMetadataJobImpl.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    String metadata = null;

    public GetCustomMetadataJobImpl(JobId jobId, JobSpec jobSpec) {
        super(jobId, jobSpec);
    }

    protected GetCustomMetadataJob getJob() {
        return (GetCustomMetadataJob)this.getJobSpec();
    }

    protected AbstractProfileBase getProfile() {
        return ((GetCustomMetadataJob)this.getJobSpec()).getProfile();
    }

    @Override
    protected void runJob() throws JobException {
        GetCustomMetadataJob mySpec = this.getJob();
        this.setStartTime(new Date());
        LOG.log(Level.FINE, "{0}.runJob: {1}", new Object[]{CLASS_NAME, this});
        this.setStartTime(new Date());
        try {
            String path = mySpec.getPath();
            Long version = mySpec.getVersion();
            StorageAdapter adapter = StorageAdapterMgr.getStorageAdapter(mySpec.getProfile());
            this.metadata = adapter.getCustomMetadata(path, version, mySpec.getFileType());
        }
        catch (StorageAdapterException e) {
            JobException jobException = new JobException(this.getJobId(), e.getMessage(), e);
            this.setJobException(jobException);
            throw jobException;
        }
        catch (Exception e) {
            JobException jobException = new JobException(this.getJobId(), (Throwable)e);
            this.setJobException(jobException);
            throw jobException;
        }
    }

    @Override
    public Object getResult() {
        return this.metadata;
    }
}

