/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.jobs.GetCustomMetadataStreamJob;
import com.archivas.clienttools.arcutils.api.jobs.JobSpec;
import com.archivas.clienttools.arcutils.impl.JobImpl;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import java.io.InputStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetCustomMetadataStreamJobImpl
extends JobImpl {
    public static final String PACKAGE_NAME = GetCustomMetadataStreamJobImpl.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = GetCustomMetadataStreamJobImpl.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    InputStream metadataStream = null;

    public GetCustomMetadataStreamJobImpl(JobId jobId, JobSpec jobSpec) {
        super(jobId, jobSpec);
    }

    protected GetCustomMetadataStreamJob getJob() {
        return (GetCustomMetadataStreamJob)this.getJobSpec();
    }

    @Override
    protected void runJob() throws JobException {
        GetCustomMetadataStreamJob mySpec = this.getJob();
        this.setStartTime(new Date());
        LOG.log(Level.FINE, "{0}.runJob: {1}", new Object[]{CLASS_NAME, this});
        this.setStartTime(new Date());
        try {
            String path = mySpec.getPath();
            Long version = mySpec.getVersion();
            String annotation = mySpec.getAnnotation();
            this.metadataStream = mySpec.getAdapter().getCustomMetadataStream(path, version, mySpec.getFileType(), annotation);
        }
        catch (StorageAdapterException e) {
            JobException jobException = new JobException(this.getJobId(), e.getMessage(), e);
            this.setJobException(jobException);
            throw jobException;
        }
        catch (Exception e) {
            JobException jobException = new JobException(this.getJobId(), (Throwable)e);
            this.setJobException(jobException);
            throw jobException;
        }
    }

    @Override
    public Object getResult() {
        return this.metadataStream;
    }
}

