/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.impl.jobs.FileStats;

public abstract class ManagedJobFileAction {
    private boolean cancelled = false;

    public abstract void processFile(FileStats var1) throws JobException;

    public synchronized void cancel() {
        this.cancelled = true;
        this.notifyAll();
    }

    protected synchronized void waitForRetry(int retryTime) throws JobException {
        long startTime = System.currentTimeMillis();
        long curTime = System.currentTimeMillis();
        while (curTime - startTime < (long)retryTime && !this.cancelled) {
            try {
                this.wait((long)retryTime - (curTime - startTime));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            curTime = System.currentTimeMillis();
        }
        if (this.cancelled) {
            throw new JobException("Object cancelled while waiting to retry.");
        }
    }
}

