/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import com.archivas.clienttools.arcutils.api.ArcMoverFactory;
import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.JobStats;
import com.archivas.clienttools.arcutils.api.JobStatus;
import com.archivas.clienttools.arcutils.api.ManagedJobStats;
import com.archivas.clienttools.arcutils.api.jobs.JobSpec;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.config.ConfigurationHelper;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.JobImpl;
import com.archivas.clienttools.arcutils.impl.adapter.BadElementException;
import com.archivas.clienttools.arcutils.impl.adapter.DirectoryListingXmlException;
import com.archivas.clienttools.arcutils.impl.adapter.HCAPAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterLiteralException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterMgr;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterRetryException;
import com.archivas.clienttools.arcutils.impl.jobs.FailureProgressLogger;
import com.archivas.clienttools.arcutils.impl.jobs.FileStats;
import com.archivas.clienttools.arcutils.impl.jobs.FileStatus;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobFileAction;
import com.archivas.clienttools.arcutils.impl.jobs.SuccessProgressLogger;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.model.LoadSchedule;
import com.archivas.clienttools.arcutils.utils.database.CachedTableIterator;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobSchema;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobsSchema;
import com.archivas.clienttools.arcutils.utils.database.ResetJobTableIterator;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.AbstractHttpClient;

public abstract class ManagedJobImpl
extends JobImpl {
    public static final String COPY_LIST_SUFFIX = "JobList.txt";
    public static final String FAILURES_SUFFIX = "Failures.txt";
    public static final String SUCCESSES_SUFFIX = "Successes.txt";
    public static final String CONFLICTS_SUFFIX = "Conflicts.txt";
    protected static Logger LOG = Logger.getLogger(ManagedJobImpl.class.getName());
    protected static Logger THREADLOG = Logger.getLogger(ManagedJobImpl.class.getName() + ".threadLog");
    private static final long CHECKPOINT_TIME = HCPMoverProperties.CHECKPOINT_FREQUENCY_MILLIS.getAsLong();
    private static final int CHECKPOINT_SIZE = HCPMoverProperties.CHECKPOINT_FREQUENCY_FILES.getAsInt();
    private static boolean shutdownHookObserved = false;
    private static final Comparator<FileStats> FILE_STATS_DB_ID_COMPARATOR = new Comparator<FileStats>(){

        @Override
        public int compare(FileStats o1, FileStats o2) {
            long id2;
            long id1 = o1.getDatabaseRecordId();
            if (id1 < (id2 = o2.getDatabaseRecordId())) {
                return -1;
            }
            if (id1 > id2) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    };
    private final Object findLock = new Object();
    private final Object processLock = new Object();
    private SuccessProgressLogger successProgressLogger = SuccessProgressLogger.getInstance();
    private FailureProgressLogger failureProgressLogger = FailureProgressLogger.getInstance();
    private boolean findFilesComplete = false;
    private static final int MAX_DISPLAY_LIST_SIZE = 1000;
    private final List<FileStats> objectsCompleted = new LinkedList<FileStats>();
    private final List<FileStats> objectsErrored = new LinkedList<FileStats>();
    protected final Set<FileStats> objectsProcessing = new HashSet<FileStats>();
    private long lastFilesReadyToFindFlushTime;
    private List<ArcProcessFile> filesReadyToFind = new ArrayList<ArcProcessFile>();
    private List<ArcProcessFile> filesReadyToProcess = new ArrayList<ArcProcessFile>();
    private Set<FileStats> objectsProcessed = new TreeSet<FileStats>(FILE_STATS_DB_ID_COMPARATOR);
    private Date findStartTime;
    private Date findEndTime;
    private int maxThreads = 1;
    private int maxFindThreads = 1;
    private int findThreadsCap = 1;
    private int maxProcessingThreads = 1;
    private volatile long lastThreadRefreshMS = -1L;
    private final Object dnsRefreshLock = new Object();
    private int totalNumberOfProcessingThreads = 0;
    private int numberOfFindThreadsWaiting = 0;
    private boolean possiblyMoreToFind = true;
    boolean inLowLoadTimeWindow = false;
    AbstractHttpClient sourceHttpClient = null;
    AbstractHttpClient targetHttpClient = null;
    private ThreadGroup jobThreadGroup = new ThreadGroup("ManagedJob_" + this.getJobId());
    private final List<FindFilesThread> findWorkers = Collections.synchronizedList(new ArrayList());
    protected final List<ProcessFileThread> fileProcessorWorkers = Collections.synchronizedList(new ArrayList(this.maxThreads));
    private boolean endOfJobReached = false;
    private final Object endOfJobLock = new Object();
    protected volatile boolean killJob = false;
    protected ManagedJobSchema db;
    private CachedTableIterator<ArcProcessFile> findFilesIterator;
    protected CachedTableIterator<FileStats> processFilesIterator;
    private long previousRunTime;
    private long totalObjCnt;
    private long totalObjSize;
    private long successObjCnt;
    private long successObjSize;
    private long failObjCnt;
    private long failDirCnt;
    private long failObjSize;
    private long discoveredObjCnt;
    protected final Object statsLock = new Object();
    private LinkedList<ManagedJobStats> recentJobStats = new LinkedList();
    private volatile long bytesTransferred;
    private boolean sourceSupportsVersioning;
    protected volatile ManagedJobFileAction currentPostProcessAction = null;
    private Set<String> partialDirListings;

    public ManagedJobImpl(JobId jobId, JobSpec jobSpec, ManagedJobSchema db) throws JobException {
        super(jobId, jobSpec);
        this.db = db;
        this.findThreadsCap = HCPMoverProperties.FIND_FILES_THREADS.getAsInt();
        try {
            this.findFilesIterator = db.getFindFileIterator();
            this.processFilesIterator = db.getProcessFileIterator();
        }
        catch (SQLException sqle) {
            throw new JobException("Could not initialize database iterators", (Throwable)sqle);
        }
    }

    public ManagedJobSchema getManagedJobSchema() {
        return this.db;
    }

    public ManagedJob getJob() {
        return (ManagedJob)this.getJobSpec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isFindFilesComplete() {
        Object object = this.processLock;
        synchronized (object) {
            return this.findFilesComplete;
        }
    }

    private Date getFindStartTime() {
        return this.findStartTime;
    }

    private void setFindStartTime(Date findStartTime) {
        this.findStartTime = findStartTime;
    }

    private Date getFindEndTime() {
        return this.findEndTime;
    }

    private void setFindEndTime(Date findEndTime) {
        this.findEndTime = findEndTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRunTimeMs() {
        Object object = this.statsLock;
        synchronized (object) {
            Date startTime = this.getStartTime();
            Date endTime = this.getEndTime();
            long ret = startTime != null && endTime == null ? this.previousRunTime + (System.currentTimeMillis() - this.getStartTime().getTime()) : this.previousRunTime;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousRunTime(long runTimeMs) {
        Object object = this.statsLock;
        synchronized (object) {
            this.previousRunTime = runTimeMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalObjectCount() {
        Object object = this.statsLock;
        synchronized (object) {
            return this.totalObjCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTotalObjectCount(long cnt) {
        Object object = this.statsLock;
        synchronized (object) {
            this.totalObjCnt = cnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementTotalObjectCount() {
        Object object = this.statsLock;
        synchronized (object) {
            ++this.totalObjCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalBytes() {
        Object object = this.statsLock;
        synchronized (object) {
            return this.totalObjSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTotalBytes(long bytes) {
        Object object = this.statsLock;
        synchronized (object) {
            this.totalObjSize = bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToTotalBytes(long bytesToAdd) {
        Object object = this.statsLock;
        synchronized (object) {
            this.totalObjSize += bytesToAdd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompletedObjectCount() {
        Object object = this.statsLock;
        synchronized (object) {
            return this.successObjCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompletedObjectCount(long completedObjects) {
        Object object = this.statsLock;
        synchronized (object) {
            this.successObjCnt = completedObjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementCompletedObjectCount() {
        Object object = this.statsLock;
        synchronized (object) {
            ++this.successObjCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCompletedBytes() {
        Object object = this.statsLock;
        synchronized (object) {
            return this.successObjSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompletedBytes(long completedBytes) {
        Object object = this.statsLock;
        synchronized (object) {
            this.successObjSize = completedBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCompletedBytes(long completedBytes) {
        Object object = this.statsLock;
        synchronized (object) {
            this.successObjSize += completedBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFailedObjectCount() {
        Object object = this.statsLock;
        synchronized (object) {
            return this.failObjCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailedObjectCount(long cnt) {
        Object object = this.statsLock;
        synchronized (object) {
            this.failObjCnt = cnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementFailedObjectCount() {
        Object object = this.statsLock;
        synchronized (object) {
            ++this.failObjCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFailedDirCount() {
        Object object = this.statsLock;
        synchronized (object) {
            return this.failDirCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailedDirCount(long cnt) {
        Object object = this.statsLock;
        synchronized (object) {
            this.failDirCnt = cnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementFailedDirCount() {
        Object object = this.statsLock;
        synchronized (object) {
            ++this.failDirCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getFailedBytes() {
        Object object = this.statsLock;
        synchronized (object) {
            return this.failObjSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailedBytes(long cnt) {
        Object object = this.statsLock;
        synchronized (object) {
            this.failObjSize = cnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFailedBytes(long cnt) {
        Object object = this.statsLock;
        synchronized (object) {
            this.failObjSize += cnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDiscoveredObjectCount() {
        Object object = this.statsLock;
        synchronized (object) {
            return this.discoveredObjCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscoveredObjectCount(long cnt) {
        Object object = this.statsLock;
        synchronized (object) {
            this.discoveredObjCnt = cnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementDiscoveredObjectCount() {
        Object object = this.statsLock;
        synchronized (object) {
            ++this.discoveredObjCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getAverageThroughput() {
        Object object = this.statsLock;
        synchronized (object) {
            long time = this.getRunTimeMs();
            long size = this.getCompletedBytes();
            if (time < 1L || size < 1L) {
                return 0L;
            }
            time = Math.max(time / 1000L, 1L);
            return (size /= 1024L) / time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getCurrentThroughputBytes() {
        Object object = this.statsLock;
        synchronized (object) {
            if (this.recentJobStats.size() > 1) {
                ManagedJobStats oldest = this.recentJobStats.getFirst();
                ManagedJobStats newest = this.recentJobStats.getLast();
                double bytesTransferred = newest.getTransferredBytes() - oldest.getTransferredBytes();
                double elapsedTime = newest.getStatsTime() - oldest.getStatsTime();
                if (elapsedTime > 0.0) {
                    double bytesPerMs = bytesTransferred / elapsedTime;
                    return bytesPerMs * 1000.0;
                }
                return 0.0;
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getCurrentThroughputCnt() {
        Object object = this.statsLock;
        synchronized (object) {
            if (this.recentJobStats.size() > 1) {
                ManagedJobStats oldest = this.recentJobStats.getFirst();
                ManagedJobStats newest = this.recentJobStats.getLast();
                double cntCompleted = newest.getCompletedObjectCount() - oldest.getCompletedObjectCount();
                double elapsedTime = newest.getStatsTime() - oldest.getStatsTime();
                if (elapsedTime > 0.0) {
                    double objectsPerMs = cntCompleted / elapsedTime;
                    return objectsPerMs * 1000.0;
                }
                return 0.0;
            }
            return 0.0;
        }
    }

    public void incrementBytesTransferred(int cnt) {
        if (cnt > 0) {
            this.bytesTransferred += (long)cnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ManagedJobStats generateJobStats() {
        ManagedJobStats stats;
        long bytesTransferred = this.bytesTransferred;
        JobStatus status = this.getStatus();
        Object object = this.statsLock;
        synchronized (object) {
            stats = new ManagedJobStats(this.getJobId(), status, this.getEstimatedTimeLeftMs(), this.getStartTime(), this.getEndTime(), this.getRunTimeMs(), this.getJobException(), this.isFindFilesComplete(), this.getDiscoveredObjectCount(), this.getTotalObjectCount(), this.getCompletedObjectCount(), this.getFailedObjectCount(), this.getFailedDirCount(), this.getTotalBytes(), this.getCompletedBytes(), this.getFailedBytes(), this.getAverageThroughput(), this.getCurrentThroughputBytes(), this.getCurrentThroughputCnt(), this.getFindStartTime(), this.getFindEndTime(), bytesTransferred);
            this.recentJobStats.add(stats);
            if (this.recentJobStats.size() > 10) {
                this.recentJobStats.removeFirst();
            }
        }
        return stats;
    }

    @Override
    public void setStatus(JobStatus status) throws JobException {
        this.setStatus(status, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(JobStatus status, boolean persistStatus) throws JobException {
        Object object = this.statusLock;
        synchronized (object) {
            super.setStatus(status);
            if (persistStatus) {
                try {
                    ManagedJobsSchema.getInstance().updateJobStatus(this.getJobId(), status);
                }
                catch (Exception e) {
                    throw new JobException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public JobStats getStats() {
        return this.generateJobStats();
    }

    public JobDetails getDetails(boolean includeLists) {
        return new JobDetails(includeLists);
    }

    public void exportResults(File initialListFile, File successFile, File failFile, File conflictsFile) throws DatabaseException {
        if (initialListFile != null) {
            this.db.dumpTotalList(initialListFile, this.getJob().getSourceProfile());
        }
        if (successFile != null) {
            this.db.dumpSuccessList(successFile, this.getJob().getSourceProfile());
        }
        if (failFile != null) {
            this.db.dumpFailedList(failFile, this.getJob().getSourceProfile());
        }
        if (conflictsFile != null) {
            this.db.dumpConflictsList(conflictsFile, this.getJob().getSourceProfile());
        }
    }

    private void calculateMaxThreads() throws JobException {
        int maxAdapterThreads;
        int maxSourceThreads;
        int maxTargetThreads = 0;
        LoadSchedule load = this.getJob().getLoadSchedule();
        int maxConnCount = load.getMaxConnCount();
        int maxConnPerRoute = load.getMaxConnPerNodeCount();
        try {
            StorageAdapter sourceAdapter = StorageAdapterMgr.getStorageAdapter(this.getJob().getSourceProfile(), this.sourceHttpClient);
            maxSourceThreads = Math.min(sourceAdapter.getMaxNumSimultaneousHttpConnections(maxConnPerRoute), maxConnCount);
            if (this.getJob().getTargetProfile() != null) {
                StorageAdapter targetAdapter = StorageAdapterMgr.getStorageAdapter(this.getJob().getTargetProfile(), this.targetHttpClient);
                maxTargetThreads = Math.min(targetAdapter.getMaxNumSimultaneousHttpConnections(maxConnPerRoute), maxConnCount);
            }
            maxAdapterThreads = maxSourceThreads;
            if (maxTargetThreads > 0) {
                maxAdapterThreads = Math.min(maxSourceThreads, maxTargetThreads);
            }
        }
        catch (StorageAdapterLiteralException e) {
            throw new JobException(e.getMessage());
        }
        if (maxAdapterThreads < 2) {
            throw new JobException("There are not enough possible threads to run the job, only allowed " + maxAdapterThreads + " but need at least 2.");
        }
        if (this.isFindFilesComplete() || this.killJob) {
            this.maxFindThreads = 0;
        } else {
            this.maxFindThreads = maxAdapterThreads / 3;
            this.maxFindThreads = Math.min(this.maxFindThreads, this.findThreadsCap);
            this.maxFindThreads = Math.max(this.maxFindThreads, 1);
        }
        this.maxThreads = maxAdapterThreads - this.maxFindThreads;
        String logMessage = "calculateMaxThreads: Using {0} of {1} thread{2}.";
        if (load.inLowLoadTimeWindow()) {
            LOG.info(MessageFormat.format(logMessage, "reduced schedule load", this.maxThreads, this.maxThreads != 1 ? "s" : ""));
        } else {
            LOG.info(MessageFormat.format(logMessage, "default thread count", this.maxThreads, this.maxThreads != 1 ? "s" : ""));
        }
        LOG.info(MessageFormat.format("maxThreads: {0}:: maxSourceThreads: {1} maxDestinationThreads: {2}", this.maxThreads, maxSourceThreads, maxTargetThreads));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObjectToFind(ArcProcessFile file) throws DatabaseException {
        List<ArcProcessFile> filesToFlush = null;
        Object object = this.findLock;
        synchronized (object) {
            this.filesReadyToFind.add(file);
            long now = System.currentTimeMillis();
            if (this.filesReadyToFind.size() >= 5000 || now - this.lastFilesReadyToFindFlushTime > CHECKPOINT_TIME) {
                filesToFlush = this.filesReadyToFind;
                this.filesReadyToFind = new ArrayList<ArcProcessFile>();
                this.lastFilesReadyToFindFlushTime = now;
            }
        }
        this.flushObjectsToFind(filesToFlush);
        object = this.statsLock;
        synchronized (object) {
            this.incrementDiscoveredObjectCount();
        }
    }

    private ArcProcessFile getFileToFind() throws SQLException {
        return this.findFilesIterator.next();
    }

    private FileStats getFileToProcess() throws SQLException {
        return this.processFilesIterator.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArcProcessFile getNextObjectToFind(FindFilesThread caller) throws DatabaseException, SQLException {
        List<FindFilesThread> list = this.findWorkers;
        synchronized (list) {
            ArcProcessFile file = null;
            while (!caller.die && file == null && this.possiblyMoreToFind) {
                file = this.getFileToFind();
                if (file != null) continue;
                int totalNumberOfFindThreads = this.findWorkers.size();
                if (totalNumberOfFindThreads == 1 || this.numberOfFindThreadsWaiting == totalNumberOfFindThreads - 1) {
                    this.possiblyMoreToFind = false;
                    continue;
                }
                if (this.numberOfFindThreadsWaiting >= totalNumberOfFindThreads - 1) continue;
                try {
                    ++this.numberOfFindThreadsWaiting;
                    this.findWorkers.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --this.numberOfFindThreadsWaiting;
            }
            this.findWorkers.notifyAll();
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markFileReadyToProcess(ArcProcessFile file) throws DatabaseException {
        List<ArcProcessFile> filesToFlush = null;
        Object object = this.processLock;
        synchronized (object) {
            this.filesReadyToProcess.add(file);
            if (this.filesReadyToProcess.size() >= CHECKPOINT_SIZE) {
                filesToFlush = this.filesReadyToProcess;
                this.filesReadyToProcess = new ArrayList<ArcProcessFile>();
            }
        }
        this.flushFilesReadyToProcess(filesToFlush);
        object = this.statsLock;
        synchronized (object) {
            this.addToTotalBytes(file.getSize());
            this.incrementTotalObjectCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushInMemoryCaches() throws DatabaseException {
        Set<FileStats> processedObjects;
        List<ArcProcessFile> processableObjects;
        Object object = this.processLock;
        synchronized (object) {
            processableObjects = this.filesReadyToProcess;
            this.filesReadyToProcess = new ArrayList<ArcProcessFile>();
            processedObjects = this.objectsProcessed;
            this.objectsProcessed = new TreeSet<FileStats>(FILE_STATS_DB_ID_COMPARATOR);
        }
        this.flushFilesReadyToProcess(processableObjects);
        this.flushProcessedObjects(processedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushObjectsToFind() throws DatabaseException {
        List<ArcProcessFile> filesToFlush = null;
        Object object = this.findLock;
        synchronized (object) {
            if (this.filesReadyToFind.size() >= 0) {
                filesToFlush = this.filesReadyToFind;
                this.filesReadyToFind = new ArrayList<ArcProcessFile>();
            }
        }
        this.flushObjectsToFind(filesToFlush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushObjectsToFind(Collection<ArcProcessFile> filesToFlush) throws DatabaseException {
        if (filesToFlush != null && !filesToFlush.isEmpty()) {
            this.db.insertFilesToDiscover(filesToFlush);
            this.findFilesIterator.tableChanged(filesToFlush.size());
            List<FindFilesThread> list = this.findWorkers;
            synchronized (list) {
                this.findWorkers.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushFilesReadyToProcess(Collection<ArcProcessFile> filesToFlush) throws DatabaseException {
        if (filesToFlush != null && !filesToFlush.isEmpty()) {
            this.db.markFilesReadyToProcess(filesToFlush);
            this.processFilesIterator.tableChanged(filesToFlush.size());
            Object object = this.processLock;
            synchronized (object) {
                this.processLock.notifyAll();
            }
        }
    }

    private void flushProcessedObjects(Collection<FileStats> objectsProcessed) throws DatabaseException {
        if (objectsProcessed != null && !objectsProcessed.isEmpty()) {
            this.db.markFilesProcessed(objectsProcessed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileStats getNextObjectToProcess(ProcessFileThread processFileThread) throws DatabaseException, SQLException {
        FileStats file = null;
        Object object = this.processLock;
        synchronized (object) {
            while (!processFileThread.die && file == null) {
                file = this.getFileToProcess();
                if (file != null) continue;
                if (this.isFindFilesComplete() || this.killJob) break;
                try {
                    this.processLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (file != null) {
            file.markStartTime();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeObject(FileStats fileStats, Integer statusCode) throws DatabaseException {
        fileStats.setStatus(FileStatus.SUCCEEDED);
        fileStats.setStatusCode(statusCode);
        fileStats.markEndTime();
        fileStats.setIncludeInStats(this.includeInStats(fileStats));
        Set<FileStats> filesToFlush = null;
        Object object = this.processLock;
        synchronized (object) {
            this.objectsProcessed.add(fileStats);
            if (this.objectsProcessed.size() >= CHECKPOINT_SIZE) {
                filesToFlush = this.objectsProcessed;
                this.objectsProcessed = new TreeSet<FileStats>(FILE_STATS_DB_ID_COMPARATOR);
            }
        }
        this.flushProcessedObjects(filesToFlush);
        if (fileStats.includeInStats()) {
            this.addToCompletedBytes(fileStats.getSize());
            this.incrementCompletedObjectCount();
            object = this.statsLock;
            synchronized (object) {
                ManagedJobImpl.addToFixedSizeList(this.objectsCompleted, fileStats);
            }
            this.successProgressLogger.log(fileStats.getSourcePath(), this.getCompletedObjectCount(), this.getJob().getJobType());
        }
    }

    private static void addToFixedSizeList(List<FileStats> list, FileStats file) {
        list.add(file);
        if (list.size() > 1000) {
            list.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void failObject(FileStats fileStats, Throwable t, Integer statusCode, boolean failedDuringFind, boolean addToCache) throws DatabaseException {
        Set<FileStats> filesToFlush;
        LOG.log(Level.INFO, "Could not process file " + fileStats.getSourcePath(), t);
        fileStats.setException(t);
        fileStats.setStatus(FileStatus.FAILED);
        fileStats.setStatusCode(statusCode);
        fileStats.markEndTime();
        fileStats.setFailedDuringFind(failedDuringFind);
        fileStats.setIncludeInStats(this.includeInStats(fileStats));
        if (addToCache) {
            filesToFlush = null;
            Object object = this.processLock;
            synchronized (object) {
                this.objectsProcessed.add(fileStats);
                if (this.objectsProcessed.size() >= CHECKPOINT_SIZE) {
                    filesToFlush = this.objectsProcessed;
                    this.objectsProcessed = new TreeSet<FileStats>(FILE_STATS_DB_ID_COMPARATOR);
                }
            }
            this.flushProcessedObjects(filesToFlush);
        }
        if (failedDuringFind && fileStats.includeInStats()) {
            this.incrementTotalObjectCount();
        }
        if (fileStats.includeInStats()) {
            this.incrementFailedObjectCount();
            if (!failedDuringFind && !fileStats.getArcProcssFile().isDirectory()) {
                this.addToFailedBytes(fileStats.getSize());
            }
        }
        if (fileStats.getArcProcssFile().isDirectory()) {
            this.incrementFailedDirCount();
        }
        filesToFlush = this.statsLock;
        synchronized (filesToFlush) {
            ManagedJobImpl.addToFixedSizeList(this.objectsErrored, fileStats);
        }
        Throwable th = fileStats.getException();
        this.failureProgressLogger.log(fileStats.getSourcePath(), th == null ? "unknown" : th.getMessage(), this.getFailedObjectCount(), this.getJob().getJobType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FileStats> getObjectsCompleted() {
        Object object = this.statsLock;
        synchronized (object) {
            return new ArrayList<FileStats>(this.objectsCompleted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FileStats> getObjectsErrored() {
        Object object = this.statsLock;
        synchronized (object) {
            return new ArrayList<FileStats>(this.objectsErrored);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FileStats> getObjectsProcessing() {
        Object object = this.statsLock;
        synchronized (object) {
            ArrayList<FileStats> list = new ArrayList<FileStats>(this.objectsProcessing);
            Collections.sort(list);
            return list;
        }
    }

    private void refreshThreadLoad() throws JobException {
        this.refreshThreadLoad(false);
    }

    private void refreshHttpConnMgr() {
        if (this.sourceHttpClient != null) {
            ClientConnectionManager sourceConnMgr = this.sourceHttpClient.getConnectionManager();
            sourceConnMgr.closeExpiredConnections();
        }
        if (this.targetHttpClient != null) {
            ClientConnectionManager targetConnMgr = this.targetHttpClient.getConnectionManager();
            targetConnMgr.closeExpiredConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshThreadLoad(boolean force) throws JobException {
        long defaultRefreshIntervalMS = 120000L;
        long refreshIntervalMS = ConfigurationHelper.getLongProperty("managedJob.threadRefreshIntervalMS", defaultRefreshIntervalMS);
        if (!this.killJob && (force || System.currentTimeMillis() > this.lastThreadRefreshMS + refreshIntervalMS)) {
            Object object = this.dnsRefreshLock;
            synchronized (object) {
                if (!this.killJob && (force || System.currentTimeMillis() > this.lastThreadRefreshMS + refreshIntervalMS)) {
                    int i;
                    int diff;
                    List<Thread> list;
                    LOG.log(Level.FINE, "Refreshing Thread Load");
                    this.calculateMaxThreads();
                    this.refreshHttpConnMgr();
                    if (!this.isFindFilesComplete()) {
                        list = this.findWorkers;
                        synchronized (list) {
                            int numberOfCurrentFindThreads = this.findWorkers.size();
                            if (this.maxFindThreads < numberOfCurrentFindThreads) {
                                diff = numberOfCurrentFindThreads - this.maxFindThreads;
                                for (i = 0; i < diff; ++i) {
                                    this.findWorkers.get(i).setStopSignal();
                                }
                            } else {
                                while (this.findWorkers.size() < this.maxFindThreads) {
                                    FindFilesThread findFileThread = new FindFilesThread(this.jobThreadGroup, "FindWorker_" + this.findWorkers.size(), this.getJob());
                                    findFileThread.setDaemon(true);
                                    this.findWorkers.add(findFileThread);
                                    findFileThread.start();
                                }
                            }
                        }
                    }
                    if (this.maxThreads != this.maxProcessingThreads) {
                        LOG.log(Level.INFO, "Setting maxProcessingThreads to " + this.maxThreads);
                    }
                    this.maxProcessingThreads = this.maxThreads;
                    list = this.fileProcessorWorkers;
                    synchronized (list) {
                        int numberOfCurrentProcessingThreads = this.fileProcessorWorkers.size();
                        if (this.maxProcessingThreads < numberOfCurrentProcessingThreads) {
                            diff = numberOfCurrentProcessingThreads - this.maxProcessingThreads;
                            for (i = 0; i < diff; ++i) {
                                this.fileProcessorWorkers.get(i).setStopSignal();
                            }
                        } else {
                            while (this.fileProcessorWorkers.size() < this.maxProcessingThreads) {
                                ++this.totalNumberOfProcessingThreads;
                                ProcessFileThread processFileThread = new ProcessFileThread(this.jobThreadGroup, "processFileWorker_" + this.totalNumberOfProcessingThreads, this.getJob());
                                processFileThread.setDaemon(true);
                                processFileThread.setMySpec(this.getJob());
                                this.fileProcessorWorkers.add(processFileThread);
                                processFileThread.start();
                            }
                        }
                    }
                    this.lastThreadRefreshMS = System.currentTimeMillis();
                }
            }
        }
    }

    private void initHttpClients() {
        StorageAdapter targetAdapter;
        StorageAdapter sourceAdapter = StorageAdapterMgr.getStorageAdapter(this.getJob().getSourceProfile(), this.sourceHttpClient);
        if (sourceAdapter instanceof HCAPAdapter) {
            HCAPAdapter hcpAdapter = (HCAPAdapter)sourceAdapter;
            hcpAdapter.updateHttpClient(this.getJob().getLoadSchedule());
            this.sourceHttpClient = hcpAdapter.getHttpClient();
        }
        if ((targetAdapter = StorageAdapterMgr.getStorageAdapter(this.getJob().getTargetProfile(), this.targetHttpClient)) instanceof HCAPAdapter) {
            HCAPAdapter hcpAdapter = (HCAPAdapter)targetAdapter;
            hcpAdapter.updateHttpClient(this.getJob().getLoadSchedule());
            this.targetHttpClient = hcpAdapter.getHttpClient();
        }
    }

    private boolean prepareForRestart() throws JobException {
        try (ResetJobTableIterator itr = null;){
            itr = this.db.getResetJobTableIterator(this.requiresPostProcessingOfDirectories());
            while (!this.killJob && itr.updateNextBatch()) {
            }
            if (!this.killJob) {
                this.db.resetJobStats();
                this.loadManagedJobStats(false);
            }
            boolean bl = !this.killJob;
            return bl;
        }
    }

    private void prepareForResume() throws JobException {
        try {
            this.partialDirListings = this.db.prepareFilesForResume();
        }
        catch (Exception e) {
            String errMsg = "Error preparing job for running: " + e.getMessage();
            throw new JobException(errMsg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runJob() throws JobException {
        ShutdownHookThread shutdownHook = new ShutdownHookThread();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        try {
            String versionStr;
            Package dmPackage = HCPDataMigrator.class.getPackage();
            if (dmPackage != null && (versionStr = dmPackage.getSpecificationVersion()) != null) {
                LOG.info("Running Job with version " + versionStr + " of Data Migrator");
            }
            this.sourceSupportsVersioning = this.getJob().getSourceProfile().supportsVersioning();
            this.setStartTime(new Date());
            this.setEndTime(null);
            this.successProgressLogger.logJobStarted(this);
            this.failureProgressLogger.logJobStarted(this);
            this.killJob = false;
            try {
                this.setFindFilesComplete(false, false);
            }
            catch (DatabaseException de) {
                throw new JobException(de.getMessage(), (Throwable)de);
            }
            if (this.getStatus() == JobStatus.PREPARING_FOR_RESTART && this.prepareForRestart()) {
                this.setStatus(JobStatus.RUNNING);
            }
            if (this.killJob) {
                this.setEndOfJobReached();
                return;
            }
            this.prepareForResume();
            if (this.killJob) {
                this.setEndOfJobReached();
                return;
            }
            this.initHttpClients();
            this.findFilesIterator.reset();
            this.processFilesIterator = this.db.getProcessFileIterator();
            this.setFindStartTime(new Date());
            this.refreshThreadLoad(true);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException de) {
                // empty catch block
            }
            FindFilesThread findThread = null;
            List<FindFilesThread> list = this.findWorkers;
            synchronized (list) {
                if (!this.findWorkers.isEmpty()) {
                    findThread = this.findWorkers.get(0);
                }
            }
            while (findThread != null) {
                this.joinThread(findThread);
                list = this.findWorkers;
                synchronized (list) {
                    this.findWorkers.remove(findThread);
                    findThread = null;
                    if (!this.findWorkers.isEmpty()) {
                        findThread = this.findWorkers.get(0);
                    }
                    this.findWorkers.notifyAll();
                }
            }
            try {
                this.flushInMemoryCaches();
                if (!this.killJob) {
                    this.setFindFilesComplete(true, true);
                }
            }
            catch (DatabaseException e) {
                throw new JobException(this.getJobId(), e.getMessage(), e);
            }
            ProcessFileThread processFileThread = null;
            List<ProcessFileThread> list2 = this.fileProcessorWorkers;
            synchronized (list2) {
                if (!this.fileProcessorWorkers.isEmpty()) {
                    processFileThread = this.fileProcessorWorkers.get(0);
                }
            }
            while (processFileThread != null) {
                this.joinThread(processFileThread);
                list2 = this.fileProcessorWorkers;
                synchronized (list2) {
                    this.fileProcessorWorkers.remove(processFileThread);
                    processFileThread = null;
                    if (!this.fileProcessorWorkers.isEmpty()) {
                        processFileThread = this.fileProcessorWorkers.get(0);
                    }
                }
            }
            try {
                this.flushInMemoryCaches();
            }
            catch (DatabaseException e) {
                throw new JobException(this.getJobId(), e.getMessage(), e);
            }
            if (!this.killJob && this.requiresPostProcessingOfDirectories()) {
                this.doPostProcessing();
            }
            try {
                this.flushInMemoryCaches();
                this.setEndTime(new Date());
                this.previousRunTime += this.getEndTime().getTime() - this.getStartTime().getTime();
                this.db.updateRunStats(this.getStartTime().getTime(), this.getEndTime().getTime(), this.previousRunTime);
                this.loadManagedJobStats(true);
            }
            catch (DatabaseException e) {
                throw new JobException(this.getJobId(), e.getMessage(), e);
            }
            if (JobStatus.RUNNING.equals((Object)this.getStatus()) && !this.killJob) {
                this.setStatus(JobStatus.COMPLETED);
            }
            this.setEndOfJobReached();
        }
        catch (SQLException e) {
            throw new JobException(this.getJobId(), e.getMessage(), e);
        }
        catch (StorageAdapterException e) {
            throw new JobException(this.getJobId(), e.getMessage(), e);
        }
        finally {
            if (!shutdownHookObserved) {
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
            }
            if (this.sourceHttpClient != null && this.sourceHttpClient.getConnectionManager() != null) {
                this.sourceHttpClient.getConnectionManager().shutdown();
                this.sourceHttpClient = null;
            }
            if (this.targetHttpClient != null && this.targetHttpClient.getConnectionManager() != null) {
                this.targetHttpClient.getConnectionManager().shutdown();
                this.targetHttpClient = null;
            }
        }
    }

    private void loadManagedJobStats(boolean includeTimes) throws DatabaseException, JobException {
        ManagedJobStats stats = ManagedJobsSchema.getInstance().loadManagedJobStats(this.getJobId().getId());
        if (includeTimes) {
            if (stats.getStartTime() != null) {
                this.setStartTime(stats.getStartTime());
            }
            if (stats.getEndTime() != null) {
                this.setEndTime(stats.getEndTime());
            }
            if (stats.getRunTimeMs() >= 0L) {
                this.setPreviousRunTime(stats.getRunTimeMs());
            }
        }
        if (stats.getDiscoveredObjectCount() >= 0L) {
            this.setDiscoveredObjectCount(stats.getDiscoveredObjectCount());
        }
        if (stats.getTotalObjectCount() >= 0L) {
            this.setTotalObjectCount(stats.getTotalObjectCount());
        }
        if (stats.getTotalBytes() >= 0L) {
            this.setTotalBytes(stats.getTotalBytes());
        }
        if (stats.getCompletedObjectCount() >= 0L) {
            this.setCompletedObjectCount(stats.getCompletedObjectCount());
        }
        if (stats.getCompletedBytes() >= 0L) {
            this.setCompletedBytes(stats.getCompletedBytes());
        }
        if (stats.getErroredObjectCount() >= 0L) {
            this.setFailedObjectCount(stats.getErroredObjectCount());
        }
        if (stats.getErroredBytes() >= 0L) {
            this.setFailedBytes(stats.getErroredBytes());
        }
        if (stats.getErroredDirCount() >= 0L) {
            this.setFailedDirCount(stats.getErroredDirCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEndOfJobReached() {
        Object object = this.endOfJobLock;
        synchronized (object) {
            this.endOfJobReached = true;
            this.endOfJobLock.notifyAll();
        }
        this.successProgressLogger.logJobStopped(this, this.getCompletedObjectCount());
        this.failureProgressLogger.logJobStopped(this, this.getFailedObjectCount());
    }

    protected void joinThread(Thread thread) {
        while (true) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEndOfJob() {
        Object object = this.endOfJobLock;
        synchronized (object) {
            while (!this.endOfJobReached) {
                try {
                    this.endOfJobLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFindFilesComplete(boolean isComplete, boolean persistToDb) throws DatabaseException {
        Object object = this.processLock;
        synchronized (object) {
            this.findFilesComplete = isComplete;
            if (isComplete) {
                this.setFindEndTime(new Date());
                this.processLock.notifyAll();
            }
        }
        if (persistToDb) {
            this.db.updateFindFilesStatus(isComplete);
        }
    }

    @Override
    public void cancel() throws JobException {
        this.stopJob(JobStatus.CANCELLED, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopJob(JobStatus status, boolean abortActiveTransfer, boolean waitForJobToComplete) throws JobException {
        JobStatus jobStatus;
        this.killJob = true;
        final ArrayList<StorageAdapter> adapters = new ArrayList<StorageAdapter>();
        List<Thread> list = this.findWorkers;
        synchronized (list) {
            for (FindFilesThread findFilesThread : this.findWorkers) {
                findFilesThread.setStopSignal();
                if (!abortActiveTransfer || findFilesThread.getSourceApapter() == null) continue;
                adapters.add(findFilesThread.getSourceApapter());
            }
            this.findWorkers.notifyAll();
        }
        list = this.fileProcessorWorkers;
        synchronized (list) {
            for (ProcessFileThread processFileThread : this.fileProcessorWorkers) {
                if (processFileThread == null) continue;
                processFileThread.setStopSignal();
                if (!abortActiveTransfer) continue;
                if (processFileThread.getTargetAdapter() != null) {
                    adapters.add(processFileThread.getTargetAdapter());
                }
                if (processFileThread.getSourceAdapter() == null) continue;
                adapters.add(processFileThread.getSourceAdapter());
            }
            this.fileProcessorWorkers.notifyAll();
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(HCPMoverProperties.PAUSE_WAIT_MILLIS.getAsLong());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                for (StorageAdapter adapter : adapters) {
                    adapter.close();
                }
            }
        };
        new Thread(runner).start();
        ManagedJobFileAction localPostProcessAction = this.currentPostProcessAction;
        if (localPostProcessAction != null) {
            localPostProcessAction.cancel();
        }
        Object object = this.processLock;
        synchronized (object) {
            this.processLock.notifyAll();
        }
        if (waitForJobToComplete) {
            this.waitForEndOfJob();
        }
        if ((jobStatus = this.getStatus()) == JobStatus.PREPARING_FOR_RESTART && status == JobStatus.PAUSED) {
            this.setJobException(new Exception("Job paused while preparing for restart.  Rerun job to continue where it left off."));
            this.setStatus(JobStatus.FAILED);
        } else {
            this.setStatus(status);
        }
    }

    @Override
    public void start() throws JobException {
        try {
            if (this.getStatus().isFinished()) {
                this.setStatus(JobStatus.PREPARING_FOR_RESTART);
            } else {
                this.setStatus(JobStatus.RUNNING);
            }
            this.runJob();
            if (JobStatus.RUNNING.equals((Object)this.getStatus()) && !this.killJob) {
                this.setStatus(JobStatus.COMPLETED);
            }
        }
        catch (JobException e) {
            this.setStatus(JobStatus.FAILED);
            throw e;
        }
        catch (Exception e) {
            this.setStatus(JobStatus.FAILED);
            throw new JobException(this.getJobId(), (Throwable)e);
        }
    }

    public void stop() throws JobException {
        this.stopJob(JobStatus.PAUSED, true, true);
    }

    protected abstract boolean requiresFindFileSize();

    protected abstract boolean requiresProcessingOfEmptyDirectories();

    protected abstract boolean requiresPostProcessingOfDirectories();

    protected abstract void doPostProcessing() throws JobException;

    protected abstract ManagedJobFileAction getManagedJobFileAction(ManagedJob var1, StorageAdapter var2, StorageAdapter var3);

    protected abstract ManagedJobFileAction getPostProcessFileAction(ManagedJob var1, StorageAdapter var2, StorageAdapter var3);

    protected abstract ArcProcessFile createArcProcessFileForDirectory(ArcProcessFile var1, ArcMoverFile var2);

    protected abstract ArcProcessFile createArcProcessFileForFile(ArcProcessFile var1, ArcMoverFile var2, ManagedJob var3);

    public abstract void parseListFile() throws IOException, DatabaseException;

    protected abstract boolean includeInStats(FileStats var1);

    protected abstract boolean treatAsSuccess(Integer var1);

    public abstract boolean supportsConflictReports();

    public boolean equals(Object o) {
        if (!(o instanceof ManagedJobImpl)) {
            return false;
        }
        ManagedJobImpl that = (ManagedJobImpl)o;
        if (this.findFilesComplete != that.findFilesComplete) {
            return false;
        }
        if (!ManagedJobImpl.nullSafeEquals(this.objectsCompleted, that.objectsCompleted)) {
            return false;
        }
        if (!ManagedJobImpl.nullSafeEquals(this.objectsErrored, that.objectsErrored)) {
            return false;
        }
        if (!ManagedJobImpl.nullSafeEquals(this.objectsProcessing, that.objectsProcessing)) {
            return false;
        }
        if (this.lastFilesReadyToFindFlushTime != that.lastFilesReadyToFindFlushTime) {
            return false;
        }
        if (!ManagedJobImpl.nullSafeEquals(this.filesReadyToFind, that.filesReadyToFind)) {
            return false;
        }
        if (!ManagedJobImpl.nullSafeEquals(this.filesReadyToProcess, that.filesReadyToProcess)) {
            return false;
        }
        if (!ManagedJobImpl.nullSafeEquals(this.objectsProcessed, that.objectsProcessed)) {
            return false;
        }
        if (!ManagedJobImpl.nullSafeEquals(this.findStartTime, that.findStartTime)) {
            return false;
        }
        if (!ManagedJobImpl.nullSafeEquals(this.findEndTime, that.findEndTime)) {
            return false;
        }
        if (this.maxThreads != that.maxThreads) {
            return false;
        }
        if (this.maxFindThreads != that.maxFindThreads) {
            return false;
        }
        if (this.findThreadsCap != that.findThreadsCap) {
            return false;
        }
        if (this.maxProcessingThreads != that.maxProcessingThreads) {
            return false;
        }
        if (this.lastThreadRefreshMS != that.lastThreadRefreshMS) {
            return false;
        }
        if (this.totalNumberOfProcessingThreads != that.totalNumberOfProcessingThreads) {
            return false;
        }
        if (this.numberOfFindThreadsWaiting != that.numberOfFindThreadsWaiting) {
            return false;
        }
        if (this.possiblyMoreToFind != that.possiblyMoreToFind) {
            return false;
        }
        if (this.inLowLoadTimeWindow != that.inLowLoadTimeWindow) {
            return false;
        }
        if (this.previousRunTime != that.previousRunTime) {
            return false;
        }
        if (this.totalObjCnt != that.totalObjCnt) {
            return false;
        }
        if (this.totalObjSize != that.totalObjSize) {
            return false;
        }
        if (this.successObjCnt != that.successObjCnt) {
            return false;
        }
        if (this.successObjSize != that.successObjSize) {
            return false;
        }
        if (this.failObjCnt != that.failObjCnt) {
            return false;
        }
        if (this.failObjSize != that.failObjSize) {
            return false;
        }
        if (this.discoveredObjCnt != that.discoveredObjCnt) {
            return false;
        }
        if (this.failDirCnt != that.failDirCnt) {
            return false;
        }
        return this.sourceSupportsVersioning == that.sourceSupportsVersioning;
    }

    private static boolean nullSafeEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public class JobDetails {
        private JobId jobId;
        private ManagedJobStats jobStats;
        private List<FileStats> objectsProcessing;
        private List<FileStats> objectsCompleted;
        private List<FileStats> objectsFailed;

        private JobDetails(boolean includeLists) {
            this.jobId = ManagedJobImpl.this.getJobId();
            this.jobStats = ManagedJobImpl.this.generateJobStats();
            this.objectsProcessing = ManagedJobImpl.this.getObjectsProcessing();
            if (includeLists) {
                this.objectsCompleted = ManagedJobImpl.this.getObjectsCompleted();
                this.objectsFailed = ManagedJobImpl.this.getObjectsErrored();
            }
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public ManagedJobStats getJobStats() {
            return this.jobStats;
        }

        public List<FileStats> getObjectsProcessing() {
            return this.objectsProcessing;
        }

        public List<FileStats> getObjectsCompleted() {
            return this.objectsCompleted;
        }

        public List<FileStats> getObjectsFailed() {
            return this.objectsFailed;
        }
    }

    private class FindFilesThread
    extends Thread {
        private volatile boolean die;
        private ManagedJob mySpec;
        private ArcMoverDirectory currentDirectory;
        StorageAdapter sourceAdapter;

        public FindFilesThread(ThreadGroup group, String threadName, ManagedJob mySpec) {
            super(group, threadName);
            this.currentDirectory = null;
            this.mySpec = mySpec;
            this.sourceAdapter = StorageAdapterMgr.getStorageAdapter(mySpec.getSourceProfile(), ManagedJobImpl.this.sourceHttpClient);
        }

        public StorageAdapter getSourceApapter() {
            return this.sourceAdapter;
        }

        public void setStopSignal() {
            this.die = true;
            if (this.currentDirectory != null) {
                this.currentDirectory.abortASAP();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                THREADLOG.log(Level.INFO, "Started Find-Files thread: {0}", this);
                ArcProcessFile currentFile = ManagedJobImpl.this.getNextObjectToFind(this);
                while (!this.die && currentFile != null) {
                    if (ManagedJobImpl.this.getJob().getLoadSchedule().inLowLoadTimeWindow() != ManagedJobImpl.this.inLowLoadTimeWindow) {
                        ManagedJobImpl.this.initHttpClients();
                        ManagedJobImpl.this.refreshThreadLoad(true);
                        ManagedJobImpl.this.inLowLoadTimeWindow = ManagedJobImpl.this.getJob().getLoadSchedule().inLowLoadTimeWindow();
                    } else {
                        ManagedJobImpl.this.refreshThreadLoad();
                    }
                    if (!this.die) {
                        this.findFile(currentFile);
                    }
                    if (this.die) {
                        THREADLOG.log(Level.INFO, "Find thread asked to die, so exiting");
                        break;
                    }
                    currentFile = ManagedJobImpl.this.getNextObjectToFind(this);
                }
            }
            catch (Throwable e) {
                THREADLOG.log(Level.SEVERE, "Find-Files thread failed: " + this, e);
                ManagedJobImpl.this.setJobException(e);
                try {
                    ManagedJobImpl.this.stopJob(JobStatus.FAILED, true, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            THREADLOG.log(Level.INFO, "Find-Files thread complete: {0}", this);
            List list = ManagedJobImpl.this.findWorkers;
            synchronized (list) {
                ManagedJobImpl.this.findWorkers.remove(this);
                ManagedJobImpl.this.findWorkers.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void findFile(ArcProcessFile fileToProcess) throws DatabaseException {
            LOG.log(Level.FINEST, "Inspecting object {0} to determine whether it should be copied: {0}", fileToProcess);
            try {
                int retriesReamaining = 3;
                boolean done = false;
                while (!this.die && !done && retriesReamaining > 0) {
                    --retriesReamaining;
                    try {
                        this.currentDirectory = null;
                        if (fileToProcess.getSourceArcMoverFile() instanceof ArcMoverDirectory) {
                            this.findDirectory(fileToProcess);
                        } else if (fileToProcess.getSourceArcMoverFile().getFileType().equals(FileType.UNKNOWN)) {
                            FileMetadata metadata = this.sourceAdapter.getMetadata(fileToProcess.getSourcePath(), fileToProcess.getSourceFile().getVersionString(), FileType.UNKNOWN, fileToProcess.getSourceFile().isVersion());
                            if (metadata == null || metadata.getFileType() == FileType.UNKNOWN) {
                                LOG.log(Level.WARNING, "get Metadata returned FileType.UNKNOWN. We cannot continue to process thisfile or directory.  Path: " + fileToProcess.getSourcePath());
                                throw new JobException("Could not get file metadata for file: " + fileToProcess.getSourcePath());
                            }
                            ArcMoverFile file = ArcMoverFile.getFileInstance(this.mySpec.getSourceProfile(), fileToProcess.getSourcePath(), metadata);
                            ArcProcessFile newFile = ManagedJobImpl.this.createArcProcessFileForFile(fileToProcess, file, this.mySpec);
                            ManagedJobImpl.this.addObjectToFind(newFile);
                            ManagedJobImpl.this.flushObjectsToFind();
                            ManagedJobImpl.this.db.markFileComplete(fileToProcess);
                        } else {
                            if (fileToProcess.isFile() && ManagedJobImpl.this.requiresFindFileSize()) {
                                long size = this.sourceAdapter.getFileSize(fileToProcess.getSourceFile());
                                fileToProcess.getSourceFile().setSize(size);
                            }
                            ManagedJobImpl.this.markFileReadyToProcess(fileToProcess);
                            LOG.log(Level.FINE, "Added object to copy queue: {0}", fileToProcess.getSourcePath());
                        }
                        done = true;
                    }
                    catch (StorageAdapterRetryException e) {
                        if (retriesReamaining == 0) {
                            throw new JobException(null, "Failed to find object, retries exceeded", e);
                        }
                        this.sourceAdapter.close();
                        LOG.log(Level.INFO, "Got an error while finding the object, sleeping before retrying.  Msg: " + e.getMessage(), e);
                        try {
                            Thread.sleep(e.getRetryTime());
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            catch (JobException je) {
                ManagedJobImpl.this.failObject(new FileStats(fileToProcess), je, je.getStatusCode(), true, true);
            }
            catch (StorageAdapterException sae) {
                ManagedJobImpl.this.failObject(new FileStats(fileToProcess), sae, sae.getStatusCode(), true, true);
            }
            finally {
                this.sourceAdapter.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void findDirectory(ArcProcessFile dirToProcess) throws DatabaseException {
            ArrayList<ArcProcessFile> dirFiles = new ArrayList<ArcProcessFile>();
            boolean completedDirListing = false;
            Exception dirFailureException = null;
            Integer statusCode = null;
            boolean isEmptyDirectory = true;
            try {
                ArcMoverDirectory dir = (ArcMoverDirectory)dirToProcess.getSourceArcMoverFile();
                ArcMoverDirectory adapterInterface = ArcMoverFactory.getInstance().getDirectoryListing(this.sourceAdapter, dir.getPath(), true);
                Iterator<ArcMoverFile> filesToMove = adapterInterface.getFileListIterator(false, ManagedJobImpl.this.sourceSupportsVersioning);
                BadElementException badElementException = null;
                int badElementCnt = 0;
                boolean isPartialDirListing = ManagedJobImpl.this.partialDirListings.contains(dirToProcess.getSourcePath());
                boolean firstBatch = true;
                for (int i = 0; filesToMove.hasNext() && (i < CHECKPOINT_SIZE || !this.die); ++i) {
                    try {
                        ArcMoverFile moverFile = filesToMove.next();
                        ArcProcessFile processFile = ManagedJobImpl.this.createArcProcessFileForDirectory(dirToProcess, moverFile);
                        if (isPartialDirListing && ManagedJobImpl.this.db.isFileAlreadyDiscovered(processFile.getSourcePath())) {
                            LOG.log(Level.FINE, String.format("Dir listing skipping file %s because it is already in DB", processFile.getSourcePath()));
                            continue;
                        }
                        LOG.log(Level.FINE, String.format("Read file from dir: %s", processFile.getSourcePath()));
                        isEmptyDirectory = false;
                        dirFiles.add(processFile);
                        ManagedJobImpl.this.incrementDiscoveredObjectCount();
                        if (dirFiles.size() < CHECKPOINT_SIZE) continue;
                        ManagedJobImpl.this.db.insertDirListingBatch(dirFiles, dirToProcess, firstBatch);
                        ManagedJobImpl.this.findFilesIterator.tableChanged(dirFiles.size());
                        List list = ManagedJobImpl.this.findWorkers;
                        synchronized (list) {
                            ManagedJobImpl.this.findWorkers.notifyAll();
                        }
                        dirFiles.clear();
                        firstBatch = false;
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        LOG.log(Level.FINEST, "Unsupported object encountered, skipping.", e);
                        continue;
                    }
                    catch (BadElementException bee) {
                        if (badElementException == null) {
                            badElementException = bee;
                        }
                        ++badElementCnt;
                        continue;
                    }
                    catch (DirectoryListingXmlException dlxe) {
                        completedDirListing = true;
                        throw new JobException(dlxe.getMessage(), (Throwable)dlxe);
                    }
                }
                boolean bl = completedDirListing = !filesToMove.hasNext();
                if (badElementException != null) {
                    dirFailureException = new JobException(String.format("Failed to read %d elements in the directory listing.  First error: %s", badElementCnt, badElementException.getMessage()), (Throwable)badElementException);
                }
            }
            catch (JobException je) {
                dirFailureException = je;
                statusCode = je.getStatusCode();
            }
            catch (StorageAdapterException sae) {
                dirFailureException = sae;
                statusCode = sae.getStatusCode();
            }
            if (completedDirListing) {
                boolean requiresProcessing = isEmptyDirectory && ManagedJobImpl.this.requiresProcessingOfEmptyDirectories();
                boolean requiresPostProcessing = ManagedJobImpl.this.requiresPostProcessingOfDirectories();
                ManagedJobImpl.this.db.markDirProcessed(dirToProcess, dirFiles, dirFailureException, requiresProcessing, requiresPostProcessing);
                if (!dirFiles.isEmpty()) {
                    ManagedJobImpl.this.findFilesIterator.tableChanged(dirFiles.size());
                    List list = ManagedJobImpl.this.findWorkers;
                    synchronized (list) {
                        ManagedJobImpl.this.findWorkers.notifyAll();
                    }
                }
                if (requiresProcessing) {
                    ManagedJobImpl.this.processFilesIterator.tableChanged(1);
                }
                if (dirFailureException != null) {
                    ManagedJobImpl.this.failObject(new FileStats(dirToProcess), dirFailureException, statusCode, true, false);
                } else if (requiresPostProcessing) {
                    ManagedJobImpl.this.incrementTotalObjectCount();
                }
            }
        }
    }

    protected class ProcessFileThread
    extends Thread {
        private volatile boolean die;
        int numOfFilesCopied;
        ManagedJob mySpec;
        private volatile ManagedJobFileAction currentAction;
        StorageAdapter sourceAdapter;
        StorageAdapter targetAdapter;

        public StorageAdapter getSourceAdapter() {
            return this.sourceAdapter;
        }

        public StorageAdapter getTargetAdapter() {
            return this.targetAdapter;
        }

        public ProcessFileThread(ThreadGroup group, String threadName, ManagedJob mySpec) {
            super(group, threadName);
            this.die = false;
            this.numOfFilesCopied = 0;
            this.currentAction = null;
            this.sourceAdapter = StorageAdapterMgr.getStorageAdapter(ManagedJobImpl.this.getJob().getSourceProfile(), ManagedJobImpl.this.sourceHttpClient);
            this.targetAdapter = StorageAdapterMgr.getStorageAdapter(ManagedJobImpl.this.getJob().getTargetProfile(), ManagedJobImpl.this.targetHttpClient);
            this.mySpec = mySpec;
            LOG.log(Level.FINE, "Created Thread: {0}", this);
        }

        public void setStopSignal() {
            this.die = true;
            ManagedJobFileAction localCurrentAction = this.currentAction;
            if (localCurrentAction != null) {
                localCurrentAction.cancel();
            }
        }

        protected void setMySpec(ManagedJob mySpec) {
            this.mySpec = mySpec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ManagedJobFileAction fileAction;
            this.currentAction = fileAction = ManagedJobImpl.this.getManagedJobFileAction(this.mySpec, this.sourceAdapter, this.targetAdapter);
            try {
                THREADLOG.log(Level.INFO, "Started file processing thread: {0}", this);
                FileStats stats = ManagedJobImpl.this.getNextObjectToProcess(this);
                while (stats != null) {
                    JobException exception;
                    boolean fileProcessed;
                    block40: {
                        Object object;
                        fileProcessed = false;
                        ManagedJobImpl managedJobImpl = ManagedJobImpl.this;
                        synchronized (managedJobImpl) {
                            if (ManagedJobImpl.this.getJob().getLoadSchedule().inLowLoadTimeWindow() != ManagedJobImpl.this.inLowLoadTimeWindow) {
                                ManagedJobImpl.this.refreshThreadLoad(true);
                                ManagedJobImpl.this.inLowLoadTimeWindow = ManagedJobImpl.this.getJob().getLoadSchedule().inLowLoadTimeWindow();
                            } else {
                                ManagedJobImpl.this.refreshThreadLoad();
                            }
                        }
                        exception = null;
                        try {
                            if (this.die) break block40;
                            if (ManagedJobImpl.this.includeInStats(stats)) {
                                object = ManagedJobImpl.this.statsLock;
                                synchronized (object) {
                                    ManagedJobImpl.this.objectsProcessing.add(stats);
                                }
                            }
                            fileProcessed = true;
                            fileAction.processFile(stats);
                        }
                        catch (JobException e) {
                            exception = e;
                        }
                        finally {
                            if (ManagedJobImpl.this.includeInStats(stats)) {
                                object = ManagedJobImpl.this.statsLock;
                                synchronized (object) {
                                    ManagedJobImpl.this.objectsProcessing.remove(stats);
                                }
                            }
                        }
                    }
                    if (fileProcessed && (exception == null || ManagedJobImpl.this.treatAsSuccess(exception.getStatusCode()))) {
                        ManagedJobImpl.this.completeObject(stats, exception == null ? null : exception.getStatusCode());
                        ++this.numOfFilesCopied;
                    } else if (this.die) {
                        LOG.log(Level.FINE, "Got exception while dying", exception);
                    } else {
                        ManagedJobImpl.this.failObject(stats, exception, exception == null ? null : exception.getStatusCode(), false, true);
                    }
                    if (this.die) {
                        THREADLOG.log(Level.INFO, "FileProcessingThread: " + this + " asked to die. It has finished its current work so we are letting thread die.");
                        break;
                    }
                    stats = ManagedJobImpl.this.getNextObjectToProcess(this);
                }
                List<ProcessFileThread> fileProcessed = ManagedJobImpl.this.fileProcessorWorkers;
                synchronized (fileProcessed) {
                    ManagedJobImpl.this.fileProcessorWorkers.remove(this);
                }
                THREADLOG.log(Level.INFO, "FileProcessingThread complete: {0}, Number of files copied by this thread: " + this.numOfFilesCopied, this);
            }
            catch (Throwable t) {
                ManagedJobImpl.this.setJobException(t);
                String msg = "Unexpected exception received. Msg: " + t.getMessage();
                THREADLOG.log(Level.SEVERE, msg, t);
                try {
                    ManagedJobImpl.this.stopJob(JobStatus.FAILED, true, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                this.currentAction = null;
            }
        }

        @Override
        public String toString() {
            return "ProcessFileThread[id=" + this.getId() + ", name=" + this.getName() + ", state=" + (Object)((Object)this.getState()) + "] ";
        }
    }

    class StopJobThread
    extends Thread {
        StopJobThread() {
        }

        @Override
        public void run() {
            try {
                ManagedJobImpl.this.stopJob(JobStatus.PAUSED, true, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ShutdownHookThread
    extends Thread {
        ShutdownHookThread() {
        }

        @Override
        public void run() {
            long timeout = 10000L;
            shutdownHookObserved = true;
            StopJobThread stopJobThread = new StopJobThread();
            stopJobThread.start();
            try {
                stopJobThread.join(timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stopJobThread.isAlive()) {
                LOG.warning("ShutdownHook thread did not run to completion in " + timeout + " milliseconds; flushing in memory caches");
                try {
                    ManagedJobImpl.this.flushInMemoryCaches();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

