/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.jobs.JobSpec;
import com.archivas.clienttools.arcutils.api.jobs.MkdirJob;
import com.archivas.clienttools.arcutils.impl.JobImpl;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterMgr;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MkdirJobImpl
extends JobImpl {
    public static final String PACKAGE_NAME = MkdirJobImpl.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = MkdirJobImpl.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    Boolean mkdirResult = null;

    public MkdirJobImpl(JobId jobId, JobSpec jobSpec) {
        super(jobId, jobSpec);
    }

    protected MkdirJob getJob() {
        return (MkdirJob)this.getJobSpec();
    }

    protected AbstractProfileBase getProfile() {
        return ((MkdirJob)this.getJobSpec()).getProfile();
    }

    @Override
    protected void runJob() throws JobException {
        MkdirJob mySpec = this.getJob();
        this.setStartTime(new Date());
        LOG.log(Level.FINE, "{0}.runJob: ", new Object[]{CLASS_NAME, this});
        try {
            String targetPath = mySpec.getTargetPath();
            StorageAdapter targetAdapter = StorageAdapterMgr.getStorageAdapter(mySpec.getProfile());
            targetAdapter.mkdir(targetPath, null);
            this.mkdirResult = true;
        }
        catch (StorageAdapterException e) {
            JobException jobException = new JobException(this.getJobId(), e.getMessage(), e);
            this.setJobException(jobException);
            throw jobException;
        }
        catch (Exception e) {
            JobException jobException = new JobException(this.getJobId(), (Throwable)e);
            this.setJobException(jobException);
            throw jobException;
        }
    }

    @Override
    public Boolean getResult() {
        return this.mkdirResult;
    }
}

