/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobImpl;
import com.archivas.logging.DefaultFormatter;
import com.archivas.logging.FileHandler;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public abstract class ProgressLogger {
    private static final int INTERVAL_OFF = -1;
    private static final int DEFAULT_FILE_SIZE_BYTES = 10000000;
    private static final int DEFAULT_NUM_ROTATE_FILES = 5;
    private Logger logger = null;
    private boolean isLoggingAll = false;
    private int loggingIntervalMillis = -1;
    private long lastIntervalLogged = 0L;

    ProgressLogger(String defaultFilenamePattern) {
        LogManager manager = LogManager.getLogManager();
        String logFilenamePatternSettings = manager.getProperty(this.getClass().getName() + ".filenamePattern");
        String logFilenamePattern = logFilenamePatternSettings == null ? defaultFilenamePattern : logFilenamePatternSettings;
        String numRotateFilesSettings = manager.getProperty(this.getClass().getName() + ".numRotateFiles");
        int numRotateFiles = numRotateFilesSettings == null ? 5 : Integer.valueOf(numRotateFilesSettings);
        String fileSizeBytesSettings = manager.getProperty(this.getClass().getName() + ".fileSizeBytes");
        int fileSizeBytes = fileSizeBytesSettings == null ? 10000000 : Integer.valueOf(fileSizeBytesSettings);
        FileHandler fh = null;
        try {
            fh = new FileHandler(logFilenamePattern, fileSizeBytes, numRotateFiles, true);
            fh.setFormatter(new DefaultFormatter(DefaultFormatter.DEFAULT_PROGRESS_FORMAT));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logger = Logger.getLogger(this.getClass().getName());
        this.logger.addHandler(fh);
        this.logger.setUseParentHandlers(false);
    }

    public synchronized void setLogAll(boolean b) {
        this.isLoggingAll = b;
    }

    public synchronized void setLogIntervalSeconds(int i) {
        this.setLogAll(false);
        this.loggingIntervalMillis = i * 1000;
    }

    public synchronized void disableLogInterval() {
        this.loggingIntervalMillis = -1;
    }

    public synchronized void disableLogging() {
        this.setLogAll(false);
        this.disableLogInterval();
    }

    protected synchronized void log(String path, String extraPathInfo, long count, ManagedJob.Type jobType) {
        long rightNow;
        if (this.isLoggingAll) {
            this.logger.log(Level.INFO, path + (extraPathInfo == null ? "" : ", " + extraPathInfo));
        } else if (this.loggingIntervalMillis != -1 && (rightNow = System.currentTimeMillis()) - this.lastIntervalLogged > (long)this.loggingIntervalMillis) {
            this.logger.log(Level.INFO, this.getCountMsg(jobType, count));
            this.lastIntervalLogged = rightNow;
        }
    }

    protected abstract String getCountMsgPrefix(ManagedJob.Type var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logJobStarted(ManagedJobImpl jobImpl) {
        String msg = "Running or resuming job" + jobImpl.getJob().toString() + " with ID " + jobImpl.getJobId();
        ProgressLogger progressLogger = this;
        synchronized (progressLogger) {
            if (this.isLoggingAll || this.loggingIntervalMillis != -1) {
                this.logger.log(Level.INFO, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logJobStopped(ManagedJobImpl jobImpl, long finalCount) {
        String msg = "Stopped job" + jobImpl.getJob().toString() + " with ID " + jobImpl.getJobId() + ",  " + this.getCountMsg(jobImpl.getJob().getJobType(), finalCount);
        ProgressLogger progressLogger = this;
        synchronized (progressLogger) {
            if (this.isLoggingAll || this.loggingIntervalMillis != -1) {
                this.logger.log(Level.INFO, msg);
            }
        }
    }

    private String getCountMsg(ManagedJob.Type jobType, long count) {
        return this.getCountMsgPrefix(jobType) + Long.toString(count) + " total objects";
    }
}

