/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.jobs.JobSpec;
import com.archivas.clienttools.arcutils.api.jobs.RenameJob;
import com.archivas.clienttools.arcutils.impl.JobImpl;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterMgr;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import java.util.Date;
import java.util.logging.Logger;

public class RenameJobImpl
extends JobImpl {
    public static final String PACKAGE_NAME = RenameJobImpl.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = RenameJobImpl.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    Boolean renameResult = false;

    public RenameJobImpl(JobId jobId, JobSpec jobSpec) {
        super(jobId, jobSpec);
    }

    protected RenameJob getJob() {
        return (RenameJob)this.getJobSpec();
    }

    protected AbstractProfileBase getProfile() {
        return this.getJob().getProfile();
    }

    @Override
    protected void runJob() throws JobException {
        RenameJob mySpec = this.getJob();
        this.setStartTime(new Date());
        try {
            StorageAdapter adapter = StorageAdapterMgr.getStorageAdapter(this.getJob().getProfile());
            adapter.rename(mySpec.getBasePath(), mySpec.getCurrentName(), mySpec.getNewName());
            this.renameResult = true;
        }
        catch (StorageAdapterException e) {
            JobException jobException = new JobException(this.getJobId(), e.getMessage(), e);
            this.setJobException(jobException);
            throw jobException;
        }
    }

    @Override
    public Boolean getResult() {
        return this.renameResult;
    }
}

