/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.api.jobs.SetMetadataJob;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.jobs.FileStats;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobFileAction;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.SetMetadataSingleFileAction;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.model.ArcSetMetadataFile;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.Owner;
import com.archivas.clienttools.arcutils.utils.FileListParser;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobSchema;
import java.io.File;
import java.io.IOException;

public class SetMetadataJobImpl
extends ManagedJobImpl {
    public SetMetadataJobImpl(JobId jobId, SetMetadataJob deleteJob, ManagedJobSchema jobSchema) throws JobException {
        super(jobId, deleteJob, jobSchema);
    }

    public SetMetadataJob getSetMetadataJob() {
        return (SetMetadataJob)this.getJob();
    }

    @Override
    protected ManagedJobFileAction getManagedJobFileAction(ManagedJob managedJob, StorageAdapter sourceAdapter, StorageAdapter unused) {
        return new SetMetadataSingleFileAction(this, (SetMetadataJob)managedJob, sourceAdapter);
    }

    @Override
    protected ManagedJobFileAction getPostProcessFileAction(ManagedJob managedJob, StorageAdapter sourceAdapter, StorageAdapter targetAdapter) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean requiresFindFileSize() {
        return false;
    }

    @Override
    protected boolean requiresProcessingOfEmptyDirectories() {
        return false;
    }

    @Override
    protected boolean requiresPostProcessingOfDirectories() {
        return false;
    }

    @Override
    protected void doPostProcessing() throws JobException {
        throw new RuntimeException("Unsupported Operation");
    }

    @Override
    protected ArcProcessFile createArcProcessFileForDirectory(ArcProcessFile parentDir, ArcMoverFile moverFile) {
        ArcSetMetadataFile ret = new ArcSetMetadataFile(moverFile);
        ret.setParentDatabaseRecordId(parentDir.getDatabaseRecordId());
        return ret;
    }

    @Override
    protected ArcProcessFile createArcProcessFileForFile(ArcProcessFile processFile, ArcMoverFile moverFile, ManagedJob job) {
        return new ArcSetMetadataFile(moverFile);
    }

    @Override
    public void parseListFile() throws DatabaseException, IOException {
        File importFile = this.getJob().getListFile();
        if (importFile != null) {
            FileListParser.parseFile(importFile, this.getSetMetadataJob(), this.db);
        }
    }

    @Override
    protected boolean includeInStats(FileStats fileStats) {
        return !fileStats.getArcProcssFile().getSourceArcMoverFile().isDirectory();
    }

    @Override
    protected boolean treatAsSuccess(Integer statusCode) {
        return false;
    }

    @Override
    public boolean supportsConflictReports() {
        return false;
    }

    @Override
    public boolean validateJob() throws JobException {
        SetMetadataJob job = this.getSetMetadataJob();
        FileMetadata md = job.getIngestionMetadata();
        if (md == null) {
            throw new JobException("No metadata specified");
        }
        Owner owner = md.getOwner();
        if (owner != null && owner.getOwnerType().equals((Object)Owner.OwnerType.PROFILE) && job.getSourceProfile().isAnonymousAccess()) {
            throw new JobException("You cannot select the PROFILE owner type when the profile uses anonymous access");
        }
        return true;
    }
}

