/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.jobs.SetMetadataJob;
import com.archivas.clienttools.arcutils.config.ConfigurationHelper;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterRetryException;
import com.archivas.clienttools.arcutils.impl.jobs.CopySingleFileAction;
import com.archivas.clienttools.arcutils.impl.jobs.FileStats;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobFileAction;
import com.archivas.clienttools.arcutils.impl.jobs.SetMetadataJobImpl;
import com.archivas.clienttools.arcutils.model.ACLMetadata;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.CustomMetadata;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SetMetadataSingleFileAction
extends ManagedJobFileAction {
    public static Logger LOG = Logger.getLogger(CopySingleFileAction.class.getName());
    private final SetMetadataJobImpl jobImpl;
    private final SetMetadataJob mySpec;
    private final StorageAdapter adapter;

    public SetMetadataSingleFileAction(SetMetadataJobImpl jobImpl, SetMetadataJob mySpec, StorageAdapter adapter) {
        this.jobImpl = jobImpl;
        this.mySpec = mySpec;
        this.adapter = adapter;
    }

    @Override
    public void processFile(FileStats objToProcess) throws JobException {
        objToProcess.setRetries(objToProcess.getRetries() + 1);
        LOG.log(Level.FINE, "About to set metadata on: {0}", objToProcess.toDetailString());
        ArcMoverFile origFile = objToProcess.getArcProcssFile().getSourceFile();
        String path = origFile.isVersion() || origFile.getParent().isVersionList() ? origFile.getPath() : objToProcess.getSourcePath();
        int maxRetries = ConfigurationHelper.getIntegerProperty("managedJob.maxRetries", 3);
        FileMetadata metadata = this.mySpec.getIngestionMetadata();
        try {
            boolean done = false;
            int retries = 0;
            while (retries < maxRetries && !done) {
                ++retries;
                try {
                    ACLMetadata acl;
                    this.adapter.setMetadata(path, metadata);
                    this.adapter.close();
                    CustomMetadata cmd = metadata.getCustomMetadata();
                    if (cmd != null) {
                        if (cmd.isEmptyStringForm()) {
                            this.adapter.deleteCustomMetadata(path);
                        } else {
                            CopySingleFileAction.handleCustomMetadata(metadata, path, null, this.adapter, this.jobImpl);
                        }
                    }
                    if ((acl = metadata.getACL()) != null && this.adapter.getProfile().supportsACLs()) {
                        if (acl.isEmptyStringForm()) {
                            acl = ACLMetadata.newEmptyACL();
                        }
                        CopySingleFileAction.handleACL(acl, path, null, this.adapter, this.jobImpl);
                    }
                    done = true;
                }
                catch (StorageAdapterRetryException e) {
                    if (retries >= maxRetries) {
                        throw new JobException(null, "Failed to set object metadata after " + maxRetries + " retries.  Last retry failed due to: " + e.getMessage(), e);
                    }
                    LOG.log(Level.INFO, String.format("Error processing file %s, sleeping before retrying.  Msg: %s", path, e.getMessage()), e);
                    this.adapter.close();
                    this.waitForRetry(e.getRetryTime());
                }
                LOG.log(Level.FINE, "finished setting metadata for: {0}", objToProcess);
            }
        }
        catch (StorageAdapterException e) {
            JobException jobException = new JobException(null, e.getMessage(), e, e.getStatusCode());
            throw jobException;
        }
        finally {
            this.adapter.close();
        }
    }
}

