/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.jobs.ProgressLogger;

public class SuccessProgressLogger
extends ProgressLogger {
    private static SuccessProgressLogger instance = null;

    private SuccessProgressLogger() {
        super("_success%g.log");
        switch (HCPMoverProperties.LOGGING_SUCCESS_MODE.getAsTriState()) {
            case YES: {
                this.setLogAll(true);
                break;
            }
            case NO: {
                this.disableLogging();
                break;
            }
            default: {
                this.setLogIntervalSeconds(HCPMoverProperties.LOGGING_SUCCESS_PERIOD.getAsInt());
            }
        }
    }

    public static synchronized SuccessProgressLogger getInstance() {
        if (instance == null) {
            instance = new SuccessProgressLogger();
        }
        return instance;
    }

    public void log(String path, long count, ManagedJob.Type jobType) {
        this.log(path, null, count, jobType);
    }

    @Override
    protected String getCountMsgPrefix(ManagedJob.Type jobType) {
        String msgPrefix;
        switch (jobType) {
            case COPY: {
                msgPrefix = "Copied ";
                break;
            }
            case DELETE: {
                msgPrefix = "Deleted ";
                break;
            }
            case SET_METADATA: {
                msgPrefix = "Updated ";
                break;
            }
            default: {
                throw new RuntimeException("Unsupported job type: " + (Object)((Object)jobType));
            }
        }
        return msgPrefix;
    }
}

