/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl.jobs;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.jobs.JobSpec;
import com.archivas.clienttools.arcutils.api.jobs.VersionListingJob;
import com.archivas.clienttools.arcutils.impl.JobImpl;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VersionListingJobImpl
extends JobImpl {
    public static final String PACKAGE_NAME = VersionListingJobImpl.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = VersionListingJobImpl.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private ArcMoverDirectory dir = null;

    public VersionListingJobImpl(JobId jobId, JobSpec jobSpec) {
        super(jobId, jobSpec);
    }

    protected VersionListingJob getJob() {
        return (VersionListingJob)this.getJobSpec();
    }

    @Override
    protected void runJob() throws JobException {
        VersionListingJob mySpec = this.getJob();
        this.setStartTime(new Date());
        LOG.log(Level.FINE, "{0}.runJob: {1}", new Object[]{CLASS_NAME, this});
        this.setStartTime(new Date());
        try {
            String path = mySpec.getPath();
            if (path == null) {
                throw new IllegalArgumentException("Can not get version listing for a null url");
            }
            StorageAdapter adapter = mySpec.getAdapter();
            this.dir = adapter.getVersions(path);
            if (this.dir != null && LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, this.dir.toDetailString());
            }
        }
        catch (Exception e) {
            JobException jobException = new JobException(this.getJobId(), (Throwable)e);
            this.setJobException(jobException);
            throw jobException;
        }
    }

    @Override
    public Object getResult() {
        return this.dir;
    }
}

