/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.model;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterMgr;
import com.archivas.clienttools.arcutils.model.StructuredMetadata;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ACLMetadata
extends StructuredMetadata {
    private static final String CLASS_FULL_NAME = ACLMetadata.class.getName();
    private static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private static String EMPTY_ACL_STRING = "<accessControlList/>";

    public ACLMetadata(StructuredMetadata.Form form, String value) {
        super(form, value);
    }

    public ACLMetadata(String shortForm, String value) {
        this(StructuredMetadata.Form.valueOfShort(shortForm), value);
    }

    public static ACLMetadata newEmptyACL() {
        return new ACLMetadata(StructuredMetadata.Form.STRING, EMPTY_ACL_STRING);
    }

    @Override
    protected InputStream handleProfiledMetadata(AbstractProfileBase profile, StorageAdapter adapter) throws JobException {
        if (profile != null) {
            try {
                return adapter.getACLStream(this.value);
            }
            catch (StorageAdapterException e) {
                throw new JobException("Could not get ACL from file: " + this.value, (Throwable)e);
            }
        }
        LOG.log(Level.SEVERE, String.format("No profile provided for metadata for %s", this.value, profile));
        return null;
    }

    @Override
    protected String getProfiledMetadataString(AbstractProfileBase profile, Long version) throws JobException {
        try {
            StringBuilder builder = new StringBuilder();
            InputStream in = StorageAdapterMgr.getStorageAdapter(profile).getACLStream(this.value);
            InputStreamReader inReader = new InputStreamReader(in);
            BufferedReader reader = new BufferedReader(inReader);
            int c = reader.read();
            while (c >= 0) {
                builder.append((char)c);
                c = reader.read();
            }
            return builder.toString();
        }
        catch (StorageAdapterException e) {
            throw new JobException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JobException(e.getMessage(), (Throwable)e);
        }
    }
}

