/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.model;

import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.FileUtil;

public class ArcCopyFile
extends ArcProcessFile {
    private AbstractProfileBase targetProfile;
    private String targetPath;
    private String targetFilename;
    private FileMetadata ingestionMetadata;

    public ArcCopyFile() {
    }

    public ArcCopyFile(ArcMoverFile sourceFile, AbstractProfileBase targetProfile, String targetPath) {
        this(sourceFile, targetProfile, targetPath, sourceFile.getMetadata());
    }

    public ArcCopyFile(ArcMoverFile sourceFile, AbstractProfileBase targetProfile, String targetPath, FileMetadata ingestionMetadata) {
        super(sourceFile);
        if (targetPath == null && targetProfile != null || targetPath != null && targetProfile == null) {
            throw new IllegalArgumentException("Expected targetPath and targetProfile to both either be null or non-null");
        }
        this.targetProfile = targetProfile;
        this.targetPath = targetPath;
        this.ingestionMetadata = ingestionMetadata != null ? ingestionMetadata : sourceFile.getMetadata();
        if (targetPath != null) {
            this.targetFilename = FileUtil.getFilename(targetPath, targetProfile.getPathSeparator());
        }
    }

    public String getTargetFilename() {
        return this.targetFilename;
    }

    public String getDisplayTargetFilename() {
        return this.targetProfile.decode(this.getTargetFilename());
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public String getDisplayTargetPath() {
        return this.targetProfile.decode(this.getTargetPath());
    }

    public AbstractProfileBase getTargetProfile() {
        return this.targetProfile;
    }

    public FileMetadata getSourceMetadata() {
        ArcMoverFile sourceFile = this.getSourceFile();
        if (sourceFile != null) {
            return sourceFile.getMetadata();
        }
        return null;
    }

    public void setSourceMetadata(FileMetadata md) {
        this.getSourceFile().setMetadata(md);
    }

    public FileMetadata getIngestionMetadata() {
        return this.ingestionMetadata;
    }

    @Override
    public boolean equals(Object other) throws ClassCastException {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof ArcCopyFile)) {
            return false;
        }
        ArcCopyFile oCopyFile = (ArcCopyFile)other;
        return oCopyFile.getTargetPath().equals(this.getTargetPath()) && oCopyFile.getTargetProfile().getName().equals(this.getTargetProfile().getName());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.targetProfile != null ? this.targetProfile.getName().hashCode() : 0);
        result = 31 * result + (this.targetPath != null ? this.targetPath.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ArcCopyFile{");
        sb.append("source=").append(this.getSourceFile());
        sb.append(", destinationProfile=").append(this.targetProfile);
        sb.append(", destinationPath=").append(this.targetPath);
        sb.append(", ingestionMetadata=").append(this.ingestionMetadata);
        sb.append("}");
        return sb.toString();
    }
}

