/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.model;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.impl.adapter.BadElementException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.FileUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArcMoverDirectory
extends ArcMoverFile {
    public static final String PACKAGE_NAME = ArcMoverDirectory.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = ArcMoverDirectory.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private StorageAdapter storageAdapter;
    private List<ArcMoverFile> files = null;
    private boolean canRead = true;
    private boolean canWrite = true;
    private boolean isVersionList = false;
    private String fileSep;
    private boolean iterated = false;
    private int badElementCnt = 0;

    private ArcMoverDirectory(AbstractProfileBase profile, ArcMoverDirectory parent, String dirName, FileMetadata attrs, StorageAdapter storageAdapter) {
        super(profile, parent, dirName, attrs);
        this.fileSep = parent.getFileSep();
        this.storageAdapter = storageAdapter;
    }

    private ArcMoverDirectory(AbstractProfileBase profile, String dirName, FileMetadata attrs, String dirSepChar, StorageAdapter storageAdapter) {
        super(profile, dirName, attrs);
        this.fileSep = "" + dirSepChar;
        this.fileSep = this.fileSep.intern();
        this.storageAdapter = storageAdapter;
    }

    public static ArcMoverDirectory getDirInstance(AbstractProfileBase profile, String path, StorageAdapter storageAdapter) {
        if (profile == null) {
            throw new IllegalArgumentException("Parameter 'AbstractProfileBase profile' must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Parameter 'String path' must not be null");
        }
        ArcMoverDirectory dir = null;
        String dirSep = profile.getPathSeparator();
        assert (dirSep != null);
        String dirPath = FileUtil.converWindowsPathToUnix(path, dirSep);
        String[] dirParts = dirPath.split("/");
        if (dirParts.length < 1) {
            dir = new ArcMoverDirectory(profile, "", null, dirSep, storageAdapter);
        } else {
            ArcMoverDirectory parentDir = null;
            for (int i = 0; i < dirParts.length; ++i) {
                dir = parentDir == null ? new ArcMoverDirectory(profile, dirParts[i], null, dirSep, storageAdapter) : new ArcMoverDirectory(profile, parentDir, dirParts[i], null, storageAdapter);
                parentDir = dir;
            }
        }
        return dir;
    }

    public static ArcMoverDirectory getFileVersions(AbstractProfileBase profile, String path, StorageAdapter storageAdapter) {
        if (profile == null) {
            throw new IllegalArgumentException("Parameter 'AbstractProfileBase profile' must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Parameter 'String path' must not be null");
        }
        ArcMoverDirectory dir = ArcMoverDirectory.getDirInstance(profile, path, storageAdapter);
        dir.setVersionList(true);
        return dir;
    }

    public static ArcMoverDirectory getDirInstance(ArcMoverDirectory parent, String filename, FileMetadata attrs, StorageAdapter storageAdapter) {
        if (storageAdapter == null) {
            throw new IllegalArgumentException("Parameter 'StorageAdapter storageAdapter' must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Parameter 'ArcMoverDirectory parent' must not be null");
        }
        if (filename == null) {
            throw new IllegalArgumentException("Parameter 'String filename' must not be null");
        }
        ArcMoverDirectory dir = new ArcMoverDirectory(storageAdapter.getProfile(), parent, filename, attrs, storageAdapter);
        return dir;
    }

    public Iterator<ArcMoverFile> getFileListIterator(boolean includeDeleted, boolean supportsVersioning) throws StorageAdapterException {
        return this.storageAdapter.getFileListIterator(this, includeDeleted, supportsVersioning);
    }

    public List<ArcMoverFile> getFileList(int maxFiles) throws StorageAdapterException, JobException {
        this.badElementCnt = 0;
        int count = 0;
        ArrayList<ArcMoverFile> files = new ArrayList<ArcMoverFile>();
        Iterator<ArcMoverFile> iter = this.getFileListIterator(true, this.profile.supportsVersioning());
        while (iter.hasNext() && count++ < maxFiles) {
            try {
                ArcMoverFile f = iter.next();
                assert (f != null);
                files.add(f);
            }
            catch (NoSuchElementException e) {
                --count;
                LOG.log(Level.FINEST, "Unsupported object encountered, skipping.", e);
            }
            catch (BadElementException bee) {
                --count;
                ++this.badElementCnt;
                LOG.log(Level.FINEST, "Bad object encountered, skipping.", bee);
            }
        }
        return files;
    }

    public int getFileListBadElementCnt() {
        return this.badElementCnt;
    }

    @Override
    public AbstractProfileBase getProfile() {
        return this.profile;
    }

    @Override
    public String getPath() {
        String filename;
        String path = null;
        if (this.getParent() != null) {
            assert (this.getParent() != this);
            path = this.getParent().getPath();
        }
        if ((filename = this.getFileName()) == null) {
            filename = "";
        }
        if (!(path = path == null ? filename : FileUtil.resolvePath(path, filename, this.getFileSep())).endsWith(this.getFileSep()) && !this.isVersionList()) {
            path = path + this.getFileSep();
        }
        return path;
    }

    @Override
    public long getSize() {
        long size = 0L;
        if (this.files != null) {
            size = this.files.size();
        }
        return size;
    }

    public String getFileSep() {
        return this.fileSep;
    }

    public void abortASAP() {
        this.storageAdapter.abortASAP();
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    public boolean canRead() {
        return this.canRead;
    }

    @Override
    public boolean isVersionList() {
        return this.isVersionList;
    }

    public void setVersionList(boolean versionList) {
        this.isVersionList = versionList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArcMoverDirectory that = (ArcMoverDirectory)o;
        if (this.filename != null ? !this.filename.equals(that.filename) : that.filename != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        return this.profile.equals(that.profile);
    }

    @Override
    public int hashCode() {
        int result = this.filename != null ? this.filename.hashCode() : 0;
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 31 * result + this.profile.hashCode();
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ArcMoverDirectory");
        sb.append("{name=").append(this.getFileName());
        sb.append(", path=").append(this.getPath());
        sb.append(", isVersionList=").append(this.isVersionList());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String toDetailString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ArcMoverDirectory");
        sb.append("{").append(super.toDetailString());
        sb.append(", path=").append(this.getPath());
        sb.append(", isVersionList=").append(this.isVersionList());
        sb.append('}');
        sb.append(", files: ");
        return sb.toString();
    }
}

