/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.model;

import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFileDefaultComparator;
import com.archivas.clienttools.arcutils.model.ArcMoverSymlink;
import com.archivas.clienttools.arcutils.model.CustomMetadata;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.FileUtil;
import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.logging.Logger;

public class ArcMoverFile
implements Comparable<ArcMoverFile> {
    private static final String PACKAGE_NAME = ArcMoverFile.class.getPackage().getName();
    private static final String CLASS_FULL_NAME = ArcMoverFile.class.getName();
    private static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    private static final Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private boolean isPartOfInitList = false;
    private boolean isLatestVersion = true;
    public static final String EMPTYSTR = "";
    protected FileMetadata metadata = null;
    protected String filename = "";
    protected ArcMoverDirectory parent;
    protected AbstractProfileBase profile;

    protected ArcMoverFile(AbstractProfileBase profile, ArcMoverDirectory parent, String filename, FileMetadata attrs) {
        if (parent == null) {
            throw new IllegalArgumentException("Parameter 'ArcMoverDirectory parent' must not be null");
        }
        if (filename == null) {
            throw new IllegalArgumentException("Parameter 'String filename' must not be null");
        }
        if (profile == null) {
            throw new IllegalArgumentException("Null profile");
        }
        this.profile = profile;
        this.parent = parent;
        this.filename = filename;
        this.metadata = attrs;
        if (this.metadata == null) {
            this.metadata = new FileMetadata();
        }
    }

    protected ArcMoverFile(AbstractProfileBase profile, String filename, FileMetadata attrs) {
        if (profile == null) {
            throw new IllegalArgumentException("Null profile");
        }
        this.profile = profile;
        this.filename = filename;
        this.metadata = attrs;
        if (this.metadata == null) {
            this.metadata = new FileMetadata();
        }
    }

    public static ArcMoverFile getFileInstance(AbstractProfileBase profile, String origPath, FileMetadata attrs) {
        if (profile == null) {
            throw new IllegalArgumentException("Null profile");
        }
        ArcMoverFile retVal = null;
        String path = FileUtil.converWindowsPathToUnix(origPath, profile.getPathSeparator());
        String[] parts = FileUtil.splitFilenameFromPath(path);
        FileMetadata metadata = attrs;
        if (metadata == null) {
            metadata = new FileMetadata(FileType.UNKNOWN);
        }
        if (metadata.getFileType() == FileType.DIRECTORY) {
            retVal = ArcMoverDirectory.getDirInstance(profile, path, null);
            retVal.setMetadata(metadata);
        } else if (metadata.getFileType() == FileType.SYMLINK) {
            ArcMoverDirectory parent = ArcMoverDirectory.getDirInstance(profile, parts[0], null);
            retVal = new ArcMoverSymlink(profile, parent, parts[1], metadata, null);
        } else if (metadata.getFileType() == FileType.FILE) {
            ArcMoverDirectory parent = ArcMoverDirectory.getDirInstance(profile, parts[0], null);
            retVal = new ArcMoverFile(profile, parent, parts[1], metadata);
        } else {
            retVal = new ArcMoverFile(profile, path, metadata);
        }
        return retVal;
    }

    public void setIsPartOfInitList() {
        this.isPartOfInitList = true;
    }

    public boolean isPartOfInitList() {
        return this.isPartOfInitList;
    }

    public static ArcMoverFile getFileInstance(AbstractProfileBase profile, ArcMoverDirectory parent, String filename, FileMetadata attrs) {
        return new ArcMoverFile(profile, parent, filename, attrs);
    }

    public ArcMoverDirectory getParent() {
        return this.parent;
    }

    public int getPathDepth() {
        int parentDepth = this.parent == null ? 0 : this.parent.getPathDepth();
        return parentDepth + 1;
    }

    public AbstractProfileBase getProfile() {
        return this.profile;
    }

    public String getFileName() {
        return this.filename;
    }

    public String getDisplayFileName() {
        return this.getProfile().decode(this.filename);
    }

    public String getPath() {
        if (this.getFileType() == FileType.UNKNOWN) {
            return this.getFileName();
        }
        if (this.getParent().isVersionList()) {
            return this.getParent().getPath();
        }
        return this.getPathWithoutVersionString();
    }

    public String getDisplayPath() {
        return this.getProfile().decode(this.getPath());
    }

    public String getPathWithoutVersionString() {
        return FileUtil.resolvePath(this.getParent().getPath(), this.getFileName(), this.getParent().getFileSep());
    }

    public String getVersionString() {
        String versionString = EMPTYSTR;
        if (this.metadata.isVersion()) {
            versionString = new String("?version=" + this.metadata.getVersionNumber());
        } else if (this.metadata.isVersionList()) {
            versionString = new String("?version=list");
        }
        return versionString;
    }

    public String getRelativePath(String relativeToPath) {
        boolean hasBothSlashes;
        String baseProfilePath = relativeToPath;
        String currentPath = this.getPath();
        FileUtil.trimTrailingSlash(baseProfilePath);
        String relativePath = currentPath.substring(baseProfilePath.length(), currentPath.length());
        int forwardSlashLoc = relativePath.indexOf("\\");
        boolean hasForwardSlash = forwardSlashLoc >= 0;
        boolean bl = hasBothSlashes = hasForwardSlash && relativePath.indexOf("/") >= 0;
        if (!hasBothSlashes && hasForwardSlash) {
            relativePath = relativePath.replaceAll("\\\\", "/");
        }
        return relativePath;
    }

    public URL toURL() {
        URL url;
        try {
            File f = new File(this.getPath());
            url = f.toURI().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    public FileMetadata getMetadata() {
        return this.metadata;
    }

    public FileType getFileType() {
        return this.getMetadata().getFileType();
    }

    public void setSize(long size) {
        this.getMetadata().setSize(size);
    }

    public long getSize() {
        long size = 0L;
        if (this.getMetadata().hasSize()) {
            size = this.getMetadata().getSize();
        }
        return size;
    }

    public Date getModTime() {
        return this.getMetadata().getModTime();
    }

    public boolean isHidden() {
        return this.getMetadata().isHidden();
    }

    public boolean isLatestVersion() {
        return this.isLatestVersion;
    }

    public void setLatestVersion(boolean flag) {
        this.isLatestVersion = flag;
    }

    public boolean isUnknown() {
        return this.getFileType() == FileType.UNKNOWN;
    }

    public boolean isFile() {
        return this.getFileType() == FileType.FILE;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isSymlink() {
        return false;
    }

    public boolean isSymlinkToDirectory() {
        return false;
    }

    public boolean isSymlinkToFile() {
        return false;
    }

    public String getDisplaySymlinkTarget() {
        return this.getProfile().decode(this.metadata == null ? null : this.metadata.getSymlinkTarget());
    }

    public void setMetadata(FileMetadata metadata) {
        this.metadata = metadata;
    }

    public void setCustomMetadata(CustomMetadata metadata) {
        this.getMetadata().setCustomMetadata(metadata);
    }

    public CustomMetadata getCustomMetadata() {
        return this.getMetadata().getCustomMetadata();
    }

    public boolean hasCustomMetadata() {
        return this.getMetadata().hasCustomMetadata();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArcMoverFile that = (ArcMoverFile)o;
        if (!this.filename.equals(that.filename)) {
            return false;
        }
        return (this.parent != null || that.parent == null) && (this.parent == null || this.parent.equals(that.parent));
    }

    public int hashCode() {
        int result = this.filename.hashCode();
        if (this.parent != null) {
            result = 31 * result + this.parent.hashCode();
        }
        return result;
    }

    @Override
    public int compareTo(ArcMoverFile otherArcMoverFile) {
        return ArcMoverFileDefaultComparator.getInstance().compare(this, otherArcMoverFile);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CLASS_NAME);
        sb.append("{parent='").append(this.parent);
        sb.append(", name=").append(this.getFileName());
        sb.append(", path=").append(this.getPath());
        sb.append(", metadata=").append(this.metadata);
        sb.append('}');
        return sb.toString();
    }

    public String toDetailString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CLASS_NAME);
        sb.append("{parent='").append(this.parent);
        sb.append(", name=").append(this.getFileName());
        sb.append(", path=").append(this.getPath());
        sb.append(", metadata=").append(this.metadata);
        sb.append('}');
        return sb.toString();
    }

    public boolean isVersion() {
        return this.metadata.isVersion();
    }

    public boolean isVersionList() {
        return this.metadata.isVersionList();
    }

    public boolean isDeleted() {
        return this.metadata != null && this.metadata.hasRestState() && "deleted".equals(this.metadata.getRestState());
    }
}

