/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.model;

import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.FileUtil;
import java.util.logging.Logger;

public class ArcMoverSymlink
extends ArcMoverFile {
    public static final String PACKAGE_NAME = ArcMoverDirectory.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = ArcMoverDirectory.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private StorageAdapter storageAdapter;
    private String fileSep;

    public ArcMoverSymlink(AbstractProfileBase profile, ArcMoverDirectory parent, String symlinkName, FileMetadata metadata, StorageAdapter storageAdapter) {
        super(profile, parent, symlinkName, metadata);
        this.fileSep = parent.getFileSep();
        this.storageAdapter = storageAdapter;
    }

    public static ArcMoverSymlink getSymlinkInstance(ArcMoverDirectory parent, String symlinkName, String symlinkTarget, StorageAdapter storageAdapter) {
        if (parent == null) {
            throw new IllegalArgumentException("Parameter 'ArcMoverSymlink: parent' must not be null");
        }
        if (symlinkName == null) {
            throw new IllegalArgumentException("Parameter 'ArcMoverSymlink: symlinkName' must not be null");
        }
        if (storageAdapter == null) {
            throw new IllegalArgumentException("Parameter 'ArcMoverSymlink: storageAdapter' must not be null");
        }
        FileMetadata md = new FileMetadata(FileType.SYMLINK);
        md.setSymlinkTarget(symlinkTarget);
        ArcMoverSymlink link = new ArcMoverSymlink(storageAdapter.getProfile(), parent, symlinkName, md, storageAdapter);
        return link;
    }

    @Override
    public boolean isSymlink() {
        return true;
    }

    @Override
    public String getPath() {
        String filename;
        String path = null;
        if (this.getParent() != null) {
            path = this.getParent().getPath();
        }
        if ((filename = this.getFileName()) == null) {
            filename = "";
        }
        if (!(path = path == null ? filename : FileUtil.resolvePath(path, filename, this.getFileSep())).endsWith(this.getFileSep()) && !this.isVersionList()) {
            path = path + this.getFileSep();
        }
        return path;
    }

    public String getFileSep() {
        return this.fileSep;
    }

    public String getSymlinkTarget() {
        return this.getMetadata().getSymlinkTarget();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArcMoverSymlink that = (ArcMoverSymlink)o;
        if (this.filename != null ? !this.filename.equals(that.filename) : that.filename != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        return this.profile.equals(that.profile);
    }

    @Override
    public int hashCode() {
        int result = this.filename != null ? this.filename.hashCode() : 0;
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 31 * result + this.profile.hashCode();
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ArcMoverSymlink");
        sb.append("{name=").append(this.getFileName());
        sb.append(", path=").append(this.getPath());
        sb.append(", symlink-target=").append(this.getSymlinkTarget());
        sb.append('}');
        return sb.toString();
    }
}

