/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.model;

import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import java.io.Serializable;

public class ArcProcessFile
implements Serializable,
Comparable<ArcProcessFile> {
    private ArcMoverFile sourceFile;
    private long dbRecordId = -1L;
    private long parentDbRecordId = -1L;

    protected ArcProcessFile() {
    }

    public ArcProcessFile(ArcMoverFile sourceFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException("sourceFile == null");
        }
        this.sourceFile = sourceFile;
    }

    public ArcMoverFile getSourceFile() {
        return this.sourceFile;
    }

    public ArcMoverFile getSourceArcMoverFile() {
        return this.sourceFile;
    }

    public void setIsPartOfInitList() {
        this.sourceFile.setIsPartOfInitList();
    }

    public String getSourceFilename() {
        return this.sourceFile.getFileName();
    }

    public String getSourcePath() {
        return this.sourceFile.getPath();
    }

    public String getDisplaySourcePath() {
        return this.sourceFile.getDisplayPath();
    }

    public Long getSourceVersion() {
        if (this.sourceFile.isVersion()) {
            return this.sourceFile.getMetadata().getVersionNumber();
        }
        return null;
    }

    public AbstractProfileBase getSourceProfile() {
        return this.sourceFile.getProfile();
    }

    public boolean isFile() {
        return this.sourceFile.isFile();
    }

    public boolean isDirectory() {
        return this.sourceFile.isDirectory();
    }

    public boolean isSymlink() {
        return this.sourceFile.isSymlink();
    }

    public String getSymlinkTarget() {
        return this.sourceFile.getMetadata().getSymlinkTarget();
    }

    public long getSize() {
        return this.sourceFile.getSize();
    }

    public void setDatabaseRecordId(long recordId) {
        this.dbRecordId = recordId;
    }

    public long getDatabaseRecordId() {
        return this.dbRecordId;
    }

    public void setParentDatabaseRecordId(long recordId) {
        this.parentDbRecordId = recordId;
    }

    public long getParentDatabaseRecordId() {
        return this.parentDbRecordId;
    }

    public int getPathDepth() {
        return this.sourceFile.getPathDepth();
    }

    @Override
    public int compareTo(ArcProcessFile that) {
        return this.sourceFile.compareTo(that.sourceFile);
    }

    public boolean equals(Object other) throws ClassCastException {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ArcProcessFile)) {
            return false;
        }
        ArcProcessFile otherFile = (ArcProcessFile)other;
        return otherFile.sourceFile.equals(this.sourceFile);
    }

    public int hashCode() {
        return this.sourceFile != null ? this.sourceFile.hashCode() : 0;
    }
}

