/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.model;

import com.archivas.clienttools.arcutils.api.ArcMoverFactory;
import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.model.StructuredMetadata;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomMetadata
extends StructuredMetadata {
    private static final String CLASS_FULL_NAME = CustomMetadata.class.getName();
    private static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private final Long version;
    private String annotation = null;

    public CustomMetadata(StructuredMetadata.Form form, String value) {
        this(form, value, null);
    }

    public CustomMetadata(String shortForm, String value) {
        this(shortForm, value, null);
    }

    public CustomMetadata(StructuredMetadata.Form form, String value, Long version) {
        super(form, value);
        this.version = version;
    }

    public CustomMetadata(StructuredMetadata.Form form, String value, Long version, String annotation) {
        super(form, value);
        this.version = version;
        this.annotation = annotation;
    }

    public CustomMetadata(String shortForm, String value, Long version) {
        this(StructuredMetadata.Form.valueOfShort(shortForm), value, version);
    }

    @Override
    protected InputStream handleProfiledMetadata(AbstractProfileBase profile, StorageAdapter adapter) throws JobException {
        if (profile != null) {
            return ArcMoverFactory.getInstance().getCustomMetadataStream(profile, this.value, this.version, FileType.FILE, adapter, this.annotation);
        }
        LOG.log(Level.SEVERE, String.format("No profile provided for metadata for %s", this.value, profile));
        return null;
    }

    @Override
    protected String getProfiledMetadataString(AbstractProfileBase profile, Long version) throws JobException {
        String result = "";
        if (profile == null) {
            LOG.log(Level.SEVERE, String.format("No profile provided for metadata for %s", this.value, profile));
        } else {
            result = ArcMoverFactory.getInstance().getCustomMetadata(profile, this.value, version, FileType.FILE);
        }
        return result;
    }
}

