/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.model;

import com.archivas.clienttools.arcutils.model.ACLMetadata;
import com.archivas.clienttools.arcutils.model.CustomMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.model.Owner;
import com.archivas.clienttools.arcutils.model.Retention;
import com.archivas.clienttools.arcutils.utils.UidGidUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;

public class FileMetadata
implements Serializable {
    public static final String PACKAGE_NAME = FileMetadata.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = FileMetadata.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static final int DIRECTORY_FLAG = 16384;
    public static final int FILE_FLAG = 32768;
    public static final int SYMLINK_FLAG = 40960;
    private FileType fileType;
    private Date creationTime = null;
    private Date ctime = null;
    private Date modTime = null;
    private Date accessTime = null;
    private Long size = null;
    private Boolean hidden = null;
    private Integer fileMode = null;
    private Integer dirMode = null;
    private Long uid = null;
    private Long gid = null;
    private Long versionNumber = null;
    private Integer dpl = null;
    private String hashScheme = null;
    private String hashValue = null;
    private Boolean shred = null;
    private Boolean replicated = null;
    private Retention retention = null;
    private Boolean retentionHold = null;
    private Boolean searchIndex = null;
    private CustomMetadata customMetadata = null;
    private Hashtable<String, CustomMetadata> annotationList = null;
    private String restState = null;
    private boolean isVersion = false;
    private boolean isVersionList = false;
    private long versionNum = -1L;
    private ACLMetadata acl = null;
    private Owner owner = null;
    private String symlinkTarget = null;
    private FileType symlinkTargetType = null;

    public FileMetadata() {
        this(FileType.UNKNOWN);
    }

    public FileMetadata(FileType fileType) {
        this.fileType = fileType;
    }

    public FileMetadata(FileType fileType, Date creationTime, Date ctime, Date modTime, Date accessTime, Long size, Boolean hidden, Integer filePerms, Integer dirPerms, Long uid, Long gid, Long versionNumber, Integer dpl, String hashScheme, String hashValue, Boolean shred, Retention retention, Boolean retentionHold, Boolean searchIndex, Boolean replicated, ACLMetadata acl, Owner owner, CustomMetadata customMetadata) {
        this.fileType = fileType;
        this.creationTime = creationTime;
        this.ctime = ctime;
        this.modTime = modTime;
        this.accessTime = accessTime;
        this.size = size;
        this.hidden = hidden;
        this.setUid(uid);
        this.setGid(gid);
        this.versionNumber = versionNumber;
        this.dpl = dpl;
        this.hashScheme = hashScheme;
        this.hashValue = hashValue;
        this.shred = shred;
        this.retention = retention;
        this.retentionHold = retentionHold;
        this.searchIndex = searchIndex;
        this.replicated = replicated;
        this.acl = acl;
        this.owner = owner;
        this.customMetadata = customMetadata;
        this.dirMode = this.dirMode;
        this.fileMode = this.fileMode;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public boolean hasCreationTime() {
        return this.creationTime != null;
    }

    public Date getCtime() {
        return this.ctime;
    }

    public void setCtime(Date ctime) {
        this.ctime = ctime;
    }

    public boolean hasCtime() {
        return this.ctime != null;
    }

    public Date getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(Date accessTime) {
        this.accessTime = accessTime;
    }

    public boolean hasAccessTime() {
        return this.accessTime != null;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public boolean hasSize() {
        return this.size != null;
    }

    public Boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public boolean hasHidden() {
        return this.hidden != null;
    }

    public Integer getFileMode() {
        return this.fileMode;
    }

    public void setFileMode(Integer fileMode) {
        this.fileMode = fileMode;
    }

    public boolean hasFileMode() {
        return this.getFileMode() != null;
    }

    public Integer getDirMode() {
        return this.dirMode;
    }

    public void setDirMode(Integer dirMode) {
        this.dirMode = dirMode;
    }

    public boolean hasDirMode() {
        return this.getDirMode() != null;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = UidGidUtil.validateId(uid);
    }

    public void setUid(String uid) {
        this.uid = UidGidUtil.validateId(uid);
    }

    public boolean hasUid() {
        return this.getUid() != null;
    }

    public Long getGid() {
        return this.gid;
    }

    public void setGid(String gid) {
        this.gid = UidGidUtil.validateId(gid);
    }

    public void setGid(Long gid) {
        this.gid = UidGidUtil.validateId(gid);
    }

    public boolean hasGid() {
        return this.getGid() != null;
    }

    public Date getModTime() {
        return this.modTime;
    }

    public void setModTime(Date modTime) {
        this.modTime = modTime;
    }

    public boolean hasModTime() {
        return this.getModTime() != null;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }

    public boolean hasVersionNumber() {
        return this.versionNumber != null;
    }

    public Integer getDpl() {
        return this.dpl;
    }

    public void setDpl(Integer dpl) {
        this.dpl = dpl;
    }

    public boolean hasDpl() {
        return this.getDpl() != null;
    }

    public Integer getTpof() {
        if (this.hasDpl()) {
            return this.getDpl() - 1;
        }
        return null;
    }

    public boolean hasTpof() {
        return this.getDpl() != null;
    }

    public String getHashScheme() {
        return this.hashScheme;
    }

    public void setHashScheme(String hashScheme) {
        this.hashScheme = hashScheme;
    }

    public boolean hasHashScheme() {
        return this.getHashScheme() != null;
    }

    public String getHashValue() {
        return this.hashValue;
    }

    public void setHashValue(String hashValue) {
        this.hashValue = hashValue;
    }

    public boolean hasHashValue() {
        return this.getHashValue() != null;
    }

    public Boolean isShred() {
        return this.shred;
    }

    public void setShred(Boolean shred) {
        this.shred = shred;
    }

    public boolean hasShred() {
        return this.isShred() != null;
    }

    public Boolean isReplicated() {
        return this.replicated;
    }

    public void setReplicated(Boolean replicated) {
        this.replicated = replicated;
    }

    public boolean hasReplicated() {
        return this.isReplicated() != null;
    }

    public Boolean hasACL() {
        return this.acl != null;
    }

    public void setACL(ACLMetadata acl) {
        this.acl = acl;
    }

    public ACLMetadata getACL() {
        return this.acl;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public Retention getRetention() {
        return this.retention;
    }

    public void setRetention(Retention retention) {
        this.retention = retention;
    }

    public boolean hasRetention() {
        return this.retention != null;
    }

    public boolean hasNonDefaultRetention() {
        return this.retention != null && Retention.Type.DEFAULT != this.retention.getType();
    }

    public Boolean isRetentionHold() {
        return this.retentionHold;
    }

    public void setRetentionHold(Boolean retentionHold) {
        this.retentionHold = retentionHold;
    }

    public boolean hasRetentionHold() {
        return this.isRetentionHold() != null;
    }

    public Boolean isSearchIndex() {
        return this.searchIndex;
    }

    public void setSearchIndex(Boolean searchIndex) {
        this.searchIndex = searchIndex;
    }

    public boolean hasSearchIndex() {
        return this.isSearchIndex() != null;
    }

    public CustomMetadata getCustomMetadata() {
        return this.customMetadata;
    }

    public CustomMetadata getCustomMetadata(String annotation) {
        if (annotation == null) {
            return this.customMetadata;
        }
        if (this.annotationList.containsKey(annotation)) {
            return this.annotationList.get(annotation);
        }
        return null;
    }

    public void setCustomMetadata(CustomMetadata customMetadata) {
        this.customMetadata = customMetadata;
    }

    public boolean hasCustomMetadata() {
        return this.getCustomMetadata() != null;
    }

    public Hashtable<String, CustomMetadata> getAnnotationList() {
        return this.annotationList;
    }

    public void setAnnotationList(Hashtable<String, CustomMetadata> annotationList) {
        this.annotationList = annotationList;
    }

    public boolean hasAnnotations() {
        return this.getAnnotationList() != null;
    }

    public boolean hasDefaultCustomMetadata() {
        if (this.hasCustomMetadata()) {
            if (this.hasAnnotations()) {
                for (String annotation : this.getAnnotationList().keySet()) {
                    if (!annotation.equals("default")) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public String getRestState() {
        return this.restState;
    }

    public void setRestState(String restState) {
        this.restState = restState;
    }

    public boolean hasRestState() {
        return this.getRestState() != null;
    }

    public boolean isVersion() {
        return this.isVersion;
    }

    public boolean isVersionList() {
        return this.isVersionList;
    }

    public void setIsVersion(boolean isVersion) {
        this.isVersion = isVersion;
    }

    public void setIsVersionList(boolean isVersionList) {
        this.isVersionList = isVersionList;
    }

    public void setSymlinkTarget(String symlink_target) {
        this.symlinkTarget = symlink_target;
    }

    public String getSymlinkTarget() {
        return this.symlinkTarget;
    }

    public void setSymlinkTargetType(FileType targetType) {
        this.symlinkTargetType = targetType;
    }

    public FileType getSymlinkTargetType() {
        return this.symlinkTargetType;
    }

    public int getFileModeForDisplay() {
        return this.fileMode;
    }

    public String getFileModeForUnixLsDisplay() {
        String mode = null;
        if (this.getFileMode() != null) {
            mode = FileMetadata.getModeForUnixLsDisplay(this.getFileModeForDisplay());
        }
        return mode;
    }

    public int getDirModeForDisplay() {
        return this.dirMode;
    }

    public String getDirModeForUnixLsDisplay() {
        String mode = null;
        if (this.getDirMode() != null) {
            mode = FileMetadata.getModeForUnixLsDisplay(this.getDirModeForDisplay());
        }
        return mode;
    }

    public static int covertHCAPToUNIX(int displayMode, FileType fileType) {
        int mode = displayMode;
        switch (fileType) {
            case FILE: {
                mode -= 32768;
                break;
            }
            case DIRECTORY: {
                mode -= 16384;
                break;
            }
            case SYMLINK: {
                mode -= 40960;
            }
        }
        String s = Integer.toOctalString(mode);
        mode = Integer.parseInt(s);
        return mode;
    }

    public static String getModeForUnixLsDisplay(int mode) {
        StringBuffer sb = new StringBuffer();
        sb.append(FileMetadata.isUserReadable(mode) ? "r" : "-");
        sb.append(FileMetadata.isUserWritable(mode) ? "w" : "-");
        sb.append(FileMetadata.isUserExecutable(mode) ? "x" : "-");
        sb.append(FileMetadata.isGroupReadable(mode) ? "r" : "-");
        sb.append(FileMetadata.isGroupWritable(mode) ? "w" : "-");
        sb.append(FileMetadata.isGroupExecutable(mode) ? "x" : "-");
        sb.append(FileMetadata.isWorldReadable(mode) ? "r" : "-");
        sb.append(FileMetadata.isWorldWritable(mode) ? "w" : "-");
        sb.append(FileMetadata.isWorldExecutable(mode) ? "x" : "-");
        return sb.toString();
    }

    public static boolean isUserReadable(int mode) {
        return (mode / 100 % 10 & 4) > 0;
    }

    public static boolean isUserWritable(int mode) {
        return (mode / 100 % 10 & 2) > 0;
    }

    public static boolean isUserExecutable(int mode) {
        return (mode / 100 % 10 & 1) > 0;
    }

    public static boolean isGroupReadable(int mode) {
        return (mode / 10 % 10 & 4) > 0;
    }

    public static boolean isGroupWritable(int mode) {
        return (mode / 10 % 10 & 2) > 0;
    }

    public static boolean isGroupExecutable(int mode) {
        return (mode / 10 % 10 & 1) > 0;
    }

    public static boolean isWorldReadable(int mode) {
        return (mode % 10 & 4) > 0;
    }

    public static boolean isWorldWritable(int mode) {
        return (mode % 10 & 2) > 0;
    }

    public static boolean isWorldExecutable(int mode) {
        return (mode % 10 & 1) > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FileMetadata");
        sb.append("{object-type=" + this.fileType).append('\'');
        if (this.fileType == FileType.SYMLINK) {
            sb.append(", symlinkTargetType=" + this.symlinkTargetType).append('\'');
            sb.append(", symlink-target=" + this.symlinkTarget).append('\'');
        }
        sb.append(", change-time=" + this.creationTime).append('\'');
        sb.append(", update-time=" + this.modTime).append('\'');
        sb.append(", access-time=" + this.accessTime).append('\'');
        sb.append(", size=" + this.size).append('\'');
        sb.append(", hidden=" + this.hidden).append('\'');
        sb.append(", mode=" + this.fileMode).append('\'');
        sb.append(", uid=" + this.uid).append('\'');
        sb.append(", gid=" + this.gid).append('\'');
        sb.append(", version=" + this.versionNumber).append('\'');
        sb.append(", dpl=" + this.dpl).append('\'');
        sb.append(", hash-scheme=" + this.hashScheme).append('\'');
        sb.append(", hash-value=" + this.hashValue).append('\'');
        sb.append(", shred=" + this.shred).append('\'');
        sb.append(", retention-value=" + this.retention).append('\'');
        sb.append(", retention-hold=" + this.retentionHold).append('\'');
        sb.append(", index=" + this.searchIndex).append('\'');
        sb.append(", replicated=" + this.replicated).append('\'');
        sb.append(", customMetadata=" + this.customMetadata).append('\'');
        sb.append(", restState='").append(this.restState).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

