/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.model;

import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class LoadSchedule {
    private int normalLoadMaxConnCount;
    private int normalLoadMaxConnPerNodeCount;
    private boolean lowLoadEnabled;
    private Date lowLoadStartTime;
    private Date lowLoadEndTime;
    private int lowLoadMaxConnCount;
    private int lowLoadMaxConnPerNodeCount;
    private int maxConnFilesystem = HCPMoverProperties.MAXTHREADS_FILESYSTEM.getAsInt();
    public static SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
    private static final int NONE = 0;
    public static final int MAX_CONS_PER_SYSTEM_INT = HCPMoverProperties.MAX_LOAD_MAXTHREADS.getAsInt();
    public static final int MAX_CONS_PER_NODE_INT = HCPMoverProperties.MAX_LOAD_MAXTHREADS_PER_NODE.getAsInt();
    public static String NORMAL_LOAD_CONNECTIONS_PER_SYSTEM_NAME = "Normal Load Maximum Operations per System";
    public static String NORMAL_LOAD_CONNECTIONS_PER_NODE_NAME = "Normal Load Maximum Operations per Node";
    public static String LOW_LOAD_CONNECTIONS_PER_SYSTEM_NAME = "Reduced Load Maximum Operations per System";
    public static String LOW_LOAD_CONNECTIONS_PER_NODE_NAME = "Reduced Load Maximum Operations per Node";

    public LoadSchedule() {
    }

    public LoadSchedule(int normalLoadMaxConnCount, int normalLoadMaxConnPerNodeCount, boolean lowLoadEnabled, int lowLoadMaxConnCount, int lowLoadMaxConnPerNodeCount, Date lowLoadStartTime, Date lowLoadEndTime) {
        this.normalLoadMaxConnCount = normalLoadMaxConnCount;
        this.normalLoadMaxConnPerNodeCount = normalLoadMaxConnPerNodeCount;
        this.lowLoadEnabled = lowLoadEnabled;
        this.lowLoadMaxConnCount = lowLoadMaxConnCount;
        this.lowLoadMaxConnPerNodeCount = lowLoadMaxConnPerNodeCount;
        this.lowLoadStartTime = lowLoadStartTime;
        this.lowLoadEndTime = lowLoadEndTime;
    }

    public int getNormalLoadMaxConnCount() {
        return this.normalLoadMaxConnCount;
    }

    public void setNormalLoadMaxConnCount(int normalLoadMaxConnCount) {
        this.normalLoadMaxConnCount = normalLoadMaxConnCount;
    }

    public int getNormalLoadMaxConnPerNodeCount() {
        return this.normalLoadMaxConnPerNodeCount;
    }

    public void setNormalLoadMaxConnPerNodeCount(int normalLoadMaxConnPerNodeCount) {
        this.normalLoadMaxConnPerNodeCount = normalLoadMaxConnPerNodeCount;
    }

    public boolean isLowLoadEnabled() {
        return this.getLowLoadEnabled();
    }

    public boolean getLowLoadEnabled() {
        return this.lowLoadEnabled;
    }

    public void setLowLoadEnabled(boolean lowLoadEnabled) {
        this.lowLoadEnabled = lowLoadEnabled;
    }

    public int getLowLoadMaxConnCount() {
        return this.lowLoadMaxConnCount;
    }

    public void setLowLoadMaxConnCount(int lowLoadMaxConnCount) {
        this.lowLoadMaxConnCount = lowLoadMaxConnCount;
    }

    public int getLowLoadMaxConnPerNodeCount() {
        return this.lowLoadMaxConnPerNodeCount;
    }

    public void setLowLoadMaxConnPerNodeCount(int lowLoadMaxConnPerNodeCount) {
        this.lowLoadMaxConnPerNodeCount = lowLoadMaxConnPerNodeCount;
    }

    public int getMaxConnCount() {
        if (this.inLowLoadTimeWindow()) {
            return this.getLowLoadMaxConnCount();
        }
        return this.getNormalLoadMaxConnCount();
    }

    public int getMaxConnPerNodeCount() {
        if (this.inLowLoadTimeWindow()) {
            return this.getLowLoadMaxConnPerNodeCount();
        }
        return this.getNormalLoadMaxConnPerNodeCount();
    }

    public Date getLowLoadStartTime() {
        return this.lowLoadStartTime;
    }

    public void setLowLoadStartTime(Date lowLoadStartTime) {
        this.lowLoadStartTime = lowLoadStartTime;
    }

    public Date getLowLoadEndTime() {
        return this.lowLoadEndTime;
    }

    public void setLowLoadEndTime(Date lowLoadEndTime) {
        this.lowLoadEndTime = lowLoadEndTime;
    }

    public boolean inLowLoadTimeWindow() {
        Calendar currentTime = Calendar.getInstance();
        return this.inLowLoadTimeWindow(currentTime);
    }

    public boolean inLowLoadTimeWindow(Calendar currentTime) {
        if (!this.isLowLoadEnabled()) {
            return false;
        }
        Calendar startTime = (Calendar)currentTime.clone();
        Calendar endTime = (Calendar)currentTime.clone();
        boolean reverse = this.getLowLoadEndTime().before(this.getLowLoadStartTime());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getLowLoadStartTime());
        int startLowLoadHour = cal.get(11);
        int startLowLoadMin = cal.get(12);
        cal.setTime(this.getLowLoadEndTime());
        int endLowLoadHour = cal.get(11);
        int endLowLoadMin = cal.get(12);
        startTime.set(11, startLowLoadHour);
        startTime.set(12, startLowLoadMin);
        startTime.set(13, 0);
        endTime.set(11, endLowLoadHour);
        endTime.set(12, endLowLoadMin);
        endTime.set(13, 0);
        if (reverse) {
            if (endTime.before(currentTime)) {
                endTime.add(5, 1);
            } else {
                startTime.add(5, -1);
            }
        }
        boolean within = currentTime.after(startTime) && currentTime.before(endTime);
        return within;
    }

    public int getMaxConnFilesystem() {
        return this.maxConnFilesystem;
    }

    public void setMaxConnFilesystem(int maxConnFilesystem) {
        this.maxConnFilesystem = maxConnFilesystem;
    }

    public static void setDefaultLoadSchedule(LoadSchedule loadSchedule) {
        loadSchedule.validate();
        HCPMoverProperties.NORMAL_LOAD_MAXTHREADS.set(loadSchedule.getNormalLoadMaxConnCount());
        HCPMoverProperties.NORMAL_LOAD_MAXTHREADS_PER_NODE.set(loadSchedule.getNormalLoadMaxConnPerNodeCount());
        HCPMoverProperties.LOW_LOAD_ENABLED.set(loadSchedule.isLowLoadEnabled());
        HCPMoverProperties.LOW_LOAD_START_TIME.set(timeFormat.format(loadSchedule.getLowLoadStartTime()));
        HCPMoverProperties.LOW_LOAD_END_TIME.set(timeFormat.format(loadSchedule.getLowLoadEndTime()));
        HCPMoverProperties.LOW_LOAD_MAXTHREADS.set(loadSchedule.getLowLoadMaxConnCount());
        HCPMoverProperties.LOW_LOAD_MAXTHREADS_PER_NODE.set(loadSchedule.getLowLoadMaxConnPerNodeCount());
    }

    public void validate() throws IllegalArgumentException {
        int normalLoadNodeMax = Math.min(MAX_CONS_PER_NODE_INT, this.normalLoadMaxConnCount);
        int lowLoadNodeMax = Math.min(MAX_CONS_PER_NODE_INT, this.lowLoadMaxConnCount);
        if (0 >= this.normalLoadMaxConnCount || this.normalLoadMaxConnCount > MAX_CONS_PER_SYSTEM_INT) {
            throw new IllegalArgumentException(String.format("Invalid value for %s:\nMust be between 1 and %s.", NORMAL_LOAD_CONNECTIONS_PER_SYSTEM_NAME, MAX_CONS_PER_SYSTEM_INT));
        }
        if (0 >= this.normalLoadMaxConnPerNodeCount || this.normalLoadMaxConnPerNodeCount > normalLoadNodeMax) {
            throw new IllegalArgumentException(String.format("Invalid value for %s:\nMust be between 1 and %s and may not exceed %s.", NORMAL_LOAD_CONNECTIONS_PER_NODE_NAME, MAX_CONS_PER_NODE_INT, NORMAL_LOAD_CONNECTIONS_PER_SYSTEM_NAME));
        }
        if (0 >= this.lowLoadMaxConnCount || this.lowLoadMaxConnCount > MAX_CONS_PER_SYSTEM_INT) {
            throw new IllegalArgumentException(String.format("Invalid value for %s:\nMust be between 1 and %s.", LOW_LOAD_CONNECTIONS_PER_SYSTEM_NAME, MAX_CONS_PER_SYSTEM_INT));
        }
        if (0 >= this.lowLoadMaxConnPerNodeCount || this.lowLoadMaxConnPerNodeCount > lowLoadNodeMax) {
            throw new IllegalArgumentException(String.format("Invalid value for %s:\nMust be between 1 and %s and may not exceed %s.", LOW_LOAD_CONNECTIONS_PER_NODE_NAME, MAX_CONS_PER_NODE_INT, LOW_LOAD_CONNECTIONS_PER_SYSTEM_NAME));
        }
    }

    public static LoadSchedule getDefaultLoadSchedule() {
        Date endTime;
        Date startTime;
        LoadSchedule ls = new LoadSchedule();
        ls.setNormalLoadMaxConnCount(HCPMoverProperties.NORMAL_LOAD_MAXTHREADS.getAsInt());
        ls.setNormalLoadMaxConnPerNodeCount(HCPMoverProperties.NORMAL_LOAD_MAXTHREADS_PER_NODE.getAsInt());
        ls.setLowLoadEnabled(HCPMoverProperties.LOW_LOAD_ENABLED.getAsBoolean());
        ls.setLowLoadMaxConnCount(HCPMoverProperties.LOW_LOAD_MAXTHREADS.getAsInt());
        ls.setLowLoadMaxConnPerNodeCount(HCPMoverProperties.LOW_LOAD_MAXTHREADS_PER_NODE.getAsInt());
        try {
            startTime = timeFormat.parse(HCPMoverProperties.LOW_LOAD_START_TIME.get());
        }
        catch (ParseException e) {
            startTime = new Date(0L);
        }
        try {
            endTime = timeFormat.parse(HCPMoverProperties.LOW_LOAD_END_TIME.get());
        }
        catch (ParseException e) {
            endTime = new Date(0L);
        }
        ls.setLowLoadStartTime(startTime);
        ls.setLowLoadEndTime(endTime);
        return ls;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LoadSchedule");
        sb.append("{normalLoadMaxConnCount=").append(this.normalLoadMaxConnCount);
        sb.append(", normalLoadMaxConnPerNodeCount=").append(this.normalLoadMaxConnPerNodeCount);
        sb.append(", lowLoadEnabled=").append(this.lowLoadEnabled);
        sb.append(", lowLoadStartTime=").append(this.lowLoadStartTime);
        sb.append(", lowLoadEndTime=").append(this.lowLoadEndTime);
        sb.append(", lowLoadMaxConnCount=").append(this.lowLoadMaxConnCount);
        sb.append(", lowLoadMaxConnPerNodeCount=").append(this.lowLoadMaxConnPerNodeCount);
        sb.append(", maxConnFilesystem=").append(this.maxConnFilesystem);
        sb.append('}');
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            Date d1 = timeFormat.parse("08:00");
            Date d2 = timeFormat.parse("20:00");
            LoadSchedule load = new LoadSchedule(50, 200, true, 10, 3, d1, d2);
            Date testDate = timeFormat.parse("09:00");
            Calendar cal = Calendar.getInstance();
            cal.setTime(testDate);
            boolean result = load.inLowLoadTimeWindow(cal);
            System.out.println("Expected result of true.  Result = " + result);
            testDate = timeFormat.parse("07:00");
            cal.setTime(testDate);
            result = load.inLowLoadTimeWindow(cal);
            System.out.println("Expected result of false.  Result = " + result);
            testDate = timeFormat.parse("21:00");
            cal.setTime(testDate);
            result = load.inLowLoadTimeWindow(cal);
            System.out.println("Expected result of false.  Result = " + result);
            d1 = timeFormat.parse("20:00");
            d2 = timeFormat.parse("08:00");
            load.setLowLoadStartTime(d1);
            load.setLowLoadEndTime(d2);
            testDate = timeFormat.parse("09:00");
            cal.setTime(testDate);
            result = load.inLowLoadTimeWindow(cal);
            System.out.println("Expected result of false.  Result = " + result);
            testDate = timeFormat.parse("19:00");
            cal.setTime(testDate);
            result = load.inLowLoadTimeWindow(cal);
            System.out.println("Expected result of false.  Result = " + result);
            testDate = timeFormat.parse("07:00");
            cal.setTime(testDate);
            result = load.inLowLoadTimeWindow(cal);
            System.out.println("Expected result of true.  Result = " + result);
            testDate = timeFormat.parse("21:00");
            cal.setTime(testDate);
            result = load.inLowLoadTimeWindow(cal);
            System.out.println("Expected result of true.  Result = " + result);
            d1 = timeFormat.parse("08:13");
            d2 = timeFormat.parse("08:33");
            load.setLowLoadStartTime(d1);
            load.setLowLoadEndTime(d2);
            testDate = timeFormat.parse("08:23");
            cal.setTime(testDate);
            result = load.inLowLoadTimeWindow(cal);
            System.out.println("Expected result of true.  Result = " + result);
            testDate = timeFormat.parse("08:03");
            cal.setTime(testDate);
            result = load.inLowLoadTimeWindow(cal);
            System.out.println("Expected result of false.  Result = " + result);
            testDate = timeFormat.parse("08:43");
            cal.setTime(testDate);
            result = load.inLowLoadTimeWindow(cal);
            System.out.println("Expected result of false.  Result = " + result);
            d1 = timeFormat.parse("08:33");
            d2 = timeFormat.parse("08:13");
            load.setLowLoadStartTime(d1);
            load.setLowLoadEndTime(d2);
            testDate = timeFormat.parse("08:23");
            cal.setTime(testDate);
            result = load.inLowLoadTimeWindow(cal);
            System.out.println("Expected result of false.  Result = " + result);
            testDate = timeFormat.parse("08:03");
            cal.setTime(testDate);
            result = load.inLowLoadTimeWindow(cal);
            System.out.println("Expected result of true.  Result = " + result);
            testDate = timeFormat.parse("08:43");
            cal.setTime(testDate);
            result = load.inLowLoadTimeWindow(cal);
            System.out.println("Expected result of true.  Result = " + result);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

