/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.model;

import com.archivas.clienttools.arcmover.cli.ArcProfileMgr;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Owner {
    public static final String PACKAGE_NAME = ArcProfileMgr.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = ArcProfileMgr.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private OwnerType ownerType;
    private String domain;
    private String ownerName;

    public Owner(String ownerName) {
        this.ownerType = OwnerType.LOCAL;
        this.ownerName = ownerName;
    }

    public Owner(String ownerName, String domain) {
        this.ownerType = OwnerType.EXTERNAL;
        this.ownerName = ownerName;
        this.domain = domain;
    }

    public Owner(OwnerType type) {
        if (type.equals((Object)OwnerType.EXTERNAL) || type.equals((Object)OwnerType.LOCAL)) {
            throw new UnsupportedOperationException("Cannot create an owner for local or external without the extra fields");
        }
        this.ownerType = type;
    }

    public OwnerType getOwnerType() {
        return this.ownerType;
    }

    public String getDomain() {
        if (!this.ownerType.equals((Object)OwnerType.EXTERNAL)) {
            throw new UnsupportedOperationException("Cannot get the domain for a non external user");
        }
        return this.domain;
    }

    public String getOwnerName() {
        if (!this.ownerType.equals((Object)OwnerType.EXTERNAL) && !this.ownerType.equals((Object)OwnerType.LOCAL)) {
            throw new UnsupportedOperationException("Cannot get the user name for a non external or local user");
        }
        return this.ownerName;
    }

    public String createStringRepresentation() {
        String ownerString = this.ownerType.toString();
        return ownerString + ":" + (this.domain != null ? this.domain : "") + ":" + (this.ownerName != null ? this.ownerName : "");
    }

    public static Owner createFromStringRepresentation(String serializedForm) {
        try {
            if (serializedForm != null && serializedForm.length() > 0) {
                String[] splitForm = serializedForm.split(":", 2);
                OwnerType type = OwnerType.valueOf(splitForm[0]);
                switch (type) {
                    case LOCAL: {
                        String[] userAndNothing = splitForm[1].split(":", 2);
                        return new Owner(userAndNothing[1]);
                    }
                    case EXTERNAL: {
                        String[] userAndDomain = splitForm[1].split(":", 2);
                        return new Owner(userAndDomain[1], userAndDomain[0]);
                    }
                    case PUBLIC: 
                    case PROFILE: {
                        return new Owner(type);
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.WARNING, "Unexpected IllegalArgumentException when parsing owner string.", e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.log(Level.WARNING, "Unexpected ArrayIndexOutOfBoundsException when parsing owner string.", e);
        }
        return null;
    }

    public static enum OwnerType {
        PUBLIC("No Owner"),
        LOCAL("Local User"),
        EXTERNAL("External User"),
        PROFILE("Profile User");

        private String uiName;

        private OwnerType(String uiName) {
            this.uiName = uiName;
        }

        public String getUIName() {
            return this.uiName;
        }
    }
}

