/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.model;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class Retention
implements Serializable {
    public static final String DATE_FORMAT_STRING = "MM/dd/yyyy HH:mm a";
    private Type type;
    protected String uiValue;
    private String hcapValue;
    private String className;
    private transient int years;
    private transient int months;
    private transient int days;
    private transient Date date;
    public static final Retention DEFAULT = new Retention();
    public static final Retention DELETION_ALLOWED = new Retention(Type.SPECIAL_VALUE, SpecialValueType.DELETION_ALLOWED.uiName(), SpecialValueType.DELETION_ALLOWED.hcapValue());
    public static final Retention DELETION_PROHIBITED = new Retention(Type.SPECIAL_VALUE, SpecialValueType.DELETION_PROHIBITED.uiName(), SpecialValueType.DELETION_PROHIBITED.hcapValue());
    public static final Retention INITIAL_UNSPECIFIED = new Retention(Type.SPECIAL_VALUE, SpecialValueType.INITIAL_UNSPECIFIED.uiName(), SpecialValueType.INITIAL_UNSPECIFIED.hcapValue());

    public Type getType() {
        return this.type;
    }

    public String getUIValue() {
        return this.uiValue;
    }

    public String getHCAPValue() {
        return this.hcapValue;
    }

    public String getClassName() {
        return this.className;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public Date getDate() {
        return this.date;
    }

    protected Retention() {
        this.type = Type.DEFAULT;
        this.uiValue = this.type.uiName();
        this.hcapValue = "";
        this.className = "";
    }

    protected Retention(Type type, String uiValue, String hcapValue) {
        this.type = type;
        this.uiValue = uiValue;
        this.hcapValue = hcapValue;
        if (type == Type.RETENTION_CLASS) {
            this.className = uiValue;
        } else {
            this.className = "";
            this.parseOffset();
            this.parseDate();
        }
    }

    protected Retention(String className, String hcapValue, Date date) {
        this.type = Type.RETENTION_CLASS;
        this.hcapValue = hcapValue;
        this.uiValue = date.toString();
        this.className = className;
    }

    private void parseDate() {
        if (this.type != Type.FIXED_DATE) {
            return;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_STRING);
            this.date = formatter.parse(this.uiValue);
        }
        catch (Exception e) {
            this.type = Type.ADVANCED;
            this.uiValue = this.hcapValue;
        }
    }

    private void parseOffset() {
        if (this.type != Type.OFFSET) {
            return;
        }
        try {
            StringTokenizer st = new StringTokenizer(this.uiValue, PeriodUnits.YEARS.hcapName() + PeriodUnits.MONTHS.hcapName() + PeriodUnits.DAYS.hcapName(), true);
            while (st.hasMoreTokens()) {
                String valStr = st.nextToken();
                if (valStr.startsWith("+")) {
                    valStr = valStr.substring(1);
                }
                String delimStr = st.nextToken();
                if (PeriodUnits.YEARS.hcapName().equals(delimStr)) {
                    this.years = Integer.parseInt(valStr);
                    continue;
                }
                if (PeriodUnits.MONTHS.hcapName().equals(delimStr)) {
                    this.months = Integer.parseInt(valStr);
                    continue;
                }
                if (!PeriodUnits.DAYS.hcapName().equals(delimStr)) continue;
                this.days = Integer.parseInt(valStr);
            }
        }
        catch (Exception e) {
            this.type = Type.ADVANCED;
            this.uiValue = this.hcapValue;
        }
    }

    public static Retention fromFixedDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        String dateString = dateFormat.format(date);
        Long secondsOffset = date.getTime() / 1000L;
        String hcapDateString = secondsOffset.toString();
        return new Retention(Type.FIXED_DATE, dateString, hcapDateString);
    }

    public static Retention fromOffset(int years, int months, int days) {
        String uiValue = "" + years + PeriodUnits.YEARS.hcapName() + months + PeriodUnits.MONTHS.hcapName() + days + PeriodUnits.DAYS.hcapName();
        String hcapValue = "A+" + years + "y+" + months + "M+" + days + "d";
        return new Retention(Type.OFFSET, uiValue, hcapValue);
    }

    public static Retention createAdvanced(String value) {
        return new Retention(Type.ADVANCED, value, value);
    }

    public static Retention fromRetentionValueAndClass(long retention, String retentionClass) {
        Retention ret = Retention.fromRetentionClass(retentionClass, retention);
        if (ret == null) {
            ret = Retention.fromRetentionValue(retention);
        }
        return ret;
    }

    public static Retention fromRetentionValue(long value) {
        switch ((int)value) {
            case 0: {
                return DELETION_ALLOWED;
            }
            case -1: {
                return DELETION_PROHIBITED;
            }
            case -2: {
                return INITIAL_UNSPECIFIED;
            }
        }
        if (value < 0L) {
            return DEFAULT;
        }
        long miliseconds = value * 1000L;
        Date date = new Date(miliseconds);
        return Retention.fromFixedDate(date);
    }

    public static Retention fromRetentionClass(String retentionClass) {
        return Retention.fromRetentionClass(retentionClass, -1L);
    }

    public static Retention fromRetentionClass(String retentionClass, long retentionValue) {
        Retention result = null;
        if (retentionClass != null && retentionClass.length() > 0) {
            int commaLocation;
            String retentionClassName = retentionClass;
            if (retentionClass.startsWith("C+")) {
                retentionClassName = retentionClass.substring(2);
            }
            if ((commaLocation = retentionClass.indexOf(", ")) >= 0) {
                retentionClassName = retentionClassName.substring(1, commaLocation);
            }
            if (retentionValue >= 0L) {
                long miliseconds = retentionValue * 1000L;
                Date date = new Date(miliseconds);
                result = new Retention(retentionClassName, "C+" + retentionClassName, date);
            } else {
                result = new Retention(Type.RETENTION_CLASS, retentionClassName, "C+" + retentionClassName);
            }
        }
        return result;
    }

    public static Retention fromHcapValues(String retentionClass, String retentionValue) {
        Retention result = null;
        Retention classRetention = null;
        if (retentionClass != null && retentionClass.length() > 0) {
            classRetention = Retention.fromRetentionClass(retentionClass);
        }
        Retention valueRetention = null;
        if (retentionValue != null && retentionValue.length() > 0) {
            valueRetention = Retention.fromHcapValue(retentionValue);
        }
        if (classRetention != null) {
            if (valueRetention != null) {
                result = valueRetention;
                result.type = classRetention.type;
                result.className = classRetention.className;
                result.hcapValue = classRetention.hcapValue;
            } else {
                result = classRetention;
            }
        } else if (valueRetention != null) {
            result = valueRetention;
        }
        return result;
    }

    public static Retention fromHcapValue(String hcapValue) {
        if (hcapValue == null) {
            return null;
        }
        if (hcapValue.equals("")) {
            return new Retention();
        }
        try {
            long longValue = Long.parseLong(hcapValue);
            return Retention.fromRetentionValue(longValue);
        }
        catch (NumberFormatException numberFormatException) {
            if (hcapValue.startsWith("C+")) {
                return new Retention(Type.RETENTION_CLASS, hcapValue.substring(2), hcapValue);
            }
            if (hcapValue.startsWith("A+")) {
                return new Retention(Type.OFFSET, hcapValue.substring(2), hcapValue);
            }
            if (hcapValue.startsWith("R+")) {
                return new Retention(Type.OFFSET, hcapValue.substring(2), hcapValue);
            }
            return new Retention(Type.ADVANCED, hcapValue, hcapValue);
        }
    }

    public static Retention fromProperties(Type type, String uiValue, String hcapValue) {
        Retention retention = DEFAULT;
        switch (type) {
            default: {
                retention = DEFAULT;
                break;
            }
            case SPECIAL_VALUE: {
                SpecialValueType sv = SpecialValueType.fromHcapValue(hcapValue);
                switch (sv) {
                    case DELETION_ALLOWED: {
                        retention = DELETION_ALLOWED;
                        break;
                    }
                    case DELETION_PROHIBITED: {
                        retention = DELETION_PROHIBITED;
                        break;
                    }
                    case INITIAL_UNSPECIFIED: {
                        retention = INITIAL_UNSPECIFIED;
                    }
                }
                break;
            }
            case FIXED_DATE: 
            case OFFSET: 
            case RETENTION_CLASS: 
            case ADVANCED: {
                retention = new Retention(type, uiValue, hcapValue);
            }
        }
        return retention;
    }

    public String toString() {
        return "" + (Object)((Object)this.type) + ": " + this.hcapValue;
    }

    public static enum PeriodUnits {
        SECONDS("Second(s)", "s"),
        MINUTES("Minute(s)", "m"),
        HOURS("Hour(s)", "h"),
        DAYS("Day(s)", "d"),
        WEEKS("Week(s)", "w"),
        MONTHS("Month(s)", "M"),
        YEARS("Year(s)", "y");

        private final String uiName;
        private final String hcapName;

        private PeriodUnits(String uiName, String hcapName) {
            this.uiName = uiName;
            this.hcapName = hcapName;
        }

        public String uiName() {
            return this.uiName;
        }

        public String hcapName() {
            return this.hcapName;
        }
    }

    public static enum Type {
        DEFAULT("Use destination namespace setting"),
        SPECIAL_VALUE("Special Value"),
        FIXED_DATE("Fixed Date"),
        OFFSET("Offset"),
        RETENTION_CLASS("Retention Class"),
        ADVANCED("Advanced");

        private final String uiName;

        private Type(String uiName) {
            this.uiName = uiName;
        }

        public String uiName() {
            return this.uiName;
        }

        public static Type fromUIName(String uiName) {
            Type type = DEFAULT;
            if (uiName != null) {
                for (Type nextType : Type.values()) {
                    if (!nextType.uiName.equalsIgnoreCase(uiName)) continue;
                    type = nextType;
                    break;
                }
            }
            return type;
        }
    }

    public static enum SpecialValueType {
        DELETION_ALLOWED("Deletion Allowed", "0"),
        DELETION_PROHIBITED("Deletion Prohibited", "-1"),
        INITIAL_UNSPECIFIED("Initial Unspecified", "-2");

        private final String uiName;
        private final String hcapValue;

        private SpecialValueType(String uiName, String hcapValue) {
            this.uiName = uiName;
            this.hcapValue = hcapValue;
        }

        public String uiName() {
            return this.uiName;
        }

        public String hcapValue() {
            return this.hcapValue;
        }

        public static SpecialValueType fromUIName(String uiName) {
            SpecialValueType type = DELETION_ALLOWED;
            if (uiName != null) {
                for (SpecialValueType nextType : SpecialValueType.values()) {
                    if (!nextType.uiName.equalsIgnoreCase(uiName)) continue;
                    type = nextType;
                    break;
                }
            }
            return type;
        }

        public static SpecialValueType fromHcapValue(String hcapValue) {
            SpecialValueType type = DELETION_ALLOWED;
            if (hcapValue != null) {
                for (SpecialValueType nextType : SpecialValueType.values()) {
                    if (!nextType.hcapValue.equalsIgnoreCase(hcapValue)) continue;
                    type = nextType;
                    break;
                }
            }
            return type;
        }
    }
}

