/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.model;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.model.CustomMetadataTooLargeException;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class StructuredMetadata {
    private static final String CLASS_FULL_NAME = StructuredMetadata.class.getName();
    private static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    protected Form form = null;
    protected String value = null;

    public StructuredMetadata(Form form, String value) {
        if (form == null) {
            throw new IllegalArgumentException("Null form");
        }
        this.form = form;
        this.value = value;
    }

    public StructuredMetadata(String shortForm, String value) {
        this(Form.valueOfShort(shortForm), value);
    }

    protected abstract InputStream handleProfiledMetadata(AbstractProfileBase var1, StorageAdapter var2) throws JobException;

    public InputStream getStream(AbstractProfileBase profile, StorageAdapter adapter) throws JobException {
        InputStream result = null;
        switch (this.form) {
            case STRING: {
                result = new ByteArrayInputStream(this.value.getBytes());
                break;
            }
            case FILE: {
                try {
                    result = new FileInputStream(this.value);
                }
                catch (FileNotFoundException e) {
                    result = null;
                    LOG.log(Level.WARNING, String.format("Could not find file %s", this.value), e);
                }
                break;
            }
            case PROFILED: {
                result = this.handleProfiledMetadata(profile, adapter);
            }
        }
        return result;
    }

    protected abstract String getProfiledMetadataString(AbstractProfileBase var1, Long var2) throws JobException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringValue(AbstractProfileBase profile, Long version) throws JobException {
        String result = null;
        switch (this.form) {
            case STRING: {
                result = this.value;
                break;
            }
            case FILE: {
                LOG.log(Level.SEVERE, "FileSystemAdapter.getCustomMetadata() in use", new Exception("For debugging purposes only"));
                long maxCmdLength = HCPMoverProperties.CM_MAX_IN_MEMORY_SIZE.getAsLong();
                StringBuilder builder = new StringBuilder();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(new File(this.value)));
                    String line = reader.readLine();
                    while (line != null) {
                        builder.append(line);
                        line = reader.readLine();
                        if ((long)builder.length() <= maxCmdLength) continue;
                        CustomMetadataTooLargeException cmtle = new CustomMetadataTooLargeException();
                        throw new JobException(cmtle.getMessage(), (Throwable)cmtle);
                    }
                }
                catch (FileNotFoundException e) {
                    result = null;
                    LOG.log(Level.WARNING, String.format("Could not find file %s", this.value), e);
                }
                catch (IOException e) {
                    result = null;
                    LOG.log(Level.WARNING, String.format("Could not read file %s", this.value), e);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {}
                    }
                }
                result = builder.toString();
                break;
            }
            case PROFILED: {
                result = this.getProfiledMetadataString(profile, version);
            }
        }
        return result;
    }

    public String toString() {
        return String.format("%s, %s", new Object[]{this.form, this.value});
    }

    public Form getForm() {
        return this.form;
    }

    public boolean isEmptyStringForm() {
        return this.form == Form.STRING && (this.value == null || this.value.length() == 0);
    }

    public String getShortForm() {
        String shortForm = null;
        if (this.form != null) {
            shortForm = this.form.getShortForm();
        }
        return shortForm;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isLoad() {
        return this.form != Form.STRING;
    }

    public static enum Form {
        STRING("S"),
        FILE("F"),
        PROFILED("P");

        private String shortForm;

        private Form(String shortForm) {
            this.shortForm = shortForm;
        }

        public String getShortForm() {
            return this.shortForm;
        }

        public static Form valueOfShort(String shortForm) {
            Form form = null;
            for (Form f : Form.values()) {
                if (!f.shortForm.equalsIgnoreCase(shortForm)) continue;
                form = f;
                break;
            }
            return form;
        }
    }
}

