/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.profile;

import com.archivas.clienttools.arcmover.gui.profileadapter.FileSystemProfilePanelAdapter;
import com.archivas.clienttools.arcmover.gui.profileadapter.HcapProfilePanelAdapter;
import com.archivas.clienttools.arcmover.gui.profileadapter.Hcp3AuthNamepaceProfilePanelAdapter;
import com.archivas.clienttools.arcmover.gui.profileadapter.Hcp3DefaultNamespaceProfilePanelAdapter;
import com.archivas.clienttools.arcmover.gui.profileadapter.Hcp5AuthNamepaceProfilePanelAdapter;
import com.archivas.clienttools.arcmover.gui.profileadapter.ProfilePanelAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.profile.FileSystemProfile;
import com.archivas.clienttools.arcutils.profile.HCAPProfile;
import com.archivas.clienttools.arcutils.profile.Hcp3AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.Hcp3DefaultNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.Hcp5AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.ProfileType;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractProfileBase
implements Comparable<AbstractProfileBase> {
    private int id = -1;
    private String name = null;
    protected String displayedPath = "/";

    public AbstractProfileBase() {
    }

    protected AbstractProfileBase(int id) {
        this.id = id;
    }

    protected AbstractProfileBase(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Profile Name must not be NULL.");
        }
        this.name = name;
    }

    public abstract ProfileType getType();

    public abstract String getProtocol();

    public abstract String getRootPath();

    public abstract String getPathSeparator();

    public abstract String encode(String var1);

    public abstract String decode(String var1);

    public abstract boolean usesEncodedPaths();

    public abstract boolean supportsPosixSettings();

    public abstract boolean supportsOwner();

    public abstract boolean supportsACLs();

    public abstract boolean supportsAnnotations();

    public abstract boolean supportsIndexingSettings();

    public abstract boolean supportsRetentionClasses();

    public abstract boolean supportsVersioning() throws StorageAdapterException;

    public abstract boolean supportSymlinkRead();

    public abstract boolean supportsAuthorizationHeader();

    public String getDisplayPath() {
        return this.displayedPath;
    }

    public abstract SSLCertificateCallback getSSLExceptionCallback();

    public abstract void setSSLExceptionCallback(SSLCertificateCallback var1);

    public abstract SSLCertChain getSSLCertChain();

    public abstract void setSSLCertChain(SSLCertChain var1);

    public abstract String getHost() throws UnknownHostException;

    public abstract boolean isAuthNamespace();

    public abstract boolean isAnonymousAccess();

    public abstract boolean isValidateCustomMetadata();

    public void setDisplayPath(String displayedPath) {
        this.displayedPath = displayedPath;
    }

    public String resolvePath(String filename) {
        if (filename.startsWith("/")) {
            return filename.replaceFirst("/", this.getRootPath());
        }
        return this.getRootPath() + filename;
    }

    public Map<String, Object> toPropertyMap() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("type", (Object)this.getType());
        props.put("id", this.getId());
        props.put("name", this.getName());
        props.put("path", this.getDisplayPath());
        return props;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractProfileBase that = (AbstractProfileBase)o;
        if (this.id != that.id) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getName();
    }

    public String toDetailString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AbstractProfileBase.class.getName());
        sb.append("{id=").append(this.id);
        sb.append(", name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int compareTo(AbstractProfileBase other) {
        String myName = this.getName();
        String oName = other.getName();
        if (myName == null && oName == null) {
            return 0;
        }
        if (myName == null) {
            return -1;
        }
        if (oName == null) {
            return 1;
        }
        return myName.compareTo(oName);
    }

    public ProfilePanelAdapter makeAdapter() {
        switch (this.getType()) {
            case FILESYSTEM: {
                return new FileSystemProfilePanelAdapter((FileSystemProfile)this);
            }
            case HCP_DEFAULT: {
                return new Hcp3DefaultNamespaceProfilePanelAdapter((Hcp3DefaultNamespaceProfile)this);
            }
            case HCP: {
                return new Hcp3AuthNamepaceProfilePanelAdapter((Hcp3AuthNamespaceProfile)this);
            }
            case HCP60: 
            case HCP50: {
                return new Hcp5AuthNamepaceProfilePanelAdapter((Hcp5AuthNamespaceProfile)this);
            }
        }
        return new HcapProfilePanelAdapter((HCAPProfile)this);
    }
}

