/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.profile;

import com.archivas.clienttools.arcutils.config.ConfigurationException;
import com.archivas.clienttools.arcutils.config.ConfigurationHelper;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.ProfileType;
import com.archivas.clienttools.arcutils.utils.FileUtil;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileSystemProfile
extends AbstractProfileBase {
    private static final Logger LOG = Logger.getLogger(AbstractProfileBase.class.getName());
    public static final String DEFAULT_FILESYSTEM_PROFILE_NAME = "Local File System";
    public static final ProfileType HCAP_TYPE = ProfileType.FILESYSTEM;
    public static final String PROTOCOL = "file";
    public static String ROOT_PATH;
    public static final AbstractProfileBase LOCAL_FILESYSTEM_PROFILE;
    public static final String LOCAL_FILESYSTEM_PATH = "HCPMigrator.localFilesystemPath";
    private String path = null;

    private FileSystemProfile() {
        super(-1, DEFAULT_FILESYSTEM_PROFILE_NAME);
        File[] roots = File.listRoots();
        if (roots != null && roots.length == 1) {
            ROOT_PATH = roots[0].getPath();
        } else {
            File current = new File(System.getProperty("user.dir"));
            File root = current.getParentFile();
            while (root.getParentFile() != null) {
                root = root.getParentFile();
            }
            ROOT_PATH = root.getPath();
        }
        this.displayedPath = ConfigurationHelper.getStringProperty(LOCAL_FILESYSTEM_PATH, System.getProperty("user.home"));
    }

    @Override
    public ProfileType getType() {
        return HCAP_TYPE;
    }

    @Override
    public String getRootPath() {
        return ROOT_PATH;
    }

    @Override
    public String getPathSeparator() {
        return File.separator;
    }

    @Override
    public String encode(String unencoded) {
        return unencoded;
    }

    @Override
    public String decode(String encoded) {
        return encoded;
    }

    @Override
    public boolean usesEncodedPaths() {
        return false;
    }

    public URL getRootURL() throws MalformedURLException {
        return new URL(this.getProtocol(), null, this.getRootPath());
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }

    @Override
    public String getHost() {
        return null;
    }

    @Override
    public boolean supportsPosixSettings() {
        return false;
    }

    @Override
    public boolean supportsOwner() {
        return false;
    }

    @Override
    public boolean supportsACLs() {
        return false;
    }

    @Override
    public boolean supportsAnnotations() {
        return false;
    }

    @Override
    public boolean supportsAuthorizationHeader() {
        return false;
    }

    @Override
    public boolean isAuthNamespace() {
        return false;
    }

    @Override
    public boolean isAnonymousAccess() {
        return false;
    }

    @Override
    public boolean isValidateCustomMetadata() {
        return false;
    }

    @Override
    public boolean supportsIndexingSettings() {
        return false;
    }

    @Override
    public boolean supportsRetentionClasses() {
        return false;
    }

    @Override
    public boolean supportsVersioning() {
        return false;
    }

    @Override
    public boolean supportSymlinkRead() {
        return true;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void setDisplayPath(String lastUsedPath) {
        super.setDisplayPath(lastUsedPath);
        try {
            ConfigurationHelper.setUserProperty(LOCAL_FILESYSTEM_PATH, lastUsedPath);
        }
        catch (ConfigurationException e) {
            LOG.log(Level.WARNING, "Error setting displayedPath.", e);
        }
    }

    @Override
    public String resolvePath(String filename) {
        if (filename.equals("/")) {
            return this.getRootPath();
        }
        if (filename.startsWith("/")) {
            filename = this.getRootPath() + filename.substring(1);
            boolean rooted = false;
            for (File root : File.listRoots()) {
                if (!filename.startsWith(root.getPath())) continue;
                rooted = true;
            }
            if (!rooted) {
                filename = this.getRootPath() + filename;
            }
        }
        filename = filename.replace("/", File.separator);
        return filename;
    }

    public URL getURL() throws MalformedURLException {
        URL location = null;
        File fileLocation = new File(this.getPath());
        if (!fileLocation.exists()) {
            fileLocation = new File(FileUtil.getStartPath());
        }
        location = fileLocation.toURI().toURL();
        return location;
    }

    @Override
    public SSLCertificateCallback getSSLExceptionCallback() {
        return null;
    }

    @Override
    public void setSSLExceptionCallback(SSLCertificateCallback callback) {
    }

    @Override
    public void setSSLCertChain(SSLCertChain sslCertChain) {
    }

    @Override
    public SSLCertChain getSSLCertChain() {
        return null;
    }

    static {
        LOCAL_FILESYSTEM_PROFILE = new FileSystemProfile();
    }
}

