/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.profile;

import com.archivas.clienttools.arcutils.api.ArcMoverFactory;
import com.archivas.clienttools.arcutils.impl.adapter.Hcap2Adapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.ProfileType;
import com.archivas.clienttools.arcutils.utils.RFC2396Encoder;
import com.archivas.clienttools.arcutils.utils.StringUtils;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import java.io.UnsupportedEncodingException;
import java.net.IDN;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class HCAPProfile
extends AbstractProfileBase {
    public static Logger LOG = Logger.getLogger(Hcap2Adapter.class.getName());
    public static final ProfileType HCAP_TYPE = ProfileType.HCAP2;
    public static final String PROTOCOL = "http";
    public static final String SSL_PROTOCOL = "https";
    public static final int PORT = 80;
    public static final int SSL_PORT = 443;
    public static final String ROOT_PATH = "/fcfs_data/";
    public static final int SC_ERROR_SETTING_METADATA = 601;
    private String hostname = null;
    private boolean isSSLRequired = false;
    private SSLCertChain sslCertChain = null;
    private SSLCertificateCallback sslCallback = null;
    private boolean connectByDns = true;
    private List<String> ipAddressList = null;
    private Integer port = null;
    private boolean isValidateCustomMetadata = true;

    @Override
    public boolean supportsVersioning() throws StorageAdapterException {
        return ArcMoverFactory.getInstance().isVersioningEnabled(this);
    }

    public HCAPProfile() {
    }

    public HCAPProfile(int id) {
        super(id);
    }

    public HCAPProfile(int id, String name, String hostname, boolean isValidateCustomMetadata, boolean isSSLRequired, boolean connectByDns, List<String> ipAddressList) {
        this(id, name, hostname, isValidateCustomMetadata, isSSLRequired, connectByDns, ipAddressList, null);
    }

    public HCAPProfile(int id, String name, String hostname, boolean isValidateCustomMetadata, boolean isSSLRequired, boolean connectByDns, List<String> ipAddressList, SSLCertChain sslCertChain) {
        super(id, name);
        this.hostname = hostname;
        this.isValidateCustomMetadata = isValidateCustomMetadata;
        this.isSSLRequired = isSSLRequired;
        this.sslCertChain = sslCertChain;
        this.connectByDns = connectByDns;
        this.ipAddressList = ipAddressList;
    }

    @Override
    public String getPathSeparator() {
        return "/";
    }

    @Override
    public String encode(String unencoded) {
        try {
            return RFC2396Encoder.encode(unencoded);
        }
        catch (UnsupportedEncodingException uee) {
            LOG.log(Level.WARNING, "Error encoding <" + unencoded + ">", uee);
            return unencoded;
        }
    }

    @Override
    public String decode(String encoded) {
        try {
            return encoded == null ? null : URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            LOG.log(Level.WARNING, "Error decoding <" + encoded + ">", uee);
            return encoded;
        }
    }

    @Override
    public boolean usesEncodedPaths() {
        return true;
    }

    @Override
    public Map<String, Object> toPropertyMap() {
        Map<String, Object> props = super.toPropertyMap();
        props.put("hostname", this.getHostname());
        props.put("isConnectByDns", this.isConnectByDns());
        props.put("ipAddressList", StringUtils.createCSV(this.getIpAddressList()));
        props.put("isSSLRequired", this.isSSLRequired());
        props.put("isValidateCustomMetadata", this.isValidateCustomMetadata());
        Integer port = this.getPort();
        if (port != null) {
            props.put("port", port);
        }
        return props;
    }

    @Override
    public String getHost() throws UnknownHostException {
        String host = null;
        List<String> ipAddresses = this.getHostAddresses();
        if (ipAddresses != null && ipAddresses.size() > 0) {
            int randomIndex = (int)(Math.random() * 100000.0) % ipAddresses.size();
            host = ipAddresses.get(randomIndex);
        }
        return host;
    }

    public List<String> getHostAddresses() throws UnknownHostException {
        List<String> ipAddresses;
        if (this.isConnectByDns()) {
            String host = this.getHostname();
            String prefix = this.getPrefix();
            if (!host.toLowerCase().startsWith(prefix)) {
                if (host.toLowerCase().startsWith("www.")) {
                    host = host.substring("www.".length());
                }
                host = prefix + host;
            }
            host = IDN.toASCII(host);
            InetAddress[] addrs = new InetAddress[]{};
            try {
                addrs = InetAddress.getAllByName(host);
            }
            catch (UnknownHostException e) {
                LOG.log(Level.WARNING, "Error getting addresses for host: " + host, e);
                throw e;
            }
            ipAddresses = new ArrayList<String>();
            for (int i = 0; i < addrs.length; ++i) {
                ipAddresses.add(addrs[i].getHostAddress());
            }
        } else {
            ipAddresses = this.getIpAddressList();
        }
        return ipAddresses;
    }

    protected abstract String getPrefix();

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public boolean isSSLRequired() {
        return this.isSSLRequired;
    }

    public void setSSLRequired(boolean SSLRequired) {
        this.isSSLRequired = SSLRequired;
    }

    @Override
    public boolean isValidateCustomMetadata() {
        return this.isValidateCustomMetadata;
    }

    public void setValidateCustomMetadata(boolean validateCustomMetadata) {
        this.isValidateCustomMetadata = validateCustomMetadata;
    }

    public boolean isConnectByDns() {
        return this.connectByDns;
    }

    public void setConnectByDns(boolean connectByDns) {
        this.connectByDns = connectByDns;
    }

    public List<String> getIpAddressList() {
        return this.ipAddressList;
    }

    public void setIpAddressList(List<String> ipAddressList) {
        this.ipAddressList = ipAddressList;
    }

    @Override
    public SSLCertificateCallback getSSLExceptionCallback() {
        return this.sslCallback;
    }

    @Override
    public void setSSLExceptionCallback(SSLCertificateCallback callback) {
        this.sslCallback = callback;
    }

    @Override
    public SSLCertChain getSSLCertChain() {
        return this.sslCertChain;
    }

    @Override
    public void setSSLCertChain(SSLCertChain sslCertChain) {
        this.sslCertChain = sslCertChain;
    }

    @Override
    public String getProtocol() {
        if (this.isSSLRequired()) {
            return SSL_PROTOCOL;
        }
        return PROTOCOL;
    }

    @Override
    public boolean supportSymlinkRead() {
        return false;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public int getPort() {
        int ret = this.port != null ? this.port : (this.isSSLRequired() ? 443 : 80);
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HCAPProfile that = (HCAPProfile)o;
        if (this.connectByDns != that.connectByDns) {
            return false;
        }
        if (this.isValidateCustomMetadata != that.isValidateCustomMetadata) {
            return false;
        }
        if (this.isSSLRequired != that.isSSLRequired) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.ipAddressList != null ? !this.ipAddressList.equals(that.ipAddressList) : that.ipAddressList != null) {
            return false;
        }
        return !(this.sslCertChain != null ? !this.sslCertChain.equals(that.sslCertChain) : that.sslCertChain != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        result = 31 * result + (this.isValidateCustomMetadata ? 1 : 0);
        result = 31 * result + (this.isSSLRequired ? 1 : 0);
        result = 31 * result + (this.sslCertChain != null ? this.sslCertChain.hashCode() : 0);
        result = 31 * result + (this.connectByDns ? 1 : 0);
        result = 31 * result + (this.ipAddressList != null ? this.ipAddressList.hashCode() : 0);
        return result;
    }

    @Override
    public String toDetailString() {
        return "HCAPMoverFCFSProfile{hostname='" + this.hostname + '\'' + ", isValidateCustomMetadata=" + this.isValidateCustomMetadata + ", isSSLRequired=" + this.isSSLRequired + ", connectByDns=" + this.connectByDns + ", ipAddressList=" + this.ipAddressList + "} " + super.toDetailString();
    }
}

