/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.profile;

import com.archivas.clienttools.arcutils.profile.HCAPProfile;
import com.archivas.clienttools.arcutils.profile.ProfileType;
import com.archivas.clienttools.arcutils.utils.EncryptionUtils;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.IDN;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;

public class Hcp3AuthNamespaceProfile
extends HCAPProfile
implements Serializable {
    public static final ProfileType HCAP_TYPE = ProfileType.HCP;
    public static final String ROOT_PATH = "/rest/";
    private static final String[] HEX_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private String tenant = null;
    private String namespace = null;
    private String username = "";
    private String password = "";

    public Hcp3AuthNamespaceProfile() {
    }

    protected Hcp3AuthNamespaceProfile(int id) {
        super(id);
    }

    protected Hcp3AuthNamespaceProfile(int id, String name, String hostname, boolean isValidateCustomMetadata, boolean isSSLRequired, boolean connectByDns, List<String> ipAddressList, String tenant, String namespace, String username, String password) {
        this(id, name, hostname, isValidateCustomMetadata, isSSLRequired, connectByDns, null, ipAddressList, tenant, namespace, username, password);
    }

    public Hcp3AuthNamespaceProfile(int id, String name, String hostname, boolean isValidateCustomMetadata, boolean SSLRequired, boolean connectByDns, SSLCertChain sslCertChain, List<String> ipAddressList, String tenant, String namespace, String username, String password) {
        super(id, name, hostname, isValidateCustomMetadata, SSLRequired, connectByDns, ipAddressList, sslCertChain);
        this.tenant = tenant;
        this.namespace = namespace;
        this.username = username;
        this.password = password;
    }

    @Override
    public ProfileType getType() {
        return HCAP_TYPE;
    }

    @Override
    public boolean supportsPosixSettings() {
        return false;
    }

    @Override
    public boolean supportsOwner() {
        return false;
    }

    @Override
    public boolean supportsACLs() {
        return false;
    }

    @Override
    public boolean supportsAnnotations() {
        return false;
    }

    @Override
    public boolean supportSymlinkRead() {
        return true;
    }

    @Override
    public boolean supportsAuthorizationHeader() {
        return false;
    }

    @Override
    public boolean isAuthNamespace() {
        return true;
    }

    @Override
    public boolean isAnonymousAccess() {
        return false;
    }

    @Override
    public boolean supportsRetentionClasses() {
        return true;
    }

    @Override
    public boolean supportsIndexingSettings() {
        return true;
    }

    @Override
    public String getRootPath() {
        return ROOT_PATH;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHostHeader() {
        String hostname = this.getHostname();
        String prefix = this.getPrefix();
        if (hostname.toLowerCase().startsWith("www.")) {
            hostname = hostname.substring("www.".length());
        }
        if (!hostname.startsWith(prefix)) {
            hostname = prefix + hostname;
        }
        hostname = IDN.toASCII(hostname);
        return hostname;
    }

    @Override
    public Map<String, Object> toPropertyMap() {
        Map<String, Object> props = super.toPropertyMap();
        props.put("tenant", this.getTenant());
        props.put("namespace", this.getNamespace());
        props.put("username", this.getUsername());
        EncryptionUtils eUtils = new EncryptionUtils();
        String encryptedPassword = eUtils.EncryptValue(this.getPassword());
        props.put("password", encryptedPassword);
        return props;
    }

    public static String getMD5Password(char[] originalPassword) {
        try {
            MessageDigest hasher = MessageDigest.getInstance("MD5");
            byte[] password = String.copyValueOf(originalPassword).getBytes("UTF-8");
            hasher.update(password);
            return Hcp3AuthNamespaceProfile.encodeBytes(hasher.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String encodeBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte ch = (byte)(bytes[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(HEX_DIGITS[ch]);
            ch = (byte)(bytes[i] & 0xF);
            out.append(HEX_DIGITS[ch]);
        }
        return out.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Hcp3AuthNamespaceProfile that = (Hcp3AuthNamespaceProfile)o;
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.tenant != null ? !this.tenant.equals(that.tenant) : that.tenant != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tenant != null ? this.tenant.hashCode() : 0);
        result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        return result;
    }

    @Override
    public String toDetailString() {
        return Hcp3AuthNamespaceProfile.class.getName() + "{tenant='" + this.tenant + '\'' + ", namespace='" + this.namespace + '\'' + ", username='" + this.username + '\'' + ", type='" + (Object)((Object)this.getType()) + '\'' + "} " + super.toString();
    }

    @Override
    protected String getPrefix() {
        return String.format("%s.%s.", this.namespace, this.tenant);
    }
}

