/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.profile;

import java.util.Iterator;
import java.util.Set;

public class ProfileInUseException
extends Exception {
    ProfileInUseException(Set<String> jobNames) {
        super(ProfileInUseException.constructMsg(jobNames));
    }

    private static String constructMsg(Set<String> jobNames) {
        StringBuilder sb = new StringBuilder("The profile is in use");
        if (jobNames == null || jobNames.isEmpty()) {
            sb.append(".");
        } else {
            Iterator<String> itr = jobNames.iterator();
            if (jobNames.size() == 1) {
                sb.append(" by saved job '").append(itr.next()).append("'");
            } else if (jobNames.size() <= 4) {
                sb.append(" by the following saved jobs:\n");
                while (itr.hasNext()) {
                    sb.append(itr.next()).append("\n");
                }
            } else {
                sb.append(" by ").append(jobNames.size()).append(" saved jobs, including:\n");
                for (int i = 0; i < 4; ++i) {
                    sb.append(itr.next()).append("\n");
                }
            }
        }
        return sb.toString();
    }
}

