/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.profile;

import com.archivas.clienttools.arcmover.gui.HistoryManager;
import com.archivas.clienttools.arcutils.config.ConfigurationException;
import com.archivas.clienttools.arcutils.config.ConfigurationHelper;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.FileSystemProfile;
import com.archivas.clienttools.arcutils.profile.HCAPProfile;
import com.archivas.clienttools.arcutils.profile.Hcap2Profile;
import com.archivas.clienttools.arcutils.profile.Hcp3AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.Hcp3DefaultNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.Hcp5AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.Hcp6AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.ProfileInUseException;
import com.archivas.clienttools.arcutils.profile.ProfileType;
import com.archivas.clienttools.arcutils.utils.EncryptionUtils;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobsSchema;
import com.archivas.clienttools.arcutils.utils.net.NetUtils;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProfileManager {
    public static Logger LOG = Logger.getLogger(ProfileManager.class.getPackage().getName());
    public static final String EMPTYSTR = "";
    public static final int LOCAL_FILESYSTEM_PROFILE_ID = -1;
    private static ProfileManager instance = null;
    private int maxProfileID = 0;
    private SSLCertificateCallback sslCallback;
    private Map<Integer, AbstractProfileBase> profiles = new LinkedHashMap<Integer, AbstractProfileBase>();
    public static final Comparator<AbstractProfileBase> PROFILE_NAME_COMPARATOR = new Comparator<AbstractProfileBase>(){

        @Override
        public int compare(AbstractProfileBase p1, AbstractProfileBase p2) {
            return String.CASE_INSENSITIVE_ORDER.compare(p1.getName(), p2.getName());
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    };

    private ProfileManager(SSLCertificateCallback callback) {
        this.sslCallback = callback;
        this.loadProfiles();
    }

    public static synchronized void initialize(SSLCertificateCallback callback) {
        instance = new ProfileManager(callback);
    }

    public static synchronized ProfileManager getInstance() {
        return instance;
    }

    private static synchronized boolean exists(int id) {
        return ProfileManager.getInstance().getProfileMap().get(id) != null;
    }

    public synchronized AbstractProfileBase createProfile(ProfileType type) {
        if (type == null) {
            throw new IllegalArgumentException("Creating profiles of type NULL is not valid.");
        }
        if (ProfileType.FILESYSTEM == type) {
            throw new IllegalArgumentException("Creating FILESYSTEM type profiles is not supported.");
        }
        AbstractProfileBase newProfile = null;
        try {
            block9: for (int i = 1; newProfile == null && i <= ProfileManager.getInstance().getMaxProfileID() + 1; ++i) {
                if (ProfileManager.exists(i)) continue;
                ProfileManager.getInstance().setMaxProfileID(Math.max(ProfileManager.getInstance().getMaxProfileID(), i));
                switch (type) {
                    case HCAP2: {
                        newProfile = new Hcap2Profile(i);
                        continue block9;
                    }
                    case HCP_DEFAULT: {
                        newProfile = new Hcp3DefaultNamespaceProfile(i);
                        continue block9;
                    }
                    case HCP: {
                        newProfile = new Hcp3AuthNamespaceProfile(i);
                        continue block9;
                    }
                    case HCP50: {
                        newProfile = new Hcp5AuthNamespaceProfile(i);
                        continue block9;
                    }
                    case HCP60: {
                        newProfile = new Hcp6AuthNamespaceProfile(i);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
        if (newProfile != null) {
            newProfile.setSSLExceptionCallback(this.sslCallback);
            LOG.log(Level.FINE, "Created Profile: " + newProfile.toDetailString());
            return newProfile;
        }
        throw new RuntimeException("Couldn't get next profile_id required to create Namespace Profile.  Max ID=" + ProfileManager.getInstance().getMaxProfileID());
    }

    private int getMaxProfileID() {
        return this.maxProfileID;
    }

    private void setMaxProfileID(int maxProfileID) {
        this.maxProfileID = maxProfileID;
    }

    private Map<Integer, AbstractProfileBase> getProfileMap() {
        return this.profiles;
    }

    public static synchronized List<AbstractProfileBase> getProfiles() {
        ArrayList<AbstractProfileBase> profiles = new ArrayList<AbstractProfileBase>(ProfileManager.getInstance().getProfileMap().values());
        Collections.sort(profiles, PROFILE_NAME_COMPARATOR);
        return profiles;
    }

    public static synchronized AbstractProfileBase getProfileByName(String profileName) {
        try {
            if (profileName == null || profileName.trim().length() < 1) {
                return null;
            }
            if ((profileName = profileName.trim()).equalsIgnoreCase(FileSystemProfile.LOCAL_FILESYSTEM_PROFILE.getName())) {
                return FileSystemProfile.LOCAL_FILESYSTEM_PROFILE;
            }
            for (AbstractProfileBase profile : ProfileManager.getInstance().getProfileMap().values()) {
                if (!profileName.equalsIgnoreCase(profile.getName())) continue;
                return profile;
            }
            return null;
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
    }

    public static synchronized boolean doesProfileNameExist(String profileName) {
        return ProfileManager.getProfileByName(profileName) != null;
    }

    protected synchronized void loadProfiles() {
        try {
            this.setMaxProfileID(ConfigurationHelper.getIntegerProperty("profile.highestId", 1));
            for (int i = 1; i <= this.maxProfileID; ++i) {
                AbstractProfileBase profile = this.loadProfile(i);
                if (profile == null) continue;
                profile.setSSLExceptionCallback(this.sslCallback);
                this.profiles.put(profile.getId(), profile);
                LOG.log(Level.FINE, "Loaded Profile: " + profile.toDetailString());
            }
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
    }

    protected synchronized AbstractProfileBase loadProfile(int id) {
        try {
            if (-1 == id) {
                return FileSystemProfile.LOCAL_FILESYSTEM_PROFILE;
            }
            AbstractProfileBase profile = null;
            ProfileType profileType = null;
            try {
                String profileTypeString = ConfigurationHelper.getStringProperty("profile." + id + ".type", EMPTYSTR);
                profileType = ProfileType.valueOf(profileTypeString);
            }
            catch (IllegalArgumentException profileTypeString) {
                // empty catch block
            }
            if (profileType == null) {
                return null;
            }
            String profileName = ConfigurationHelper.getStringProperty("profile." + id + ".name", EMPTYSTR);
            String hostname = ConfigurationHelper.getStringProperty("profile." + id + ".hostname", EMPTYSTR);
            String path = ConfigurationHelper.getStringProperty("profile." + id + ".path", "/");
            boolean isValidateCustomMetadata = ConfigurationHelper.getBooleanProperty("profile." + id + ".isValidateCustomMetadata", Boolean.TRUE);
            boolean isSSLRequired = ConfigurationHelper.getBooleanProperty("profile." + id + ".isSSLRequired", Boolean.FALSE);
            boolean isConnectByDNS = ConfigurationHelper.getBooleanProperty("profile." + id + ".isConnectByDns", Boolean.FALSE);
            String ipAddressCsv = ConfigurationHelper.getStringProperty("profile." + id + ".ipAddressList", EMPTYSTR);
            int port = ConfigurationHelper.getIntegerProperty("profile." + id + ".port", -1);
            switch (profileType) {
                case HCAP2: {
                    profile = new Hcap2Profile(id, profileName, hostname, isValidateCustomMetadata, isSSLRequired, isConnectByDNS, NetUtils.parseIpCsv(ipAddressCsv));
                    break;
                }
                case HCP_DEFAULT: {
                    profile = new Hcp3DefaultNamespaceProfile(id, profileName, hostname, isValidateCustomMetadata, isSSLRequired, isConnectByDNS, NetUtils.parseIpCsv(ipAddressCsv));
                    break;
                }
                case HCP: 
                case HCP50: 
                case HCP60: {
                    String tenant = ConfigurationHelper.getStringProperty("profile." + id + ".tenant", EMPTYSTR);
                    String namespace = ConfigurationHelper.getStringProperty("profile." + id + ".namespace", EMPTYSTR);
                    String username = ConfigurationHelper.getStringProperty("profile." + id + ".username", EMPTYSTR);
                    String password = ConfigurationHelper.getStringProperty("profile." + id + ".password", EMPTYSTR);
                    EncryptionUtils eUtils = new EncryptionUtils();
                    String decryptedPassword = eUtils.DecryptValue(password);
                    if (profileType.equals((Object)ProfileType.HCP)) {
                        profile = new Hcp3AuthNamespaceProfile(id, profileName, hostname, isValidateCustomMetadata, isSSLRequired, isConnectByDNS, NetUtils.parseIpCsv(ipAddressCsv), tenant, namespace, username, decryptedPassword);
                        break;
                    }
                    boolean isAnonymousAccess = ConfigurationHelper.getBooleanProperty("profile." + id + ".isAnonymousAccess", Boolean.FALSE);
                    if (profileType.equals((Object)ProfileType.HCP50)) {
                        if (isAnonymousAccess) {
                            profile = new Hcp5AuthNamespaceProfile(id, profileName, hostname, isValidateCustomMetadata, isSSLRequired, isConnectByDNS, NetUtils.parseIpCsv(ipAddressCsv), tenant, namespace);
                            break;
                        }
                        profile = new Hcp5AuthNamespaceProfile(id, profileName, hostname, isValidateCustomMetadata, isSSLRequired, isConnectByDNS, NetUtils.parseIpCsv(ipAddressCsv), tenant, namespace, username, decryptedPassword);
                        break;
                    }
                    profile = isAnonymousAccess ? new Hcp6AuthNamespaceProfile(id, profileName, hostname, isValidateCustomMetadata, isSSLRequired, isConnectByDNS, NetUtils.parseIpCsv(ipAddressCsv), tenant, namespace) : new Hcp6AuthNamespaceProfile(id, profileName, hostname, isValidateCustomMetadata, isSSLRequired, isConnectByDNS, NetUtils.parseIpCsv(ipAddressCsv), tenant, namespace, username, decryptedPassword);
                }
            }
            profile.setDisplayPath(path);
            if (profile instanceof HCAPProfile && port > 0) {
                ((HCAPProfile)profile).setPort(port);
            }
            return profile;
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
    }

    private synchronized int calculateMaxProfileId() {
        int maxId = 0;
        for (int id : ProfileManager.getInstance().getProfileMap().keySet()) {
            maxId = Math.max(maxId, id);
        }
        return maxId;
    }

    public static synchronized void saveProfile(AbstractProfileBase profile) throws ConfigurationException {
        try {
            LOG.log(Level.FINE, "Saving Profile: " + profile.toDetailString());
            ProfileManager.getInstance().getProfileMap().put(profile.getId(), profile);
            ProfileManager.saveProfiles();
            LOG.log(Level.FINEST, "Finished Saving Profile: " + profile.toDetailString());
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
    }

    public static synchronized void saveProfiles() throws ConfigurationException {
        LOG.log(Level.INFO, "Saving Profiles...");
        try {
            LinkedHashMap<String, String> mapping = new LinkedHashMap<String, String>();
            mapping.put("profile.highestId", EMPTYSTR + ProfileManager.getInstance().calculateMaxProfileId());
            for (Map.Entry<Integer, AbstractProfileBase> profileEntry : ProfileManager.getInstance().getProfileMap().entrySet()) {
                AbstractProfileBase profile = profileEntry.getValue();
                Map<String, Object> props = profile.toPropertyMap();
                for (Map.Entry<String, Object> propEntry : props.entrySet()) {
                    mapping.put("profile." + profile.getId() + "." + propEntry.getKey(), EMPTYSTR + propEntry.getValue());
                }
            }
            ConfigurationHelper.setUserProperties(mapping);
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
    }

    public static synchronized void deleteProfile(AbstractProfileBase profile, boolean failIfInUse) throws DatabaseException, ConfigurationException, ProfileInUseException {
        Set<String> jobsUsingProfile;
        if (failIfInUse && (jobsUsingProfile = ManagedJobsSchema.getInstance().getJobsUsingProfile(profile.getName())) != null && !jobsUsingProfile.isEmpty()) {
            throw new ProfileInUseException(jobsUsingProfile);
        }
        LOG.log(Level.FINE, "Deleting Profile: " + profile.toDetailString());
        HashSet<String> propsToDelete = new HashSet<String>();
        Map<String, Object> props = profile.toPropertyMap();
        for (Map.Entry<String, Object> propEntry : props.entrySet()) {
            propsToDelete.add("profile." + profile.getId() + "." + propEntry.getKey());
        }
        ConfigurationHelper.removeUserProperties(propsToDelete);
        ProfileManager.getInstance().getProfileMap().remove(profile.getId());
        HistoryManager.removeHistory(profile);
        LOG.log(Level.FINEST, "Finished Deleting Profile: " + profile.toDetailString());
    }
}

