/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.profile;

public enum ProfileType {
    FILESYSTEM("Local File System", 100),
    HCAP2("HCAP 2.x Archive", 200),
    HCP_DEFAULT("HCP Default Namespace", 250),
    HCP("HCP 3.0 Namespace", 300),
    HCP50("HCP 5.0 Namespace", 500),
    HCP60("HCP 6.0 Namespace", 600);

    private String displayString;
    private int apiVersion;

    private ProfileType(String displayString, int apiVersion) {
        this.displayString = displayString;
        this.apiVersion = apiVersion;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public boolean isAuthNamespace() {
        return this.equals((Object)HCP) || this.equals((Object)HCP50) || this.equals((Object)HCP60);
    }

    public boolean supportsAnonymousAccess() {
        return this.equals((Object)HCP50) || this.equals((Object)HCP60);
    }

    public boolean isLesserApiVersion(ProfileType tgt) {
        return tgt.getApiVersion() < this.getApiVersion();
    }
}

